/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GovernanceDefinitionGraph
extends GovernanceDefinitionElement {
    private List<RelatedElementStub> parents = null;
    private List<RelatedElementStub> peers = null;
    private List<RelatedElementStub> children = null;
    private List<RelatedElementStub> metrics = null;
    private List<RelatedElementStub> externalReferences = null;
    private List<RelatedElementStub> others = null;
    private String mermaidGraph = null;

    public GovernanceDefinitionGraph() {
    }

    public GovernanceDefinitionGraph(GovernanceDefinitionGraph template) {
        super(template);
        if (template != null) {
            this.parents = template.getParents();
            this.peers = template.getPeers();
            this.children = template.getChildren();
            this.metrics = template.getMetrics();
            this.externalReferences = template.getExternalReferences();
            this.others = template.getOthers();
            this.mermaidGraph = template.getMermaidGraph();
        }
    }

    public List<RelatedElementStub> getParents() {
        return this.parents;
    }

    public void setParents(List<RelatedElementStub> parents) {
        this.parents = parents;
    }

    public List<RelatedElementStub> getPeers() {
        return this.peers;
    }

    public void setPeers(List<RelatedElementStub> peers) {
        this.peers = peers;
    }

    public List<RelatedElementStub> getChildren() {
        return this.children;
    }

    public void setChildren(List<RelatedElementStub> children) {
        this.children = children;
    }

    public List<RelatedElementStub> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<RelatedElementStub> metrics) {
        this.metrics = metrics;
    }

    public List<RelatedElementStub> getExternalReferences() {
        return this.externalReferences;
    }

    public void setExternalReferences(List<RelatedElementStub> externalReferences) {
        this.externalReferences = externalReferences;
    }

    public List<RelatedElementStub> getOthers() {
        return this.others;
    }

    public void setOthers(List<RelatedElementStub> others) {
        this.others = others;
    }

    public String getMermaidGraph() {
        return this.mermaidGraph;
    }

    public void setMermaidGraph(String mermaidGraph) {
        this.mermaidGraph = mermaidGraph;
    }

    @Override
    public String toString() {
        return "GovernanceDefinitionGraph{parents=" + String.valueOf(this.parents) + ", peers=" + String.valueOf(this.peers) + ", children=" + String.valueOf(this.children) + ", metrics=" + String.valueOf(this.metrics) + ", externalReferences=" + String.valueOf(this.externalReferences) + ", others=" + String.valueOf(this.others) + ", mermaidGraph='" + this.mermaidGraph + "'} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof GovernanceDefinitionGraph)) {
            return false;
        }
        GovernanceDefinitionGraph that = (GovernanceDefinitionGraph)objectToCompare;
        if (!super.equals(objectToCompare)) {
            return false;
        }
        return Objects.equals(this.parents, that.parents) && Objects.equals(this.peers, that.peers) && Objects.equals(this.children, that.children) && Objects.equals(this.metrics, that.metrics) && Objects.equals(this.others, that.others) && Objects.equals(this.externalReferences, that.externalReferences) && Objects.equals(this.mermaidGraph, that.mermaidGraph);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parents, this.peers, this.children, this.metrics, this.externalReferences, this.others, this.mermaidGraph);
    }
}

