/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.FeedbackTargetElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.NoteProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class NoteElement
implements MetadataElement {
    private ElementHeader elementHeader = null;
    private NoteProperties properties = null;
    private Date lastUpdate = null;
    private String user = null;
    private FeedbackTargetElement feedbackTargetElement = null;

    public NoteElement() {
    }

    public NoteElement(NoteElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.properties = template.getProperties();
            this.feedbackTargetElement = template.getFeedbackTargetElement();
            this.user = template.getUser();
            Date templateLastUpdate = template.getLastUpdate();
            if (templateLastUpdate != null) {
                this.lastUpdate = new Date(templateLastUpdate.getTime());
            }
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public NoteProperties getProperties() {
        return this.properties;
    }

    public void setProperties(NoteProperties properties) {
        this.properties = properties;
    }

    public FeedbackTargetElement getFeedbackTargetElement() {
        return this.feedbackTargetElement;
    }

    public void setFeedbackTargetElement(FeedbackTargetElement feedbackTargetElement) {
        this.feedbackTargetElement = feedbackTargetElement;
    }

    public Date getLastUpdate() {
        if (this.lastUpdate == null) {
            return null;
        }
        return new Date(this.lastUpdate.getTime());
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        return "NoteElement{elementHeader=" + String.valueOf(this.elementHeader) + ", properties=" + String.valueOf(this.properties) + ", lastUpdate=" + String.valueOf(this.lastUpdate) + ", user='" + this.user + "', feedbackTargetElement=" + String.valueOf(this.feedbackTargetElement) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof NoteElement)) {
            return false;
        }
        NoteElement that = (NoteElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.properties, that.properties) && Objects.equals(this.lastUpdate, that.lastUpdate) && Objects.equals(this.user, that.user) && Objects.equals(this.feedbackTargetElement, that.feedbackTargetElement);
    }

    public int hashCode() {
        return Objects.hash(this.elementHeader, this.properties, this.feedbackTargetElement, this.user, this.lastUpdate);
    }
}

