/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.PersonalRoleElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TeamMembershipElement
extends PersonalRoleElement {
    private String position = null;
    private boolean leadershipRole = false;
    private ElementStub team = null;

    public TeamMembershipElement() {
    }

    public TeamMembershipElement(TeamMembershipElement template) {
        super(template);
        if (template != null) {
            this.position = template.getPosition();
            this.leadershipRole = template.getLeadershipRole();
            this.team = template.getTeam();
        }
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public boolean getLeadershipRole() {
        return this.leadershipRole;
    }

    public void setLeadershipRole(boolean leadershipRole) {
        this.leadershipRole = leadershipRole;
    }

    public ElementStub getTeam() {
        return this.team;
    }

    public void setTeam(ElementStub team) {
        this.team = team;
    }

    @Override
    public String toString() {
        return "TeamMembershipElement{position='" + this.position + "', leadershipRole=" + this.leadershipRole + ", team='" + String.valueOf(this.team) + "', elementHeader=" + String.valueOf(this.getElementHeader()) + ", properties=" + String.valueOf(this.getProperties()) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        TeamMembershipElement that = (TeamMembershipElement)objectToCompare;
        return this.leadershipRole == that.leadershipRole && Objects.equals(this.position, that.position) && Objects.equals(this.team, that.team);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.position, this.leadershipRole, this.team);
    }
}

