/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementClassificationHeader;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AttachedClassification
extends ElementClassificationHeader {
    private String classificationName = null;
    private Date effectiveFromTime = null;
    private Date effectiveToTime = null;
    private ElementProperties classificationProperties = null;

    public AttachedClassification() {
    }

    public AttachedClassification(AttachedClassification template) {
        super(template);
        if (template != null) {
            this.classificationName = template.getClassificationName();
            this.effectiveFromTime = template.getEffectiveFromTime();
            this.effectiveToTime = template.getEffectiveToTime();
            this.classificationProperties = template.getClassificationProperties();
        }
    }

    public void setClassificationName(String classificationName) {
        this.classificationName = classificationName;
    }

    public String getClassificationName() {
        return this.classificationName;
    }

    public Date getEffectiveFromTime() {
        return this.effectiveFromTime;
    }

    public void setEffectiveFromTime(Date effectiveFromTime) {
        this.effectiveFromTime = effectiveFromTime;
    }

    public Date getEffectiveToTime() {
        return this.effectiveToTime;
    }

    public void setEffectiveToTime(Date effectiveToTime) {
        this.effectiveToTime = effectiveToTime;
    }

    public void setClassificationProperties(ElementProperties classificationProperties) {
        this.classificationProperties = classificationProperties;
    }

    public ElementProperties getClassificationProperties() {
        return this.classificationProperties;
    }

    @Override
    public String toString() {
        return "AttachedClassification{classificationName='" + this.classificationName + "', effectiveFromTime=" + String.valueOf(this.effectiveFromTime) + ", effectiveToTime=" + String.valueOf(this.effectiveToTime) + ", classificationProperties=" + String.valueOf(this.classificationProperties) + ", classificationOrigin=" + String.valueOf(this.getClassificationOrigin()) + ", classificationOriginGUID='" + this.getClassificationOriginGUID() + "', status=" + String.valueOf(this.getStatus()) + ", type=" + String.valueOf(this.getType()) + ", origin=" + String.valueOf(this.getOrigin()) + ", versions=" + String.valueOf(this.getVersions()) + ", headerVersion=" + this.getHeaderVersion() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AttachedClassification that = (AttachedClassification)objectToCompare;
        return Objects.equals(this.classificationName, that.classificationName) && Objects.equals(this.effectiveFromTime, that.effectiveFromTime) && Objects.equals(this.effectiveToTime, that.effectiveToTime) && Objects.equals(this.classificationProperties, that.classificationProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.classificationName, this.effectiveFromTime, this.effectiveToTime, this.classificationProperties);
    }
}

