/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataTypeDef;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataTypeDefCategory;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataTypeDefLink;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenMetadataClassificationDef
extends OpenMetadataTypeDef {
    private List<OpenMetadataTypeDefLink> validEntityDefs = null;
    private boolean propagatable = false;

    public OpenMetadataClassificationDef() {
        super(OpenMetadataTypeDefCategory.CLASSIFICATION_DEF);
    }

    public OpenMetadataClassificationDef(OpenMetadataTypeDefCategory category, String guid, String name, long version, String versionName) {
        super(category, guid, name, version, versionName);
    }

    public OpenMetadataClassificationDef(OpenMetadataClassificationDef template) {
        super(template);
        if (template != null) {
            this.setValidEntityDefs(template.getValidEntityDefs());
            this.propagatable = template.isPropagatable();
        }
    }

    @Override
    public OpenMetadataTypeDef cloneFromSubclass() {
        return new OpenMetadataClassificationDef(this);
    }

    public List<OpenMetadataTypeDefLink> getValidEntityDefs() {
        return this.validEntityDefs;
    }

    public void setValidEntityDefs(List<OpenMetadataTypeDefLink> validEntityDefs) {
        this.validEntityDefs = validEntityDefs;
    }

    public boolean isPropagatable() {
        return this.propagatable;
    }

    public void setPropagatable(boolean propagatable) {
        this.propagatable = propagatable;
    }

    @Override
    public String toString() {
        return "OpenMetadataClassificationDef{name='" + this.name + "', validEntityDefs=" + String.valueOf(this.validEntityDefs) + ", propagatable=" + this.propagatable + ", superType=" + String.valueOf(this.superType) + ", description='" + this.description + "', descriptionGUID='" + this.descriptionGUID + "', descriptionWiki='" + this.descriptionWiki + "', origin='" + this.origin + "', createdBy='" + this.createdBy + "', updatedBy='" + this.updatedBy + "', createTime=" + String.valueOf(this.createTime) + ", updateTime=" + String.valueOf(this.updateTime) + ", options=" + String.valueOf(this.options) + ", externalStandardTypeMappings=" + String.valueOf(this.externalStandardTypeMappings) + ", validInstanceStatusList=" + String.valueOf(this.validElementStatusList) + ", initialStatus=" + String.valueOf(this.initialStatus) + ", propertiesDefinition=" + String.valueOf(this.attributeDefinitions) + ", version=" + this.version + ", versionName='" + this.versionName + "', category=" + String.valueOf((Object)this.category) + ", guid='" + this.guid + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OpenMetadataClassificationDef that = (OpenMetadataClassificationDef)objectToCompare;
        return this.propagatable == that.propagatable && Objects.equals(this.validEntityDefs, that.validEntityDefs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.validEntityDefs, this.propagatable);
    }
}

