/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenMetadataElement
extends ElementControlHeader {
    private String elementGUID = null;
    private Date effectiveFromTime = null;
    private Date effectiveToTime = null;
    private List<AttachedClassification> classifications = null;
    private ElementProperties elementProperties = null;

    public OpenMetadataElement() {
    }

    public OpenMetadataElement(OpenMetadataElement template) {
        super(template);
        if (template != null) {
            this.elementGUID = template.getElementGUID();
            this.effectiveFromTime = template.getEffectiveFromTime();
            this.effectiveToTime = template.getEffectiveToTime();
            this.classifications = template.getClassifications();
            this.elementProperties = template.getElementProperties();
        }
    }

    public String getElementGUID() {
        return this.elementGUID;
    }

    public void setElementGUID(String guid) {
        this.elementGUID = guid;
    }

    public Date getEffectiveFromTime() {
        return this.effectiveFromTime;
    }

    public void setEffectiveFromTime(Date effectiveFromTime) {
        this.effectiveFromTime = effectiveFromTime;
    }

    public Date getEffectiveToTime() {
        return this.effectiveToTime;
    }

    public void setEffectiveToTime(Date effectiveToTime) {
        this.effectiveToTime = effectiveToTime;
    }

    public List<AttachedClassification> getClassifications() {
        return this.classifications;
    }

    public void setClassifications(List<AttachedClassification> classifications) {
        this.classifications = classifications;
    }

    public ElementProperties getElementProperties() {
        return this.elementProperties;
    }

    public void setElementProperties(ElementProperties elementProperties) {
        this.elementProperties = elementProperties;
    }

    @Override
    public String toString() {
        return "OpenMetadataElement{elementGUID='" + this.elementGUID + "', effectiveFromTime=" + String.valueOf(this.effectiveFromTime) + ", effectiveToTime=" + String.valueOf(this.effectiveToTime) + ", classifications=" + String.valueOf(this.classifications) + ", elementProperties=" + String.valueOf(this.elementProperties) + ", status=" + String.valueOf(this.getStatus()) + ", type=" + String.valueOf(this.getType()) + ", origin=" + String.valueOf(this.getOrigin()) + ", versions=" + String.valueOf(this.getVersions()) + ", headerVersion=" + this.getHeaderVersion() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OpenMetadataElement that = (OpenMetadataElement)objectToCompare;
        return Objects.equals(this.elementGUID, that.elementGUID) && Objects.equals(this.effectiveFromTime, that.effectiveFromTime) && Objects.equals(this.effectiveToTime, that.effectiveToTime) && Objects.equals(this.classifications, that.classifications) && Objects.equals(this.elementProperties, that.elementProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementGUID, this.effectiveFromTime, this.effectiveToTime, this.classifications, this.elementProperties);
    }
}

