/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.actions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ToDoStatus;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ToDoProperties
extends ReferenceableProperties {
    private String name = null;
    private String description = null;
    private String toDoType = null;
    private Date creationTime = null;
    private int priority = 0;
    private Date dueTime = null;
    private Date lastReviewTime = null;
    private Date completionTime = null;
    private ToDoStatus toDoStatus = ToDoStatus.OPEN;

    public ToDoProperties() {
    }

    public ToDoProperties(ToDoProperties template) {
        super(template);
        if (template != null) {
            this.name = template.getName();
            this.description = template.getDescription();
            this.toDoType = template.getToDoType();
            this.creationTime = template.getCreationTime();
            this.priority = template.getPriority();
            this.lastReviewTime = template.getLastReviewTime();
            this.dueTime = template.getDueTime();
            this.completionTime = template.getCompletionTime();
            this.toDoStatus = template.getToDoStatus();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getToDoType() {
        return this.toDoType;
    }

    public void setToDoType(String toDoType) {
        this.toDoType = toDoType;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Date getLastReviewTime() {
        return this.lastReviewTime;
    }

    public void setLastReviewTime(Date lastReviewTime) {
        this.lastReviewTime = lastReviewTime;
    }

    public Date getDueTime() {
        return this.dueTime;
    }

    public void setDueTime(Date dueTime) {
        this.dueTime = dueTime;
    }

    public Date getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(Date completionTime) {
        this.completionTime = completionTime;
    }

    public ToDoStatus getToDoStatus() {
        return this.toDoStatus;
    }

    public void setToDoStatus(ToDoStatus toDoStatus) {
        this.toDoStatus = toDoStatus;
    }

    @Override
    public String toString() {
        return "ToDoProperties{name='" + this.name + "', description='" + this.description + "', creationTime=" + String.valueOf(this.creationTime) + ", priority=" + this.priority + ", lastReviewTime=" + String.valueOf(this.lastReviewTime) + ", dueTime=" + String.valueOf(this.dueTime) + ", completionTime=" + String.valueOf(this.completionTime) + ", status=" + String.valueOf(this.toDoStatus) + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ", effectiveFrom=" + String.valueOf(this.getEffectiveFrom()) + ", effectiveTo=" + String.valueOf(this.getEffectiveTo()) + ", vendorProperties=" + String.valueOf(this.getVendorProperties()) + ", typeName='" + this.getTypeName() + "', extendedProperties=" + String.valueOf(this.getExtendedProperties()) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ToDoProperties that = (ToDoProperties)objectToCompare;
        return this.priority == that.priority && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.creationTime, that.creationTime) && Objects.equals(this.lastReviewTime, that.lastReviewTime) && Objects.equals(this.dueTime, that.dueTime) && Objects.equals(this.completionTime, that.completionTime) && this.toDoStatus == that.toDoStatus;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getDescription(), this.getCreationTime(), this.getPriority(), this.getLastReviewTime(), this.getDueTime(), this.getCompletionTime(), this.getToDoStatus(), this.getExtendedProperties(), this.getAdditionalProperties());
    }
}

