/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.assets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ClassificationProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetOriginProperties
extends ClassificationProperties {
    private String organizationGUID = null;
    private String businessCapabilityGUID = null;
    private Map<String, String> otherOriginValues = null;

    public AssetOriginProperties() {
    }

    public AssetOriginProperties(AssetOriginProperties template) {
        if (template != null) {
            this.organizationGUID = template.getOrganizationGUID();
            this.businessCapabilityGUID = template.getBusinessCapabilityGUID();
            this.otherOriginValues = template.getOtherOriginValues();
        }
    }

    public String getOrganizationGUID() {
        return this.organizationGUID;
    }

    public void setOrganizationGUID(String organizationGUID) {
        this.organizationGUID = organizationGUID;
    }

    public String getBusinessCapabilityGUID() {
        return this.businessCapabilityGUID;
    }

    public void setBusinessCapabilityGUID(String businessCapabilityGUID) {
        this.businessCapabilityGUID = businessCapabilityGUID;
    }

    public Map<String, String> getOtherOriginValues() {
        if (this.otherOriginValues == null) {
            return null;
        }
        if (this.otherOriginValues.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.otherOriginValues);
    }

    public void setOtherOriginValues(Map<String, String> otherOriginValues) {
        this.otherOriginValues = otherOriginValues;
    }

    @Override
    public String toString() {
        return "AssetOriginProperties{organizationGUID='" + this.organizationGUID + "', businessCapabilityGUID='" + this.businessCapabilityGUID + "', otherOriginValues=" + String.valueOf(this.otherOriginValues) + ", effectiveFrom=" + String.valueOf(this.getEffectiveFrom()) + ", effectiveTo=" + String.valueOf(this.getEffectiveTo()) + ", extendedProperties=" + String.valueOf(this.getExtendedProperties()) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetOriginProperties)) {
            return false;
        }
        AssetOriginProperties that = (AssetOriginProperties)objectToCompare;
        return Objects.equals(this.organizationGUID, that.organizationGUID) && Objects.equals(this.businessCapabilityGUID, that.businessCapabilityGUID) && Objects.equals(this.otherOriginValues, that.otherOriginValues);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getOrganizationGUID(), this.getBusinessCapabilityGUID(), this.getOtherOriginValues());
    }
}

