/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.contextevents;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.SupplementaryProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContextEventProperties
extends SupplementaryProperties {
    private String name = null;
    private String contextEventType = null;
    private String eventEffect = null;
    private String eventDescription = null;
    private Date plannedStartDate = null;
    private Date actualStartDate = null;
    private long plannedDuration = 0L;
    private long actualDuration = 0L;
    private long repeatInterval = 0L;
    private Date plannedCompletionDate = null;
    private Date actualCompletionDate = null;
    private Date referenceEffectiveFrom = null;
    private Date referenceEffectiveTo = null;

    public ContextEventProperties() {
    }

    public ContextEventProperties(ContextEventProperties template) {
        super(template);
        if (template != null) {
            this.name = template.getName();
            this.contextEventType = template.getContextEventType();
            this.eventEffect = template.getEventEffect();
            this.eventDescription = template.getEventDescription();
            this.plannedStartDate = template.getPlannedStartDate();
            this.actualStartDate = template.getActualStartDate();
            this.plannedDuration = template.getPlannedDuration();
            this.actualDuration = template.getActualDuration();
            this.repeatInterval = template.getRepeatInterval();
            this.plannedCompletionDate = template.getPlannedCompletionDate();
            this.actualCompletionDate = template.getActualCompletionDate();
            this.referenceEffectiveFrom = template.getReferenceEffectiveFrom();
            this.referenceEffectiveTo = template.getReferenceEffectiveTo();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContextEventType() {
        return this.contextEventType;
    }

    public void setContextEventType(String contextEventType) {
        this.contextEventType = contextEventType;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            return this.getName();
        }
        return this.displayName;
    }

    public String getEventEffect() {
        return this.eventEffect;
    }

    public void setEventEffect(String eventEffect) {
        this.eventEffect = eventEffect;
    }

    public String getEventDescription() {
        return this.eventDescription;
    }

    public void setEventDescription(String eventDescription) {
        this.eventDescription = eventDescription;
    }

    @Override
    public String getDisplayDescription() {
        if (this.displayDescription == null) {
            return this.getEventDescription();
        }
        return this.displayDescription;
    }

    public Date getPlannedStartDate() {
        return this.plannedStartDate;
    }

    public void setPlannedStartDate(Date plannedStartDate) {
        this.plannedStartDate = plannedStartDate;
    }

    public Date getActualStartDate() {
        return this.actualStartDate;
    }

    public void setActualStartDate(Date actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    public long getPlannedDuration() {
        return this.plannedDuration;
    }

    public void setPlannedDuration(long plannedDuration) {
        this.plannedDuration = plannedDuration;
    }

    public long getActualDuration() {
        return this.actualDuration;
    }

    public void setActualDuration(long actualDuration) {
        this.actualDuration = actualDuration;
    }

    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public Date getPlannedCompletionDate() {
        return this.plannedCompletionDate;
    }

    public void setPlannedCompletionDate(Date plannedCompletionDate) {
        this.plannedCompletionDate = plannedCompletionDate;
    }

    public Date getActualCompletionDate() {
        return this.actualCompletionDate;
    }

    public void setActualCompletionDate(Date actualCompletionDate) {
        this.actualCompletionDate = actualCompletionDate;
    }

    public Date getReferenceEffectiveFrom() {
        return this.referenceEffectiveFrom;
    }

    public void setReferenceEffectiveFrom(Date referenceEffectiveFrom) {
        this.referenceEffectiveFrom = referenceEffectiveFrom;
    }

    public Date getReferenceEffectiveTo() {
        return this.referenceEffectiveTo;
    }

    public void setReferenceEffectiveTo(Date referenceEffectiveTo) {
        this.referenceEffectiveTo = referenceEffectiveTo;
    }

    @Override
    public String toString() {
        return "ContextEventProperties{name='" + this.name + "', contextEventType='" + this.contextEventType + "', eventEffect='" + this.eventEffect + "', eventDescription='" + this.eventDescription + "', plannedStartDate=" + String.valueOf(this.plannedStartDate) + ", actualStartDate=" + String.valueOf(this.actualStartDate) + ", plannedDuration=" + this.plannedDuration + ", actualDuration=" + this.actualDuration + ", repeatInterval=" + this.repeatInterval + ", plannedCompletionDate=" + String.valueOf(this.plannedCompletionDate) + ", actualCompletionDate=" + String.valueOf(this.actualCompletionDate) + ", referenceEffectiveFrom=" + String.valueOf(this.referenceEffectiveFrom) + ", referenceEffectiveTo=" + String.valueOf(this.referenceEffectiveTo) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ContextEventProperties that = (ContextEventProperties)objectToCompare;
        return this.plannedDuration == that.plannedDuration && this.actualDuration == that.actualDuration && this.repeatInterval == that.repeatInterval && Objects.equals(this.name, that.name) && Objects.equals(this.contextEventType, that.contextEventType) && Objects.equals(this.eventEffect, that.eventEffect) && Objects.equals(this.eventDescription, that.eventDescription) && Objects.equals(this.plannedStartDate, that.plannedStartDate) && Objects.equals(this.actualStartDate, that.actualStartDate) && Objects.equals(this.plannedCompletionDate, that.plannedCompletionDate) && Objects.equals(this.actualCompletionDate, that.actualCompletionDate) && Objects.equals(this.referenceEffectiveFrom, that.referenceEffectiveFrom) && Objects.equals(this.referenceEffectiveTo, that.referenceEffectiveTo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.contextEventType, this.eventEffect, this.eventDescription, this.plannedStartDate, this.actualStartDate, this.plannedDuration, this.actualDuration, this.repeatInterval, this.plannedCompletionDate, this.actualCompletionDate, this.referenceEffectiveFrom, this.referenceEffectiveTo);
    }
}

