/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataClassProperties
extends ReferenceableProperties {
    private String displayName = null;
    private String description = null;
    private List<String> matchPropertyNames = null;
    private String namespace = null;
    private int matchThreshold = 100;
    private String specification = null;
    private Map<String, String> specificationDetails = null;
    private String dataType = null;
    private boolean allowsDuplicateValues = true;
    private boolean isCaseSensitive = false;
    private boolean isNullable = true;
    private String defaultValue = null;
    private String averageValue = null;
    private List<String> valueList = null;
    private String valueRangeFrom = null;
    private String valueRangeTo = null;
    private List<String> sampleValues = null;
    private List<String> dataPatterns = null;

    public DataClassProperties() {
    }

    public DataClassProperties(DataClassProperties template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.matchPropertyNames = template.getMatchPropertyNames();
            this.namespace = template.getNamespace();
            this.specification = template.getSpecification();
            this.specificationDetails = template.getSpecificationDetails();
            this.dataType = template.getDataType();
            this.matchThreshold = template.getMatchThreshold();
            this.allowsDuplicateValues = template.getAllowsDuplicateValues();
            this.isCaseSensitive = template.getIsCaseSensitive();
            this.isNullable = template.getIsNullable();
            this.defaultValue = template.getDefaultValue();
            this.valueList = template.getValueList();
            this.averageValue = template.getAverageValue();
            this.valueRangeFrom = template.getValueRangeFrom();
            this.valueRangeTo = template.getValueRangeTo();
            this.sampleValues = template.getSampleValues();
            this.dataPatterns = template.getDataPatterns();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getMatchPropertyNames() {
        return this.matchPropertyNames;
    }

    public void setMatchPropertyNames(List<String> matchPropertyNames) {
        this.matchPropertyNames = matchPropertyNames;
    }

    public int getMatchThreshold() {
        return this.matchThreshold;
    }

    public void setMatchThreshold(int matchThreshold) {
        this.matchThreshold = matchThreshold;
    }

    public String getSpecification() {
        return this.specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public Map<String, String> getSpecificationDetails() {
        return this.specificationDetails;
    }

    public void setSpecificationDetails(Map<String, String> specificationDetails) {
        this.specificationDetails = specificationDetails;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public boolean getAllowsDuplicateValues() {
        return this.allowsDuplicateValues;
    }

    public void setAllowsDuplicateValues(boolean allowsDuplicateValues) {
        this.allowsDuplicateValues = allowsDuplicateValues;
    }

    public boolean getIsCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setIsCaseSensitive(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    public boolean getIsNullable() {
        return this.isNullable;
    }

    public void setIsNullable(boolean nullable) {
        this.isNullable = nullable;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public List<String> getValueList() {
        return this.valueList;
    }

    public void setValueList(List<String> valueList) {
        this.valueList = valueList;
    }

    public String getValueRangeFrom() {
        return this.valueRangeFrom;
    }

    public void setValueRangeFrom(String valueRangeFrom) {
        this.valueRangeFrom = valueRangeFrom;
    }

    public String getValueRangeTo() {
        return this.valueRangeTo;
    }

    public void setValueRangeTo(String valueRangeTo) {
        this.valueRangeTo = valueRangeTo;
    }

    public String getAverageValue() {
        return this.averageValue;
    }

    public void setAverageValue(String averageValue) {
        this.averageValue = averageValue;
    }

    public List<String> getSampleValues() {
        return this.sampleValues;
    }

    public void setSampleValues(List<String> sampleValues) {
        this.sampleValues = sampleValues;
    }

    public List<String> getDataPatterns() {
        return this.dataPatterns;
    }

    public void setDataPatterns(List<String> dataPatterns) {
        this.dataPatterns = dataPatterns;
    }

    @Override
    public String toString() {
        return "DataClassProperties{displayName='" + this.displayName + "', description='" + this.description + "', matchPropertyNames=" + String.valueOf(this.matchPropertyNames) + ", namespace='" + this.namespace + "', matchThreshold=" + this.matchThreshold + ", specification='" + this.specification + "', specificationDetails=" + String.valueOf(this.specificationDetails) + ", dataType='" + this.dataType + "', allowsDuplicateValues=" + this.allowsDuplicateValues + ", isCaseSensitive=" + this.isCaseSensitive + ", isNullable=" + this.isNullable + ", defaultValue='" + this.defaultValue + "', averageValue='" + this.averageValue + "', valueList=" + String.valueOf(this.valueList) + ", valueRangeFrom='" + this.valueRangeFrom + "', valueRangeTo='" + this.valueRangeTo + "', sampleValues=" + String.valueOf(this.sampleValues) + ", dataPatterns=" + String.valueOf(this.dataPatterns) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataClassProperties that = (DataClassProperties)objectToCompare;
        return this.allowsDuplicateValues == that.allowsDuplicateValues && this.isNullable == that.isNullable && this.isCaseSensitive == that.isCaseSensitive && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.matchPropertyNames, that.matchPropertyNames) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.matchThreshold, that.matchThreshold) && Objects.equals(this.specification, that.specification) && Objects.equals(this.specificationDetails, that.specificationDetails) && Objects.equals(this.dataType, that.dataType) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.averageValue, that.averageValue) && Objects.equals(this.valueList, that.valueList) && Objects.equals(this.valueRangeFrom, that.valueRangeFrom) && Objects.equals(this.valueRangeTo, that.valueRangeTo) && Objects.equals(this.sampleValues, that.sampleValues) && Objects.equals(this.dataPatterns, that.dataPatterns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.displayName, this.description, this.matchPropertyNames, this.namespace, this.matchThreshold, this.specification, this.specificationDetails, this.dataType, this.allowsDuplicateValues, this.isCaseSensitive, this.isNullable, this.defaultValue, this.averageValue, this.valueList, this.valueRangeFrom, this.valueRangeTo, this.sampleValues, this.dataPatterns);
    }
}

