/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.datadictionaries;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataFieldProperties
extends ReferenceableProperties {
    private String displayName = null;
    private String namespace = null;
    private List<String> aliases = null;
    private List<String> namePatterns = null;
    private String description = null;
    private boolean isDeprecated = false;
    private String versionIdentifier = null;
    private String defaultValue = null;
    private boolean isNullable = true;
    private String dataType = null;
    private String units = null;
    private int minimumLength = 0;
    private int length = 0;
    private int precision = 0;
    private boolean orderedValues = false;
    private DataItemSortOrder sortOrder = null;

    public DataFieldProperties() {
    }

    public DataFieldProperties(DataFieldProperties template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.namespace = template.getNamespace();
            this.aliases = template.getAliases();
            this.namePatterns = template.getNamePatterns();
            this.description = template.getDescription();
            this.isDeprecated = template.getIsDeprecated();
            this.versionIdentifier = template.getVersionIdentifier();
            this.defaultValue = template.getDefaultValue();
            this.isNullable = template.getIsNullable();
            this.dataType = template.getDataType();
            this.units = template.getUnits();
            this.minimumLength = template.getMinimumLength();
            this.length = template.getLength();
            this.precision = template.getPrecision();
            this.orderedValues = template.getOrderedValues();
            this.sortOrder = template.getSortOrder();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public List<String> getNamePatterns() {
        return this.namePatterns;
    }

    public void setNamePatterns(List<String> namePatterns) {
        this.namePatterns = namePatterns;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getIsDeprecated() {
        return this.isDeprecated;
    }

    public void setIsDeprecated(boolean deprecated) {
        this.isDeprecated = deprecated;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public void setVersionIdentifier(String versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean getIsNullable() {
        return this.isNullable;
    }

    public void setIsNullable(boolean nullable) {
        this.isNullable = nullable;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public void setMinimumLength(int minimumLength) {
        this.minimumLength = minimumLength;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean getOrderedValues() {
        return this.orderedValues;
    }

    public void setOrderedValues(boolean orderedValues) {
        this.orderedValues = orderedValues;
    }

    public DataItemSortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(DataItemSortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public String toString() {
        return "DataFieldProperties{displayName='" + this.displayName + "', namespace='" + this.namespace + "', aliases=" + String.valueOf(this.aliases) + ", namePatterns=" + String.valueOf(this.namePatterns) + ", description='" + this.description + "', isDeprecated=" + this.isDeprecated + ", versionIdentifier='" + this.versionIdentifier + "', defaultValue='" + this.defaultValue + "', isNullable=" + this.isNullable + ", dataType='" + this.dataType + "', units='" + this.units + "', minimumLength=" + this.minimumLength + ", length=" + this.length + ", precision=" + this.precision + ", orderedValues=" + this.orderedValues + ", sortOrder=" + String.valueOf(this.sortOrder) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataFieldProperties that = (DataFieldProperties)objectToCompare;
        return this.isDeprecated == that.isDeprecated && this.isNullable == that.isNullable && this.minimumLength == that.minimumLength && this.length == that.length && this.precision == that.precision && this.orderedValues == that.orderedValues && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.aliases, that.aliases) && Objects.equals(this.namePatterns, that.namePatterns) && Objects.equals(this.description, that.description) && Objects.equals(this.versionIdentifier, that.versionIdentifier) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.dataType, that.dataType) && Objects.equals(this.units, that.units) && this.sortOrder == that.sortOrder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.displayName, this.namespace, this.aliases, this.namePatterns, this.description, this.isDeprecated, this.versionIdentifier, this.defaultValue, this.isNullable, this.dataType, this.units, this.minimumLength, this.length, this.precision, this.orderedValues, this.sortOrder);
    }
}

