/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ValidValuesImplProperties
extends RelationshipProperties {
    private String symbolicName = null;
    private String implementationValue = null;
    private Map<String, String> additionalValues = null;

    public ValidValuesImplProperties() {
    }

    public ValidValuesImplProperties(ValidValuesImplProperties template) {
        super(template);
        if (template != null) {
            this.symbolicName = template.getSymbolicName();
            this.implementationValue = template.getImplementationValue();
            this.additionalValues = template.getAdditionalValues();
        }
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public String getImplementationValue() {
        return this.implementationValue;
    }

    public void setImplementationValue(String implementationValue) {
        this.implementationValue = implementationValue;
    }

    public Map<String, String> getAdditionalValues() {
        if (this.additionalValues == null) {
            return null;
        }
        if (this.additionalValues.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.additionalValues);
    }

    public void setAdditionalValues(Map<String, String> additionalValues) {
        this.additionalValues = additionalValues;
    }

    @Override
    public String toString() {
        return "ValidValuesImplProperties{effectiveFrom=" + String.valueOf(this.getEffectiveFrom()) + ", effectiveTo=" + String.valueOf(this.getEffectiveTo()) + ", extendedProperties=" + String.valueOf(this.getExtendedProperties()) + ", symbolicName='" + this.symbolicName + "', implementationValue='" + this.implementationValue + "', additionalValues=" + String.valueOf(this.additionalValues) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ValidValuesImplProperties asset = (ValidValuesImplProperties)objectToCompare;
        return Objects.equals(this.getSymbolicName(), asset.getSymbolicName()) && Objects.equals(this.getImplementationValue(), asset.getImplementationValue()) && Objects.equals(this.getAdditionalValues(), asset.getAdditionalValues());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSymbolicName(), this.getImplementationValue(), this.getAdditionalValues());
    }
}

