/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.refdata;

import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public enum ProjectStatus {
    PROPOSED("Proposed", "This project has been proposed but there is no agreement to allocate resources or proceed."),
    APPROVED("Approved", "This project has be approved to go ahead.  Resources a approved for it in principle, but specific resources may not have been allocated yet."),
    PLANNED("Planned", "This project has an outline project plan and timeline.  Resources have been allocated."),
    ACTIVATING("Activating", "This project is in final preparations to start."),
    ACTIVE("Active", "The project is currently being worked on by the project team."),
    STALLED("Stalled", "This project is not able to make progress because of an external factor."),
    COMPLETED("Completed", "Work on the project has finished, and all deliverables have either been completed, abandoned or moved to a different project."),
    CANCELLED("Cancelled", "Work on the project will not continue despite incomplete deliverables.  This may be due to a change in direction or a road block that is preventing further progress."),
    ON_HOLD("On Hold", "The project has not finished, and work on the project has been temporarily suspended.");

    private final String name;
    private final String description;

    private ProjectStatus(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(null, OpenMetadataProperty.PROJECT_STATUS.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(null, OpenMetadataProperty.PROJECT_STATUS.name, null);
    }

    public String toString() {
        return "ProjectStatus{" + this.name + "}";
    }
}

