/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.refdata;

import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public enum SolutionComponentType {
    AUTOMATED_PROCESS("Automated Process", "An automated process that is implemented by some form of software."),
    THIRD_PARTY_PROCESS("Third Party Process", "A process that is implemented by a third party and is opaque to the solution."),
    MANUAL_PROCESS("Manual Process", "A set of tasks that need to be preformed by individuals or teams of people."),
    DATA_STORAGE("Data Storage", "The storage of data for later retrieval by automated processes."),
    DATA_DISTRIBUTION("Data Distribution", "A distribution of data to a variety of automated processes."),
    DOCUMENT_PUBLISHING("Publishing", "The publishing of information (typically documents) to third parties."),
    INSIGHT_MODEL("Insight Model", "A trained model using analytical or AI techniques to generate insight from data.");

    private final String solutionComponentType;
    private final String description;

    private SolutionComponentType(String solutionComponentType, String description) {
        this.solutionComponentType = solutionComponentType;
        this.description = description;
    }

    public String getSolutionComponentType() {
        return this.solutionComponentType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(null, OpenMetadataProperty.SOLUTION_COMPONENT_TYPE.name, null, this.solutionComponentType);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(null, OpenMetadataProperty.SOLUTION_COMPONENT_TYPE.name, null);
    }

    public String toString() {
        return "SolutionComponentType{" + this.solutionComponentType + "}";
    }
}

