/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ElementProperties {
    private Map<String, PropertyValue> propertyValueMap = new HashMap<String, PropertyValue>();

    public ElementProperties() {
    }

    public ElementProperties(ElementProperties templateProperties) {
        Iterator<String> propertyNames;
        if (templateProperties != null && (propertyNames = templateProperties.getPropertyNames()) != null) {
            while (propertyNames.hasNext()) {
                String newPropertyName = propertyNames.next();
                PropertyValue newPropertyValue = templateProperties.getPropertyValue(newPropertyName);
                this.propertyValueMap.put(newPropertyName, newPropertyValue);
            }
        }
    }

    public Map<String, PropertyValue> getPropertyValueMap() {
        if (this.propertyValueMap == null) {
            return null;
        }
        if (this.propertyValueMap.isEmpty()) {
            return null;
        }
        return new HashMap<String, PropertyValue>(this.propertyValueMap);
    }

    public void setPropertyValueMap(Map<String, PropertyValue> propertyValueMap) {
        this.propertyValueMap = propertyValueMap == null ? new HashMap<String, PropertyValue>() : propertyValueMap;
    }

    public Iterator<String> getPropertyNames() {
        return this.propertyValueMap.keySet().iterator();
    }

    public PropertyValue getPropertyValue(String name) {
        return this.propertyValueMap.get(name);
    }

    public void setProperty(String newPropertyName, PropertyValue newPropertyValue) {
        String propertyName = "null";
        if (newPropertyName != null) {
            propertyName = newPropertyName;
        }
        if (newPropertyValue == null) {
            this.propertyValueMap.remove(propertyName);
        } else {
            this.propertyValueMap.put(propertyName, newPropertyValue);
        }
    }

    public int getPropertyCount() {
        return this.propertyValueMap.size();
    }

    public Map<String, String> getPropertiesAsStrings() {
        if (this.propertyValueMap != null && !this.propertyValueMap.isEmpty()) {
            HashMap<String, String> stringStringMap = new HashMap<String, String>();
            for (String propertyName : this.propertyValueMap.keySet()) {
                stringStringMap.put(propertyName, this.propertyValueMap.get(propertyName).valueAsString());
            }
            return stringStringMap;
        }
        return null;
    }

    public String toString() {
        return "ElementProperties{propertyNames=" + String.valueOf(this.getPropertyNames()) + ", propertyCount=" + this.getPropertyCount() + ", propertyValues=" + String.valueOf(this.propertyValueMap) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ElementProperties)) {
            return false;
        }
        ElementProperties that = (ElementProperties)objectToCompare;
        return Objects.equals(this.getPropertyValueMap(), that.getPropertyValueMap());
    }

    public int hashCode() {
        return Objects.hash(this.getPropertyValueMap());
    }
}

