/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.controls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationTypeType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum SurveyResourceManagerAnnotationType implements AnnotationType
{
    RESOURCE_LIST("Capture List of Resources", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the list of visible elements in the surveyed resource manager.", "The name used for the resource is its fully qualified name with respect to the resource manager.", SurveyResourceManagerAnnotationType.getProfilePropertiesPropertyName(), null),
    RESOURCE_INVENTORY("Resource Manager Inventory", OpenMetadataType.RESOURCE_PROFILE_LOG_ANNOTATION.typeName, "Log file of resources known to the resource manager.", "The list of resources known to the resource manager is pushed to an external log file for analysis.", null, null),
    FUNCTION_LIST("Capture List of Executable Functions", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the list of visible functions in the surveyed resource (manager).", "Functions are listed by their full name, with respect to the resource manager.  If functions are missing, check the security permissions of the survey service's userId.", SurveyResourceManagerAnnotationType.getProfilePropertiesPropertyName(), null),
    VOLUME_LIST("Capture List of File Volumes", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the list of visible file-based volumes in the surveyed resource (manager).", "Volumes are listed by their full name, with respect to the resource manager.  If volumes are missing, check the security permissions of the survey service's userId.", SurveyResourceManagerAnnotationType.getProfilePropertiesPropertyName(), null),
    MODEL_LIST("Capture List of Analytical Models", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the list of visible analytical models in the surveyed resource (manager).", "Models are listed by their full name, with respect to the resource manager.  If models are missing, check the security permissions of the survey service's userId.", null, null),
    API_LIST("Capture List of Remote APIs", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the list of visible callable APIs in the surveyed resource (manager).", "APIs are listed by their full name, with respect to the resource manager.  If APIs are missing, check the security permissions of the survey service's userId.", null, null);

    public final String name;
    public final String openMetadataTypeName;
    public final String summary;
    public final String explanation;
    public final List<String> profilePropertyNames;
    public final List<SurveyMetric> metrics;

    private SurveyResourceManagerAnnotationType(String name, String openMetadataTypeName, String summary, String explanation, List<String> profilePropertyNames, List<SurveyMetric> metrics) {
        this.name = name;
        this.openMetadataTypeName = openMetadataTypeName;
        this.summary = summary;
        this.explanation = explanation;
        this.profilePropertyNames = profilePropertyNames;
        this.metrics = metrics;
    }

    private static List<String> getProfilePropertiesPropertyName() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(OpenMetadataProperty.PROFILE_PROPERTIES.name);
        return propertyNames;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAnalysisStep() {
        return AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName();
    }

    @Override
    public String getOpenMetadataTypeName() {
        return this.openMetadataTypeName;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public String getExplanation() {
        return this.explanation;
    }

    @Override
    public String getExpression() {
        return null;
    }

    public List<String> getProfilePropertyNames() {
        return this.profilePropertyNames;
    }

    public AnnotationTypeType getAnnotationTypeType() {
        AnnotationTypeType annotationTypeType = new AnnotationTypeType();
        annotationTypeType.setName(this.name);
        annotationTypeType.setOpenMetadataTypeName(this.openMetadataTypeName);
        annotationTypeType.setAnalysisStepName(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
        annotationTypeType.setSummary(this.summary);
        annotationTypeType.setExplanation(this.explanation);
        if (this.metrics != null) {
            HashMap<String, String> metricsMap = new HashMap<String, String>();
            for (SurveyMetric relationalDatabaseMetric : this.metrics) {
                metricsMap.put(relationalDatabaseMetric.getDisplayName(), relationalDatabaseMetric.getDescription());
            }
            annotationTypeType.setOtherPropertyValues(metricsMap);
        }
        return annotationTypeType;
    }

    public String toString() {
        return "SurveyResourceManagerAnnotationType{ name='" + this.name + "}";
    }
}

