/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceMeasureAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ResourcePhysicalStatusAnnotation
extends ResourceMeasureAnnotation {
    private Date createTime = null;
    private Date modifiedTime = null;
    private Date lastAccessedTime = null;
    private long size = 0L;
    private String encoding = null;

    public ResourcePhysicalStatusAnnotation() {
    }

    public ResourcePhysicalStatusAnnotation(ResourcePhysicalStatusAnnotation template) {
        super(template);
        if (template != null) {
            this.createTime = template.getCreateTime();
            this.modifiedTime = template.getModifiedTime();
            this.lastAccessedTime = template.getLastAccessedTime();
            this.size = template.getSize();
            this.encoding = template.getEncoding();
        }
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public Date getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setLastAccessedTime(Date lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String toString() {
        return "ResourcePhysicalStatusAnnotation{createTime=" + String.valueOf(this.createTime) + ", modifiedTime=" + String.valueOf(this.modifiedTime) + ", lastUpdateTime=" + String.valueOf(this.lastAccessedTime) + ", size=" + this.size + ", encoding='" + this.encoding + "'} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ResourcePhysicalStatusAnnotation that = (ResourcePhysicalStatusAnnotation)objectToCompare;
        return this.getSize() == that.getSize() && Objects.equals(this.getCreateTime(), that.getCreateTime()) && Objects.equals(this.getModifiedTime(), that.getModifiedTime()) && Objects.equals(this.getLastAccessedTime(), that.getLastAccessedTime()) && Objects.equals(this.getEncoding(), that.getEncoding());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getCreateTime(), this.getModifiedTime(), this.getSize(), this.getEncoding());
    }
}

