/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.enums.AnnotationStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.BusinessCapabilityType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ByteOrdering;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommentType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommunityMembershipType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ConceptModelAttributeCoverageCategory;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ConceptModelDecoration;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ConfidenceLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ConfidentialityLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ContactMethodType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CriticalityLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CrowdSourcingRole;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataClassAssignmentStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermActivityType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermAssignmentStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GovernanceClassificationStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GovernanceDomain;
import org.odpi.openmetadata.frameworks.openmetadata.enums.KeyPattern;
import org.odpi.openmetadata.frameworks.openmetadata.enums.MediaType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.MediaUsage;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OperationalStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OrderBy;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PortType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.RetentionBasis;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ServerAssetUseType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.StarRating;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ToDoStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;

public class OpenMetadataTypesArchive1_2 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveVersion = "1.2";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1577886131090L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive1_2() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive1_2(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public void getOriginalTypes() {
        this.addStandardPrimitiveDefs();
        this.addStandardCollectionDefs();
        this.addArea0Types();
        this.addArea1Types();
        this.addArea2Types();
        this.addArea3Types();
        this.addArea4Types();
        this.addArea5Types();
        this.addArea6Types();
    }

    public void addStandardPrimitiveDefs() {
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE));
    }

    public void addStandardCollectionDefs() {
        this.archiveBuilder.addCollectionDef(this.getMapStringStringCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getMapStringBooleanCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getMapStringIntCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getMapStringLongCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getMapStringDoubleCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getMapStringDateCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getMapStringObjectCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getArrayStringCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getArrayIntCollectionDef());
    }

    private CollectionDef getMapStringStringCollectionDef() {
        String guid = "005c7c14-ac84-4136-beed-959401b041f8";
        String description = "A map from string to string.";
        String descriptionGUID = "f285d0ca-50ab-4564-b129-c7e3ba4e8545";
        return this.archiveHelper.getMapCollectionDef("005c7c14-ac84-4136-beed-959401b041f8", "A map from string to string.", "f285d0ca-50ab-4564-b129-c7e3ba4e8545", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
    }

    private CollectionDef getMapStringBooleanCollectionDef() {
        String guid = "8fa603dd-c2c5-43fc-8ff4-92141f2414ab";
        String description = "A map from string to Boolean.";
        String descriptionGUID = "72d76e44-350c-4ff3-baae-54b837f723c7";
        return this.archiveHelper.getMapCollectionDef("8fa603dd-c2c5-43fc-8ff4-92141f2414ab", "A map from string to Boolean.", "72d76e44-350c-4ff3-baae-54b837f723c7", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
    }

    private CollectionDef getMapStringIntCollectionDef() {
        String guid = "8fa603dd-c2c5-43fc-8ff4-92141f2414ac";
        String description = "A map from string to int.";
        String descriptionGUID = "47373fd6-be40-439b-97ca-881878eed1f4";
        return this.archiveHelper.getMapCollectionDef("8fa603dd-c2c5-43fc-8ff4-92141f2414ac", "A map from string to int.", "47373fd6-be40-439b-97ca-881878eed1f4", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
    }

    private CollectionDef getMapStringLongCollectionDef() {
        String guid = "8fa603dd-c2c5-43fc-8ff4-92141f2414ae";
        String description = "A map from string to long.";
        String descriptionGUID = "039b3466-e28b-4c73-8181-d9a57749c706";
        return this.archiveHelper.getMapCollectionDef("8fa603dd-c2c5-43fc-8ff4-92141f2414ae", "A map from string to long.", "039b3466-e28b-4c73-8181-d9a57749c706", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
    }

    private CollectionDef getMapStringDateCollectionDef() {
        String guid = "ee293c68-e34d-4885-a512-f927d35a5893";
        String description = "A map from string to date.";
        String descriptionGUID = "978b8ad1-c7c8-4892-bd83-98c9f07e8028";
        return this.archiveHelper.getMapCollectionDef("ee293c68-e34d-4885-a512-f927d35a5893", "A map from string to date.", "978b8ad1-c7c8-4892-bd83-98c9f07e8028", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
    }

    private CollectionDef getMapStringDoubleCollectionDef() {
        String guid = "17211869-ed39-4ba9-bead-ffd967df65a8";
        String description = "A map from string to double.";
        String descriptionGUID = "ee2cf3d5-3ff8-4d6a-82ed-35c0123dcc89";
        return this.archiveHelper.getMapCollectionDef("17211869-ed39-4ba9-bead-ffd967df65a8", "A map from string to double.", "ee2cf3d5-3ff8-4d6a-82ed-35c0123dcc89", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE);
    }

    private CollectionDef getMapStringObjectCollectionDef() {
        String guid = "8fa603dd-c2c5-43fc-8ff4-92141f2414ad";
        String description = "A map from string to object.";
        String descriptionGUID = "6dd2944b-9107-41c6-a10b-6a938fd6f2f5";
        return this.archiveHelper.getMapCollectionDef("8fa603dd-c2c5-43fc-8ff4-92141f2414ad", "A map from string to object.", "6dd2944b-9107-41c6-a10b-6a938fd6f2f5", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
    }

    private CollectionDef getArrayStringCollectionDef() {
        String guid = "0428b5d3-f824-459c-b7f5-f8151de59707";
        String description = "An array of strings.";
        String descriptionGUID = "4a384611-d8c1-4909-a6f8-1385ffe210e2";
        return this.archiveHelper.getArrayCollectionDef("0428b5d3-f824-459c-b7f5-f8151de59707", "An array of strings.", "4a384611-d8c1-4909-a6f8-1385ffe210e2", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
    }

    private CollectionDef getArrayIntCollectionDef() {
        String guid = "0103fe10-98b0-4910-8ee0-21d529f7ff6d";
        String description = "An array of integers.";
        String descriptionGUID = "ac772d8b-278e-4017-a7e8-1988c74c091e";
        return this.archiveHelper.getArrayCollectionDef("0103fe10-98b0-4910-8ee0-21d529f7ff6d", "An array of integers.", "ac772d8b-278e-4017-a7e8-1988c74c091e", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
    }

    public void addArea0Types() {
        this.add0010BaseModel();
        this.add0015LinkedMediaTypes();
        this.add0017ExternalIdentifiers();
        this.add0019MoreInformation();
        this.add0020PropertyFacets();
        this.add0025Locations();
        this.add0030HostsAndPlatforms();
        this.add0035ComplexHosts();
        this.add0037SoftwareServerPlatforms();
        this.add0040SoftwareServers();
        this.add0042SoftwareServerCapabilities();
        this.add0045ServersAndAssets();
        this.add0050ApplicationsAndProcesses();
        this.add0055DataProcessingEngines();
        this.add0070NetworksAndGateways();
        this.add0090CloudPlatformsAndServices();
    }

    private void add0010BaseModel() {
        this.archiveBuilder.addEntityDef(this.getReferenceableEntity());
        this.archiveBuilder.addEntityDef(this.getAssetEntity());
        this.archiveBuilder.addEntityDef(this.getInfrastructureEntity());
        this.archiveBuilder.addEntityDef(this.getProcessEntity());
        this.archiveBuilder.addEntityDef(this.getDataAssetEntity());
        this.archiveBuilder.addEntityDef(this.getDataSetEntity());
    }

    private EntityDef getReferenceableEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.REFERENCEABLE, null);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUALIFIED_NAME);
        property.setUnique(true);
        property.setValuesMaxCount(1);
        property.setValuesMinCount(1);
        property.setAttributeCardinality(AttributeCardinality.ONE_ONLY);
        properties.add(property);
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getAssetEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ASSET, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getInfrastructureEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.INFRASTRUCTURE, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName));
    }

    private EntityDef getProcessEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PROCESS, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMULA));
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private EntityDef getDataAssetEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_ASSET, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName));
    }

    private EntityDef getDataSetEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_SET, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_ASSET.typeName));
    }

    private void add0015LinkedMediaTypes() {
        this.archiveBuilder.addEnumDef(this.getMediaTypeEnum());
        this.archiveBuilder.addEnumDef(this.getMediaUsageEnum());
        this.archiveBuilder.addEntityDef(this.getExternalReferenceEntity());
        this.archiveBuilder.addEntityDef(this.getRelatedMediaEntity());
        this.archiveBuilder.addRelationshipDef(this.getExternalReferenceLinkRelationship());
        this.archiveBuilder.addRelationshipDef(this.getMediaReferenceRelationship());
    }

    private EnumDef getMediaTypeEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(MediaType.getOpenTypeGUID(), MediaType.getOpenTypeName(), MediaType.getOpenTypeDescription(), MediaType.getOpenTypeDescriptionGUID(), MediaType.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (MediaType enumValue : MediaType.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getMediaUsageEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(MediaUsage.getOpenTypeGUID(), MediaUsage.getOpenTypeName(), MediaUsage.getOpenTypeDescription(), MediaUsage.getOpenTypeDescriptionGUID(), MediaUsage.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (MediaUsage enumValue : MediaUsage.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getExternalReferenceEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EXTERNAL_REFERENCE, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.URL));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ORGANIZATION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getRelatedMediaEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RELATED_MEDIA, this.archiveBuilder.getEntityDef(OpenMetadataType.EXTERNAL_REFERENCE.typeName));
    }

    private RelationshipDef getExternalReferenceLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "relatedItem";
        String end1AttributeDescription = "Item that is referencing this work.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "relatedItem", "Item that is referencing this work.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "externalReference";
        String end2AttributeDescription = "Link to more information from an external source.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.EXTERNAL_REFERENCE.typeName), "externalReference", "Link to more information from an external source.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REFERENCE_ID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getMediaReferenceRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.MEDIA_REFERENCE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "consumingItem";
        String end1AttributeDescription = "Item that is referencing this work.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "consumingItem", "Item that is referencing this work.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "relatedMedia";
        String end2AttributeDescription = "Link to external media.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.RELATED_MEDIA.typeName), "relatedMedia", "Link to external media.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MEDIA_ID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0017ExternalIdentifiers() {
        this.archiveBuilder.addEnumDef(this.getKeyPatternEnum());
        this.archiveBuilder.addEntityDef(this.getExternalIdEntity());
        this.archiveBuilder.addRelationshipDef(this.getExternalIdScopeRelationship());
        this.archiveBuilder.addRelationshipDef(this.getExternalIdLinkRelationship());
    }

    private EnumDef getKeyPatternEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(KeyPattern.getOpenTypeGUID(), KeyPattern.getOpenTypeName(), KeyPattern.getOpenTypeDescription(), KeyPattern.getOpenTypeDescriptionGUID(), KeyPattern.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (KeyPattern enumValue : KeyPattern.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getExternalIdEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EXTERNAL_ID, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IDENTIFIER));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.KEY_PATTERN));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getExternalIdScopeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "scopedTo";
        String end1AttributeDescription = "Identifies where this external identifier is known.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "scopedTo", "Identifies where this external identifier is known.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "managedResources";
        String end2AttributeDescription = "Link to details of a resource that this component manages.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.EXTERNAL_ID.typeName), "managedResources", "Link to details of a resource that this component manages.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getExternalIdLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "resources";
        String end1AttributeDescription = "Resource being identified.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "resources", "Resource being identified.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "alsoKnownAs";
        String end2AttributeDescription = "Identifier used in an external system.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.EXTERNAL_ID.typeName), "alsoKnownAs", "Identifier used in an external system.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USAGE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0019MoreInformation() {
        this.archiveBuilder.addRelationshipDef(this.getMoreInformationRelationship());
    }

    private RelationshipDef getMoreInformationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.MORE_INFORMATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "describes";
        String end1AttributeDescription = "Describes this core element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "describes", "Describes this core element.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "providesMoreInformation";
        String end2AttributeDescription = "Provides more information about this referenceable.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "providesMoreInformation", "Provides more information about this referenceable.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0020PropertyFacets() {
        this.archiveBuilder.addEntityDef(this.getPropertyFacetEntity());
        this.archiveBuilder.addRelationshipDef(this.getReferenceableFacetRelationship());
    }

    private EntityDef getPropertyFacetEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PROPERTY_FACET, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROPERTIES));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getReferenceableFacetRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.REFERENCEABLE_FACET, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "relatedEntity";
        String end1AttributeDescription = "Identifies which element this property facet belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "relatedEntity", "Identifies which element this property facet belongs to.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "facets";
        String end2AttributeDescription = "Additional properties from different sources.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PROPERTY_FACET.typeName), "facets", "Additional properties from different sources.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0025Locations() {
        this.archiveBuilder.addEntityDef(this.getLocationEntity());
        this.archiveBuilder.addRelationshipDef(this.getNestedLocationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAdjacentLocationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAssetLocationRelationship());
        this.archiveBuilder.addClassificationDef(this.getMobileAssetClassification());
        this.archiveBuilder.addClassificationDef(this.getFixedLocationClassification());
        this.archiveBuilder.addClassificationDef(this.getSecureLocationClassification());
        this.archiveBuilder.addClassificationDef(this.getCyberLocationClassification());
    }

    private EntityDef getLocationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.LOCATION, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getNestedLocationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.NESTED_LOCATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "groupingLocations";
        String end1AttributeDescription = "Location that is covering the broader area.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.LOCATION.typeName), "groupingLocations", "Location that is covering the broader area.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "nestedLocations";
        String end2AttributeDescription = "Location that is nested in this location.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.LOCATION.typeName), "nestedLocations", "Location that is nested in this location.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAdjacentLocationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ADJACENT_LOCATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "peerLocations";
        String end1AttributeDescription = "Location that is adjacent to this location.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.LOCATION.typeName), "peerLocations", "Location that is adjacent to this location.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "peerLocations";
        String end2AttributeDescription = "Location that is adjacent to this location.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.LOCATION.typeName), "peerLocations", "Location that is adjacent to this location.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAssetLocationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ASSET_LOCATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "localAssets";
        String end1AttributeDescription = "Assets sited at this location.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "localAssets", "Assets sited at this location.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "knownLocations";
        String end2AttributeDescription = "Places where this asset is sited.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.LOCATION.typeName), "knownLocations", "Places where this asset is sited.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getMobileAssetClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.MOBILE_ASSET_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), false);
    }

    private ClassificationDef getFixedLocationClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.FIXED_LOCATION_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.LOCATION.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COORDINATES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TIME_ZONE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getSecureLocationClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.SECURE_LOCATION_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.LOCATION.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LEVEL));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getCyberLocationClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.CYBER_LOCATION_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.LOCATION.typeName), false);
    }

    private void add0030HostsAndPlatforms() {
        this.archiveBuilder.addEnumDef(this.getEndiannessEnum());
        this.archiveBuilder.addEntityDef(this.getITInfrastructureEntity());
        this.archiveBuilder.addEntityDef(this.getHostEntity());
        this.archiveBuilder.addEntityDef(this.getOperatingPlatformEntity());
    }

    private EnumDef getEndiannessEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ByteOrdering.getOpenTypeGUID(), ByteOrdering.getOpenTypeName(), ByteOrdering.getOpenTypeDescription(), ByteOrdering.getOpenTypeDescriptionGUID(), ByteOrdering.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ByteOrdering byteOrdering : ByteOrdering.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(byteOrdering.getOrdinal(), byteOrdering.getName(), byteOrdering.getDescription(), byteOrdering.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!byteOrdering.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getITInfrastructureEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.IT_INFRASTRUCTURE, this.archiveBuilder.getEntityDef(OpenMetadataType.INFRASTRUCTURE.typeName));
    }

    private EntityDef getHostEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.HOST, this.archiveBuilder.getEntityDef(OpenMetadataType.IT_INFRASTRUCTURE.typeName));
    }

    private EntityDef getOperatingPlatformEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.OPERATING_PLATFORM, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.OPERATING_SYSTEM));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0035ComplexHosts() {
        this.archiveBuilder.addEntityDef(this.getHostClusterEntity());
        this.archiveBuilder.addEntityDef(this.getVirtualContainerEntity());
        this.archiveBuilder.addRelationshipDef(this.getHostClusterMemberRelationship());
    }

    private EntityDef getHostClusterEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.HOST_CLUSTER, this.archiveBuilder.getEntityDef(OpenMetadataType.HOST.typeName));
    }

    private EntityDef getVirtualContainerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.VIRTUAL_CONTAINER, this.archiveBuilder.getEntityDef(OpenMetadataType.HOST.typeName));
    }

    private RelationshipDef getHostClusterMemberRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.HOST_CLUSTER_MEMBER_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "hostCluster";
        String end1AttributeDescription = "Cluster managing this host.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.HOST_CLUSTER.typeName), "hostCluster", "Cluster managing this host.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "managedHosts";
        String end2AttributeDescription = "Member of the host cluster.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.HOST.typeName), "managedHosts", "Member of the host cluster.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0037SoftwareServerPlatforms() {
        this.archiveBuilder.addEnumDef(this.getOperationalStatusEnum());
        this.archiveBuilder.addEntityDef(this.getSoftwareServerPlatformEntity());
    }

    private EnumDef getOperationalStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(OperationalStatus.getOpenTypeGUID(), OperationalStatus.getOpenTypeName(), OperationalStatus.getOpenTypeDescription(), OperationalStatus.getOpenTypeDescriptionGUID());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (OperationalStatus enumValue : OperationalStatus.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getSoftwareServerPlatformEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SOFTWARE_SERVER_PLATFORM, this.archiveBuilder.getEntityDef(OpenMetadataType.IT_INFRASTRUCTURE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USER_ID));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0040SoftwareServers() {
        this.archiveBuilder.addEntityDef(this.getSoftwareServerEntity());
        this.archiveBuilder.addEntityDef(this.getEndpointEntity());
        this.archiveBuilder.addRelationshipDef(this.getServerEndpointRelationship());
    }

    private EntityDef getSoftwareServerEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SOFTWARE_SERVER, this.archiveBuilder.getEntityDef(OpenMetadataType.IT_INFRASTRUCTURE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USER_ID));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getEndpointEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ENDPOINT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NETWORK_ADDRESS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROTOCOL));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENCRYPTION_METHOD));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getServerEndpointRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "servers";
        String end1AttributeDescription = "Server supporting this endpoint.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER.typeName), "servers", "Server supporting this endpoint.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "endpoints";
        String end2AttributeDescription = "Endpoints supported by this server.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ENDPOINT.typeName), "endpoints", "Endpoints supported by this server.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0042SoftwareServerCapabilities() {
        this.archiveBuilder.addEntityDef(this.getSoftwareServerCapabilityEntity());
    }

    private EntityDef getSoftwareServerCapabilityEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
    }

    private void add0045ServersAndAssets() {
        this.archiveBuilder.addEnumDef(this.getServerAssetUseTypeEnum());
    }

    private EnumDef getServerAssetUseTypeEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ServerAssetUseType.getOpenTypeGUID(), ServerAssetUseType.getOpenTypeName(), ServerAssetUseType.getOpenTypeDescription(), ServerAssetUseType.getOpenTypeDescriptionGUID());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ServerAssetUseType enumValue : ServerAssetUseType.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private void add0050ApplicationsAndProcesses() {
        this.archiveBuilder.addEntityDef(this.getApplicationEntity());
        this.archiveBuilder.addClassificationDef(this.getApplicationServerClassification());
        this.archiveBuilder.addClassificationDef(this.getWebserverClassification());
    }

    private EntityDef getApplicationEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.APPLICATION, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
    }

    private ClassificationDef getApplicationServerClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.APPLICATION_SERVER_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER.typeName), false);
    }

    private ClassificationDef getWebserverClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.WEBSERVER_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER.typeName), false);
    }

    private void add0055DataProcessingEngines() {
        this.archiveBuilder.addEntityDef(this.getEngineEntity());
        this.archiveBuilder.addClassificationDef(this.getWorkflowEngineClassification());
        this.archiveBuilder.addClassificationDef(this.getReportingEngineClassification());
        this.archiveBuilder.addClassificationDef(this.getAnalyticsEngineClassification());
        this.archiveBuilder.addClassificationDef(this.getDataMovementEngineClassification());
        this.archiveBuilder.addClassificationDef(this.getDataVirtualizationEngineClassification());
    }

    private EntityDef getEngineEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ENGINE, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
    }

    private ClassificationDef getWorkflowEngineClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.WORKFLOW_ENGINE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.ENGINE.typeName), false);
    }

    private ClassificationDef getReportingEngineClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.REPORTING_ENGINE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.ENGINE.typeName), false);
    }

    private ClassificationDef getAnalyticsEngineClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.ANALYTICS_ENGINE, null, this.archiveBuilder.getEntityDef(OpenMetadataType.ENGINE.typeName), false);
    }

    private ClassificationDef getDataMovementEngineClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.DATA_MOVEMENT_ENGINE, null, this.archiveBuilder.getEntityDef(OpenMetadataType.ENGINE.typeName), false);
    }

    private ClassificationDef getDataVirtualizationEngineClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.DATA_VIRTUALIZATION_ENGINE, null, this.archiveBuilder.getEntityDef(OpenMetadataType.ENGINE.typeName), false);
    }

    private void add0070NetworksAndGateways() {
        this.archiveBuilder.addEntityDef(this.getNetworkEntity());
        this.archiveBuilder.addEntityDef(this.getNetworkGatewayEntity());
        this.archiveBuilder.addRelationshipDef(this.getNetworkGatewayLinkRelationship());
    }

    private EntityDef getNetworkEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.NETWORK, this.archiveBuilder.getEntityDef(OpenMetadataType.IT_INFRASTRUCTURE.typeName));
    }

    private EntityDef getNetworkGatewayEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.NETWORK_GATEWAY, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
    }

    private RelationshipDef getNetworkGatewayLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.NETWORK_GATEWAY_LINK_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "gateways";
        String end1AttributeDescription = "Gateways to other networks.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.NETWORK_GATEWAY.typeName), "gateways", "Gateways to other networks.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "networkConnections";
        String end2AttributeDescription = "Connections to different networks.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.NETWORK.typeName), "networkConnections", "Connections to different networks.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0090CloudPlatformsAndServices() {
        this.archiveBuilder.addClassificationDef(this.getCloudProviderClassification());
        this.archiveBuilder.addClassificationDef(this.getCloudPlatformClassification());
        this.archiveBuilder.addClassificationDef(this.getCloudTenantClassification());
        this.archiveBuilder.addClassificationDef(this.getCloudServiceClassification());
    }

    private ClassificationDef getCloudProviderClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CLOUD_PROVIDER_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.HOST.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROVIDER_NAME));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getCloudPlatformClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.CLOUD_PLATFORM_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName), false);
    }

    private ClassificationDef getCloudTenantClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CLOUD_TENANT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TENANT_NAME));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getCloudServiceClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CLOUD_SERVICE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.OFFERING_NAME));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void addArea1Types() {
        this.add0110Actors();
        this.add0112People();
        this.add0115Teams();
        this.add0117EngineProfiles();
        this.add0120Collections();
        this.add0130Projects();
        this.add0135Meetings();
        this.add0137Actions();
        this.add0140Communities();
        this.add0150Feedback();
        this.add0155CrowdSourcing();
        this.add0160Notes();
    }

    private void add0110Actors() {
        this.archiveBuilder.addEnumDef(this.getContactMethodTypeEnum());
        this.archiveBuilder.addEntityDef(this.getActorProfileEntity());
        this.archiveBuilder.addEntityDef(this.getUserIdentityEntity());
        this.archiveBuilder.addEntityDef(this.getContactDetailsEntity());
        this.archiveBuilder.addRelationshipDef(this.getContactThroughRelationship());
        this.archiveBuilder.addRelationshipDef(this.getProfileIdentityRelationship());
    }

    private EnumDef getContactMethodTypeEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ContactMethodType.getOpenTypeGUID(), ContactMethodType.getOpenTypeName(), ContactMethodType.getOpenTypeDescription(), ContactMethodType.getOpenTypeDescriptionGUID(), ContactMethodType.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ContactMethodType enumValues : ContactMethodType.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getActorProfileEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ACTOR_PROFILE, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getUserIdentityEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.USER_IDENTITY, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
    }

    private EntityDef getContactDetailsEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CONTACT_DETAILS, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.CONTACT_METHOD_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONTACT_METHOD_VALUE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONTACT_METHOD_SERVICE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getContactThroughRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONTACT_THROUGH_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "contactDetails";
        String end1AttributeDescription = "Contact details owner.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR_PROFILE.typeName), "contactDetails", "Contact details owner.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "contacts";
        String end2AttributeDescription = "Contact information.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONTACT_DETAILS.typeName), "contacts", "Contact information.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getProfileIdentityRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "profile";
        String end1AttributeDescription = "Description of the person, organization or engine that uses this user identity.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR_PROFILE.typeName), "profile", "Description of the person, organization or engine that uses this user identity.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "userIdentities";
        String end2AttributeDescription = "Authentication identifiers in use by the owner of this profile.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.USER_IDENTITY.typeName), "userIdentities", "Authentication identifiers in use by the owner of this profile.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0112People() {
        this.archiveBuilder.addEntityDef(this.getPersonEntity());
        this.archiveBuilder.addEntityDef(this.getContributionRecordEntity());
        this.archiveBuilder.addEntityDef(this.getPersonRoleEntity());
        this.archiveBuilder.addRelationshipDef(this.getPersonRoleAppointmentRelationship());
        this.archiveBuilder.addRelationshipDef(this.getPeerRelationship());
    }

    private EntityDef getPersonEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PERSON, this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR_PROFILE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FULL_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.JOB_TITLE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getContributionRecordEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CONTRIBUTION_RECORD, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.KARMA_POINTS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getPersonRoleEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PERSON_ROLE, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
    }

    private RelationshipDef getPersonRoleAppointmentRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PERSON_ROLE_APPOINTMENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "rolePerformers";
        String end1AttributeDescription = "The people performing this role.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON.typeName), "rolePerformers", "The people performing this role.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        String end2AttributeName = "performsRoles";
        String end2AttributeDescription = "Roles performed by this person.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName), "performsRoles", "Roles performed by this person.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getPeerRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PEER_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "peers";
        String end1AttributeDescription = "List of this person's peer network.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON.typeName), "peers", "List of this person's peer network.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "peers";
        String end2AttributeDescription = "List of this person's peer network.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON.typeName), "peers", "List of this person's peer network.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0115Teams() {
        this.archiveBuilder.addEntityDef(this.getTeamEntity());
        this.archiveBuilder.addEntityDef(this.getTeamLeaderEntity());
        this.archiveBuilder.addEntityDef(this.getTeamMemberEntity());
        this.archiveBuilder.addRelationshipDef(this.getTeamLeadershipRelationship());
        this.archiveBuilder.addRelationshipDef(this.getTeamMembershipRelationship());
        this.archiveBuilder.addRelationshipDef(this.getTeamStructureRelationship());
    }

    private EntityDef getTeamEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TEAM, this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR_PROFILE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TEAM_TYPE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getTeamLeaderEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TEAM_LEADER, this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName));
    }

    private EntityDef getTeamMemberEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TEAM_MEMBER, this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName));
    }

    private RelationshipDef getTeamStructureRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TEAM_STRUCTURE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "superTeam";
        String end1AttributeDescription = "The aggregating team.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TEAM.typeName), "superTeam", "The aggregating team.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "subTeam";
        String end2AttributeDescription = "The teams where work is delegated to.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TEAM.typeName), "subTeam", "The teams where work is delegated to.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DELEGATION_ESCALATION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getTeamLeadershipRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TEAM_LEADERSHIP_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "teamLeaders";
        String end1AttributeDescription = "The leaders of the team.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TEAM_LEADER.typeName), "teamLeaders", "The leaders of the team.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "leadsTeam";
        String end2AttributeDescription = "The team lead by this team leader.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TEAM.typeName), "leadsTeam", "The team lead by this team leader.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ROLE_POSITION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getTeamMembershipRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TEAM_MEMBERSHIP_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "teamMembers";
        String end1AttributeDescription = "The members of the team.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TEAM_MEMBER.typeName), "teamMembers", "The members of the team.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "memberOfTeam";
        String end2AttributeDescription = "The team that this person is a member of.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TEAM.typeName), "memberOfTeam", "The team that this person is a member of.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ROLE_POSITION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0117EngineProfiles() {
        this.archiveBuilder.addEntityDef(this.getITProfileEntity());
    }

    private EntityDef getITProfileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.IT_PROFILE, this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR_PROFILE.typeName));
    }

    private void add0120Collections() {
        this.archiveBuilder.addEnumDef(this.getOrderByEnum());
        this.archiveBuilder.addEntityDef(this.getCollectionEntity());
        this.archiveBuilder.addRelationshipDef(this.getCollectionMembershipRelationship());
        this.archiveBuilder.addRelationshipDef(this.getResourceListRelationship());
        this.archiveBuilder.addClassificationDef(this.getFolderClassification());
        this.archiveBuilder.addClassificationDef(this.getSetClassification());
    }

    private EnumDef getOrderByEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(OrderBy.getOpenTypeGUID(), OrderBy.getOpenTypeName(), OrderBy.getOpenTypeDescription(), OrderBy.getOpenTypeDescriptionGUID());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (OrderBy orderBy : OrderBy.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(orderBy.getOrdinal(), orderBy.getName(), orderBy.getDescription(), orderBy.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!orderBy.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getCollectionEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.COLLECTION, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getCollectionMembershipRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "foundInCollections";
        String end1AttributeDescription = "Collections that link to this element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName), "foundInCollections", "Collections that link to this element.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "collectionMembers";
        String end2AttributeDescription = "Members of this collection.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "collectionMembers", "Members of this collection.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MEMBERSHIP_RATIONALE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getResourceListRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.RESOURCE_LIST_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "resourceListAnchors";
        String end1AttributeDescription = "Referenceable objects that are using the linked to resource.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "resourceListAnchors", "Referenceable objects that are using the linked to resource.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "supportingResources";
        String end2AttributeDescription = "Resources identified as of interest to the anchor.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "supportingResources", "Resources identified as of interest to the anchor.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RESOURCE_USE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RESOURCE_USE_DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RESOURCE_USE_PROPERTIES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.WATCH_RESOURCE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getFolderClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.FOLDER, null, this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.COLLECTION_ORDER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ORDER_BY_PROPERTY_NAME));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getSetClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.RESULTS_SET, null, this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName), false);
    }

    private void add0130Projects() {
        this.archiveBuilder.addEntityDef(this.getProjectEntity());
        this.archiveBuilder.addEntityDef(this.getProjectManagerEntity());
        this.archiveBuilder.addRelationshipDef(this.getProjectHierarchyRelationship());
        this.archiveBuilder.addRelationshipDef(this.getProjectDependencyRelationship());
        this.archiveBuilder.addRelationshipDef(this.getProjectTeamRelationship());
        this.archiveBuilder.addRelationshipDef(this.getProjectManagementRelationship());
        this.archiveBuilder.addClassificationDef(this.getTaskClassification());
        this.archiveBuilder.addClassificationDef(this.getCampaignClassification());
    }

    private EntityDef getProjectEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PROJECT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.START_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PLANNED_END_DATE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getProjectManagerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PROJECT_MANAGER, this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName));
    }

    private RelationshipDef getProjectHierarchyRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PROJECT_HIERARCHY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "managingProject";
        String end1AttributeDescription = "Project that oversees this project.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT.typeName), "managingProject", "Project that oversees this project.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "managedProject";
        String end2AttributeDescription = "Project that this project is responsible for managing.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT.typeName), "managedProject", "Project that this project is responsible for managing.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getProjectDependencyRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PROJECT_DEPENDENCY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "dependentProject";
        String end1AttributeDescription = "Projects that are dependent on this project.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT.typeName), "dependentProject", "Projects that are dependent on this project.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "dependsOnProjects";
        String end2AttributeDescription = "Projects that are delivering resources or outcomes needed by this project.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT.typeName), "dependsOnProjects", "Projects that are delivering resources or outcomes needed by this project.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DEPENDENCY_SUMMARY));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getProjectTeamRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PROJECT_TEAM_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "projectFocus";
        String end1AttributeDescription = "Projects that a team is working on.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT.typeName), "projectFocus", "Projects that a team is working on.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "supportingActors";
        String end2AttributeDescription = "People and teams supporting this project.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR_PROFILE.typeName), "supportingActors", "People and teams supporting this project.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TEAM_ROLE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getTaskClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.TASK_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT.typeName), false);
    }

    private RelationshipDef getProjectManagementRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "projectsManaged";
        String end1AttributeDescription = "The projects that are being managed by this project manager.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT.typeName), "projectsManaged", "The projects that are being managed by this project manager.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "projectManagers";
        String end2AttributeDescription = "The roles for managing this project.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT_MANAGER.typeName), "projectManagers", "The roles for managing this project.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getCampaignClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.CAMPAIGN_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName), false);
    }

    private void add0135Meetings() {
        this.archiveBuilder.addEntityDef(this.getMeetingEntity());
        this.archiveBuilder.addRelationshipDef(this.getMeetingsRelationship());
    }

    private EntityDef getMeetingEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.MEETING, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TITLE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.START_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.END_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.OBJECTIVE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MINUTES));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getMeetingsRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.MEETINGS, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "meetings";
        String end1AttributeDescription = "Related meetings.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.MEETING.typeName), "meetings", "Related meetings.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        String end2AttributeName = "meetingOwner";
        String end2AttributeDescription = "Person, project, community or team that called the meeting.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "meetingOwner", "Person, project, community or team that called the meeting.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        return relationshipDef;
    }

    private void add0137Actions() {
        this.archiveBuilder.addEnumDef(this.getToDoStatusEnum());
        this.archiveBuilder.addEntityDef(this.getToDoEntity());
        this.archiveBuilder.addRelationshipDef(this.getToDoSourceRelationship());
        this.archiveBuilder.addRelationshipDef(this.getActionSponsorRelationship());
        this.archiveBuilder.addRelationshipDef(this.getActionAssignment());
    }

    private EnumDef getToDoStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ToDoStatus.getOpenTypeGUID(), ToDoStatus.getOpenTypeName(), ToDoStatus.getOpenTypeDescription(), ToDoStatus.getOpenTypeDescriptionGUID(), ToDoStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ToDoStatus toDoStatus : ToDoStatus.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(toDoStatus.getOrdinal(), toDoStatus.getName(), toDoStatus.getDescription(), toDoStatus.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!toDoStatus.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getToDoEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TO_DO, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CREATION_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PRIORITY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DUE_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COMPLETION_TIME));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TO_DO_STATUS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getToDoSourceRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TO_DO_SOURCE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "actionSource";
        String end1AttributeDescription = "Source of the to do request.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "actionSource", "Source of the to do request.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "actions";
        String end2AttributeDescription = "Requests to perform actions related to this element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TO_DO.typeName), "actions", "Requests to perform actions related to this element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getActionSponsorRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ACTION_SPONSOR_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "toDoSponsor";
        String end1AttributeDescription = "Element such as person, team, rule, incident, project, that is driving the need for the action.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "toDoSponsor", "Element such as person, team, rule, incident, project, that is driving the need for the action.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "trackedActions";
        String end2AttributeDescription = "Actions that need to be completed.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TO_DO.typeName), "trackedActions", "Actions that need to be completed.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getActionAssignment() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ACTION_ASSIGNMENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "assignedResources";
        String end1AttributeDescription = "One or more people assigned to complete the action (to do).";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName), "assignedResources", "One or more people assigned to complete the action (to do).", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "toDoList";
        String end2AttributeDescription = "List of toDos assigned to this person's role.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TO_DO.typeName), "toDoList", "List of toDos assigned to this person's role.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0140Communities() {
        this.archiveBuilder.addEnumDef(this.getCommunityMembershipTypeEnum());
        this.archiveBuilder.addEntityDef(this.getCommunityEntity());
        this.archiveBuilder.addEntityDef(this.getCommunityMemberEntity());
        this.archiveBuilder.addRelationshipDef(this.getCommunityMembershipRelationship());
    }

    private EnumDef getCommunityMembershipTypeEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(CommunityMembershipType.getOpenTypeGUID(), CommunityMembershipType.getOpenTypeName(), CommunityMembershipType.getOpenTypeDescription(), CommunityMembershipType.getOpenTypeDescriptionGUID());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (GovernanceDomain enumValue : GovernanceDomain.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getCommunityEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.COMMUNITY, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MISSION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getCommunityMemberEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.COMMUNITY_MEMBER, this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName));
    }

    private RelationshipDef getCommunityMembershipRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.COMMUNITY_MEMBERSHIP_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "memberOfCommunity";
        String end1AttributeDescription = "Communities that the person is a member of.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.COMMUNITY.typeName), "memberOfCommunity", "Communities that the person is a member of.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "communityMembers";
        String end2AttributeDescription = "Members of the community.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.COMMUNITY_MEMBER.typeName), "communityMembers", "Members of the community.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.MEMBERSHIP_TYPE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0150Feedback() {
        this.archiveBuilder.addEnumDef(this.getStarRatingEnum());
        this.archiveBuilder.addEnumDef(this.getCommentTypeEnum());
        this.archiveBuilder.addEntityDef(this.getRatingEntity());
        this.archiveBuilder.addEntityDef(this.getCommentEntity());
        this.archiveBuilder.addEntityDef(this.getLikeEntity());
        this.archiveBuilder.addEntityDef(this.getInformalTagEntity());
        this.archiveBuilder.addRelationshipDef(this.getAttachedRatingRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAttachedCommentRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAttachedLikeRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAcceptedAnswerRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAttachedTagRelationship());
    }

    private EnumDef getStarRatingEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(StarRating.getOpenTypeGUID(), StarRating.getOpenTypeName(), StarRating.getOpenTypeDescription(), StarRating.getOpenTypeDescriptionGUID(), StarRating.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (StarRating enumValue : StarRating.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getCommentTypeEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(CommentType.getOpenTypeGUID(), CommentType.getOpenTypeName(), CommentType.getOpenTypeDescription(), CommentType.getOpenTypeDescriptionGUID(), CommentType.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (CommentType commentType : CommentType.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(commentType.getOrdinal(), commentType.getName(), commentType.getDescription(), commentType.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!commentType.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getRatingEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RATING, null);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.STARS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REVIEW));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getCommentEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.COMMENT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TEXT));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TYPE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getLikeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.LIKE, null);
    }

    private EntityDef getInformalTagEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.INFORMAL_TAG, null);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TAG_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TAG_DESCRIPTION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getAttachedRatingRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTACHED_RATING_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "ratingAnchor";
        String end1AttributeDescription = "Element that is rated.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "ratingAnchor", "Element that is rated.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "starRatings";
        String end2AttributeDescription = "Accumulated ratings.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.RATING.typeName), "starRatings", "Accumulated ratings.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getAttachedCommentRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "commentAnchor";
        String end1AttributeDescription = "Element that this comment relates.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "commentAnchor", "Element that this comment relates.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "comments";
        String end2AttributeDescription = "Accumulated comments.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.COMMENT.typeName), "comments", "Accumulated comments.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getAttachedLikeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "likeAnchor";
        String end1AttributeDescription = "Element that is liked.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "likeAnchor", "Element that is liked.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "likes";
        String end2AttributeDescription = "Accumulated likes.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.LIKE.typeName), "likes", "Accumulated likes.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getAcceptedAnswerRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "answeredQuestions";
        String end1AttributeDescription = "Questions that now has an accepted answer.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.COMMENT.typeName), "answeredQuestions", "Questions that now has an accepted answer.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "acceptedAnswers";
        String end2AttributeDescription = "Accumulated answers.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.COMMENT.typeName), "acceptedAnswers", "Accumulated answers.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getAttachedTagRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTACHED_TAG_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "taggedElement";
        String end1AttributeDescription = "Element that is tagged.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "taggedElement", "Element that is tagged.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "tags";
        String end2AttributeDescription = "Accumulated tags.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.INFORMAL_TAG.typeName), "tags", "Accumulated tags.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0155CrowdSourcing() {
        this.archiveBuilder.addEnumDef(this.getCrowdSourcingRoleEnum());
        this.archiveBuilder.addEntityDef(this.getCrowdSourcingContributorEntity());
        this.archiveBuilder.addRelationshipDef(this.getCrowdSourcingContributionRelationship());
    }

    private EnumDef getCrowdSourcingRoleEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(CrowdSourcingRole.getOpenTypeGUID(), CrowdSourcingRole.getOpenTypeName(), CrowdSourcingRole.getOpenTypeDescription(), CrowdSourcingRole.getOpenTypeDescriptionGUID());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (KeyPattern enumValue : KeyPattern.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getCrowdSourcingContributorEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CROWD_SOURCING_CONTRIBUTOR, this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName));
    }

    private RelationshipDef getCrowdSourcingContributionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CROWD_SOURCING_CONTRIBUTION, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "contributions";
        String end1AttributeDescription = "Items that this person has contributed.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "contributions", "Items that this person has contributed.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "contributors";
        String end2AttributeDescription = "Person contributing content.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CROWD_SOURCING_CONTRIBUTOR.typeName), "contributors", "Person contributing content.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.ROLE_TYPE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0160Notes() {
        this.archiveBuilder.addEntityDef(this.getNoteEntryEntity());
        this.archiveBuilder.addEntityDef(this.getNoteLogEntity());
        this.archiveBuilder.addEntityDef(this.getNoteLogAuthorEntity());
        this.archiveBuilder.addRelationshipDef(this.getAttachedNoteLogRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAttachedNoteLogEntryRelationship());
        this.archiveBuilder.addRelationshipDef(this.getNoteLogAuthorshipRelationship());
    }

    private EntityDef getNoteEntryEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.NOTE_ENTRY, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TITLE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TEXT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getNoteLogAuthorEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.NOTE_LOG_AUTHOR, this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName));
    }

    private EntityDef getNoteLogEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.NOTE_LOG, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getAttachedNoteLogRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTACHED_NOTE_LOG_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "describes";
        String end1AttributeDescription = "Subject of the note log.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "describes", "Subject of the note log.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "noteLogs";
        String end2AttributeDescription = "Log of related notes.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.NOTE_LOG.typeName), "noteLogs", "Log of related notes.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getNoteLogAuthorshipRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.NOTE_LOG_AUTHORSHIP_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "authors";
        String end1AttributeDescription = "Person contributing to the note log.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.NOTE_LOG_AUTHOR.typeName), "authors", "Person contributing to the note log.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "authoredNoteLogs";
        String end2AttributeDescription = "Note log containing contributions.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.NOTE_LOG.typeName), "authoredNoteLogs", "Note log containing contributions.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAttachedNoteLogEntryRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTACHED_NOTE_LOG_ENTRY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "logs";
        String end1AttributeDescription = "Logs that this entry relates.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.NOTE_LOG.typeName), "logs", "Logs that this entry relates.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "entries";
        String end2AttributeDescription = "Accumulated notes.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.NOTE_ENTRY.typeName), "entries", "Accumulated notes.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void addArea2Types() {
        this.add0201ConnectorsAndConnections();
        this.add0205ConnectionLinkage();
        this.add0210DataStores();
        this.add0212DeployedAPIs();
        this.add0215SoftwareComponents();
        this.add0220FilesAndFolders();
        this.add0221DocumentStores();
        this.add0222GraphStores();
        this.add0223EventsAndLogs();
        this.add0224Databases();
        this.add0225MetadataRepositories();
        this.add0227Keystores();
        this.add0230CodeTables();
        this.add0235InformationView();
        this.add0239Reports();
        this.add0290Ports();
    }

    private void add0201ConnectorsAndConnections() {
        this.archiveBuilder.addEntityDef(this.getConnectionEntity());
        this.archiveBuilder.addEntityDef(this.getConnectorTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.getConnectionEndpointRelationship());
        this.archiveBuilder.addRelationshipDef(this.getConnectionConnectorTypeRelationship());
    }

    private EntityDef getConnectionEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CONNECTION, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SECURED_PROPERTIES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIGURATION_PROPERTIES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USER_ID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CLEAR_PASSWORD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENCRYPTED_PASSWORD));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getConnectorTypeEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CONNECTOR_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONNECTOR_PROVIDER_CLASS_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RECOGNIZED_ADDITIONAL_PROPERTIES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RECOGNIZED_SECURED_PROPERTIES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RECOGNIZED_CONFIGURATION_PROPERTIES));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getConnectionEndpointRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "connectionEndpoint";
        String end1AttributeDescription = "Server endpoint that provides access to the asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ENDPOINT.typeName), "connectionEndpoint", "Server endpoint that provides access to the asset.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "connections";
        String end2AttributeDescription = "Connections to this endpoint.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONNECTION.typeName), "connections", "Connections to this endpoint.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getConnectionConnectorTypeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "connections";
        String end1AttributeDescription = "Connections using this connector type.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONNECTION.typeName), "connections", "Connections using this connector type.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "connectorType";
        String end2AttributeDescription = "Type of connector to use for the asset.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONNECTOR_TYPE.typeName), "connectorType", "Type of connector to use for the asset.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0205ConnectionLinkage() {
        this.archiveBuilder.addEntityDef(this.getVirtualConnectionEntity());
        this.archiveBuilder.addRelationshipDef(this.getEmbeddedConnectionRelationship());
        this.archiveBuilder.addRelationshipDef(this.getConnectionToAssetRelationship());
    }

    private EntityDef getVirtualConnectionEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.VIRTUAL_CONNECTION, this.archiveBuilder.getEntityDef(OpenMetadataType.CONNECTION.typeName));
    }

    private RelationshipDef getEmbeddedConnectionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "supportingVirtualConnections";
        String end1AttributeDescription = "Virtual connections using this connection.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.VIRTUAL_CONNECTION.typeName), "supportingVirtualConnections", "Virtual connections using this connection.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "embeddedConnections";
        String end2AttributeDescription = "Connections embedded in this virtual connection.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONNECTION.typeName), "embeddedConnections", "Connections embedded in this virtual connection.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ARGUMENTS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getConnectionToAssetRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "connections";
        String end1AttributeDescription = "Connections to this asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONNECTION.typeName), "connections", "Connections to this asset.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "asset";
        String end2AttributeDescription = "Asset that can be accessed with this connection.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "asset", "Asset that can be accessed with this connection.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ASSET_SUMMARY));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0210DataStores() {
        this.archiveBuilder.addEntityDef(this.getDataStoreEntity());
        this.archiveBuilder.addRelationshipDef(this.getDataSetContentRelationship());
    }

    private EntityDef getDataStoreEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_STORE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_ASSET.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STORE_CREATE_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STORE_UPDATE_TIME));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getDataSetContentRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DATA_SET_CONTENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end2AttributeName = "supportedDataSets";
        String end2AttributeDescription = "Data sets that use this asset.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName), "supportedDataSets", "Data sets that use this asset.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end1AttributeName = "dataContent";
        String end1AttributeDescription = "Assets supporting a data set.";
        String end1AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "dataContent", "Assets supporting a data set.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0212DeployedAPIs() {
        this.archiveBuilder.addEntityDef(this.getDeployedAPIEntity());
        this.archiveBuilder.addRelationshipDef(this.getAPIEndpointRelationship());
        this.archiveBuilder.addClassificationDef(this.getRequestResponseInterfaceClassification());
        this.archiveBuilder.addClassificationDef(this.getListenerInterfaceClassification());
        this.archiveBuilder.addClassificationDef(this.getPublisherInterfaceClassification());
    }

    private EntityDef getDeployedAPIEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DEPLOYED_API, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName));
    }

    private RelationshipDef getAPIEndpointRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.API_ENDPOINT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "supportedAPIs";
        String end1AttributeDescription = "APIs that can be called from this endpoint.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DEPLOYED_API.typeName), "supportedAPIs", "APIs that can be called from this endpoint.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "accessEndpoints";
        String end2AttributeDescription = "Endpoints used to call this API.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ENDPOINT.typeName), "accessEndpoints", "Endpoints used to call this API.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getRequestResponseInterfaceClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.REQUEST_RESPONSE_INTERFACE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.DEPLOYED_API.typeName), false);
    }

    private ClassificationDef getListenerInterfaceClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.LISTENER_INTERFACE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.DEPLOYED_API.typeName), false);
    }

    private ClassificationDef getPublisherInterfaceClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.PUBLISHER_INTERFACE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.DEPLOYED_API.typeName), false);
    }

    private void add0215SoftwareComponents() {
        this.archiveBuilder.addEntityDef(this.getDeployedSoftwareComponentEntity());
    }

    private EntityDef getDeployedSoftwareComponentEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DEPLOYED_SOFTWARE_COMPONENT, this.archiveBuilder.getEntityDef(OpenMetadataType.PROCESS.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IMPLEMENTATION_LANGUAGE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0220FilesAndFolders() {
        this.archiveBuilder.addEntityDef(this.getFileFolderEntity());
        this.archiveBuilder.addEntityDef(this.getDataFolderEntity());
        this.archiveBuilder.addEntityDef(this.getDataFileEntity());
        this.archiveBuilder.addEntityDef(this.getCSVFileEntity());
        this.archiveBuilder.addEntityDef(this.getAvroFileEntity());
        this.archiveBuilder.addEntityDef(this.getJSONFileEntity());
        this.archiveBuilder.addRelationshipDef(this.getFolderHierarchyRelationship());
        this.archiveBuilder.addRelationshipDef(this.getNestedFileRelationship());
        this.archiveBuilder.addRelationshipDef(this.getLinkedFileRelationship());
        this.archiveBuilder.addClassificationDef(this.getFileSystemClassification());
    }

    private EntityDef getFileFolderEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.FILE_FOLDER, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_STORE.typeName));
    }

    private EntityDef getDataFolderEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_FOLDER, this.archiveBuilder.getEntityDef(OpenMetadataType.FILE_FOLDER.typeName));
    }

    private EntityDef getDataFileEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_STORE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FILE_TYPE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getCSVFileEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CSV_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DELIMITER_CHARACTER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUOTE_CHARACTER));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getAvroFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.AVRO_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
    }

    private EntityDef getJSONFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.JSON_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
    }

    private RelationshipDef getFolderHierarchyRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.FOLDER_HIERARCHY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "parentFolder";
        String end1AttributeDescription = "Parent folder.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.FILE_FOLDER.typeName), "parentFolder", "Parent folder.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "nestedFolder";
        String end2AttributeDescription = "Folders embedded in this folder.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.FILE_FOLDER.typeName), "nestedFolder", "Folders embedded in this folder.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getNestedFileRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.NESTED_FILE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "homeFolder";
        String end1AttributeDescription = "Identifies the containing folder of this datafile.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.FILE_FOLDER.typeName), "homeFolder", "Identifies the containing folder of this datafile.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "nestedFiles";
        String end2AttributeDescription = "Files stored in this folder.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName), "nestedFiles", "Files stored in this folder.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getLinkedFileRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.LINKED_FILE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "linkedFolders";
        String end1AttributeDescription = "Folders that this file is linked to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.FILE_FOLDER.typeName), "linkedFolders", "Folders that this file is linked to.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "linkedFiles";
        String end2AttributeDescription = "Files linked to the folder.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName), "linkedFiles", "Files linked to the folder.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getFileSystemClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.FILE_SYSTEM_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMAT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENCRYPTION));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0221DocumentStores() {
        this.archiveBuilder.addEntityDef(this.getMediaFileEntity());
        this.archiveBuilder.addEntityDef(this.getMediaCollectionEntity());
        this.archiveBuilder.addEntityDef(this.getDocumentEntity());
        this.archiveBuilder.addEntityDef(this.getDocumentStoreEntity());
        this.archiveBuilder.addRelationshipDef(this.getLinkedMediaRelationship());
    }

    private EntityDef getMediaFileEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.MEDIA_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EMBEDDED_METADATA));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getMediaCollectionEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.MEDIA_COLLECTION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName));
    }

    private EntityDef getDocumentEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DOCUMENT, this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName));
    }

    private EntityDef getDocumentStoreEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DOCUMENT_STORE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_STORE.typeName));
    }

    private RelationshipDef getLinkedMediaRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.LINKED_MEDIA_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "linkedMediaFiles";
        String end1AttributeDescription = "Link to related media files.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName), "linkedMediaFiles", "Link to related media files.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "linkedMediaFiles";
        String end2AttributeDescription = "Link to related media files.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName), "linkedMediaFiles", "Link to related media files.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0222GraphStores() {
        this.archiveBuilder.addEntityDef(this.getGraphStoreEntity());
    }

    private EntityDef getGraphStoreEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GRAPH_STORE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_STORE.typeName));
    }

    private void add0223EventsAndLogs() {
        this.archiveBuilder.addEntityDef(this.getSubscriberListEntity());
        this.archiveBuilder.addEntityDef(this.getTopicEntity());
        this.archiveBuilder.addEntityDef(this.getLogFileEntity());
        this.archiveBuilder.addRelationshipDef(this.getTopicSubscribersRelationship());
        this.archiveBuilder.addClassificationDef(this.getNotificationManagerClassification());
    }

    private EntityDef getSubscriberListEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SUBSCRIBER_LIST, this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName));
    }

    private EntityDef getTopicEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TOPIC, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TOPIC_TYPE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getLogFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.LOG_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
    }

    private RelationshipDef getTopicSubscribersRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TOPIC_SUBSCRIBERS_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "subscribers";
        String end1AttributeDescription = "The endpoints subscribed to this topic.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SUBSCRIBER_LIST.typeName), "subscribers", "The endpoints subscribed to this topic.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "topics";
        String end2AttributeDescription = "The topics used by this subscriber list.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TOPIC.typeName), "topics", "The topics used by this subscriber list.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getNotificationManagerClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.NOTIFICATION_MANAGER, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName), false);
    }

    private void add0224Databases() {
        this.archiveBuilder.addEntityDef(this.getDeployedDatabaseSchemaEntity());
        this.archiveBuilder.addEntityDef(this.getDatabaseEntity());
        this.archiveBuilder.addClassificationDef(this.getDatabaseServerClassification());
    }

    private EntityDef getDeployedDatabaseSchemaEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DEPLOYED_DATABASE_SCHEMA, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName));
    }

    private EntityDef getDatabaseEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATABASE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_STORE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INSTANCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IMPORTED_FROM));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private ClassificationDef getDatabaseServerClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.DATABASE_SERVER_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0225MetadataRepositories() {
        this.archiveBuilder.addEntityDef(this.getEnterpriseAccessLayerEntity());
        this.archiveBuilder.addEntityDef(this.getCohortMemberEntity());
        this.archiveBuilder.addEntityDef(this.getMetadataRepositoryCohortEntity());
        this.archiveBuilder.addEntityDef(this.getMetadataCollectionEntity());
        this.archiveBuilder.addEntityDef(this.getMetadataRepositoryEntity());
        this.archiveBuilder.addEntityDef(this.getCohortRegistryStoreEntity());
        this.archiveBuilder.addRelationshipDef(this.getMetadataCohortPeerRelationship());
        this.archiveBuilder.addRelationshipDef(this.getCohortMemberMetadataCollectionRelationship());
        this.archiveBuilder.addClassificationDef(this.getMetadataServerClassification());
        this.archiveBuilder.addClassificationDef(this.getRepositoryProxyClassification());
    }

    private EntityDef getEnterpriseAccessLayerEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ENTERPRISE_ACCESS_LAYER, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TOPIC_ROOT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENTERPRISE_METADATA_COLLECTION_ID));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getCohortMemberEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.COHORT_MEMBER, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
    }

    private EntityDef getMetadataRepositoryCohortEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.METADATA_REPOSITORY_COHORT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COHORT_TOPICS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getMetadataCollectionEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.METADATA_COLLECTION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MANAGED_METADATA_COLLECTION_ID));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getMetadataRepositoryEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.METADATA_REPOSITORY, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_STORE.typeName));
    }

    private EntityDef getCohortRegistryStoreEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.COHORT_REGISTRY_STORE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_STORE.typeName));
    }

    private RelationshipDef getMetadataCohortPeerRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.METADATA_COHORT_PEER_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "registeredWithCohorts";
        String end1AttributeDescription = "Identifies which cohorts this cohort member is registered with.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.METADATA_REPOSITORY_COHORT.typeName), "registeredWithCohorts", "Identifies which cohorts this cohort member is registered with.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "cohortMembership";
        String end2AttributeDescription = "Members of this cohort.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.COHORT_MEMBER.typeName), "cohortMembership", "Members of this cohort.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REGISTRATION_DATE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getCohortMemberMetadataCollectionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.COHORT_MEMBER_METADATA_COLLECTION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "cohortMember";
        String end1AttributeDescription = "Cohort registry representing this metadata collection on the metadata highway.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.COHORT_MEMBER.typeName), "cohortMember", "Cohort registry representing this metadata collection on the metadata highway.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "localMetadataCollection";
        String end2AttributeDescription = "Metadata to exchange with the cohorts.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.METADATA_COLLECTION.typeName), "localMetadataCollection", "Metadata to exchange with the cohorts.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getMetadataServerClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.METADATA_SERVER_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMAT));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getRepositoryProxyClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.REPOSITORY_PROXY_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER.typeName), false);
    }

    private void add0227Keystores() {
        this.archiveBuilder.addEntityDef(this.getKeystoreFileEntity());
        this.archiveBuilder.addEntityDef(this.geSecretsCollectionEntity());
    }

    private EntityDef getKeystoreFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.KEYSTORE_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
    }

    private EntityDef geSecretsCollectionEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SECRETS_COLLECTION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName));
    }

    private void add0230CodeTables() {
        this.archiveBuilder.addEntityDef(this.getReferenceCodeTableEntity());
        this.archiveBuilder.addEntityDef(this.getReferenceCodeMappingTableEntity());
    }

    private EntityDef getReferenceCodeTableEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.REFERENCE_CODE_TABLE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName));
    }

    private EntityDef getReferenceCodeMappingTableEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.REFERENCE_CODE_MAPPING_TABLE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName));
    }

    private void add0235InformationView() {
        this.archiveBuilder.addEntityDef(this.getInformationViewEntity());
    }

    private EntityDef getInformationViewEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.INFORMATION_VIEW, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName));
    }

    private void add0239Reports() {
        this.archiveBuilder.addEntityDef(this.getFormEntity());
        this.archiveBuilder.addEntityDef(this.getDeployedReportEntity());
    }

    private EntityDef getFormEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.FORM, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName));
    }

    private EntityDef getDeployedReportEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DEPLOYED_REPORT, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AUTHOR));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.URL));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CREATED_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LAST_MODIFIED_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LAST_MODIFIER));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0290Ports() {
        this.archiveBuilder.addEnumDef(this.getPortTypeEnum());
        this.archiveBuilder.addEntityDef(this.getPortEntity());
        this.archiveBuilder.addEntityDef(this.getPortAliasEntity());
        this.archiveBuilder.addEntityDef(this.getPortImplementationEntity());
        this.archiveBuilder.addRelationshipDef(this.getProcessPortRelationship());
        this.archiveBuilder.addRelationshipDef(this.getPortDelegationRelationship());
    }

    private EnumDef getPortTypeEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(PortType.getOpenTypeGUID(), PortType.getOpenTypeName(), PortType.getOpenTypeDescription(), PortType.getOpenTypeDescriptionGUID(), PortType.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (PortType enumValue : PortType.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getPortEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PORT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.PORT_TYPE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getPortAliasEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PORT_ALIAS, this.archiveBuilder.getEntityDef(OpenMetadataType.PORT.typeName));
    }

    private EntityDef getPortImplementationEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PORT_IMPLEMENTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.PORT.typeName));
    }

    private RelationshipDef getPortDelegationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PORT_DELEGATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "delegatingFrom";
        String end1AttributeDescription = "Higher level Port";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PORT.typeName), "delegatingFrom", "Higher level Port", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "delegatingTo";
        String end2AttributeDescription = "Lower level port";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PORT.typeName), "delegatingTo", "Lower level port", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getProcessPortRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PROCESS_PORT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "owningProcess";
        String end1AttributeDescription = "Process linked to the port";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PROCESS.typeName), "owningProcess", "Process linked to the port", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "ports";
        String end2AttributeDescription = "Port to the process";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PORT.typeName), "ports", "Port to the process", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void addArea3Types() {
        this.add0310Glossary();
        this.add0320CategoryHierarchy();
        this.add0330Terms();
        this.add0340Dictionary();
        this.add0350RelatedTerms();
        this.add0360Contexts();
        this.add0370SemanticAssignment();
        this.add0380SpineObjects();
        this.add0385ControlledGlossaryDevelopment();
        this.add0390GlossaryProject();
    }

    private void add0310Glossary() {
        this.archiveBuilder.addEntityDef(this.getGlossaryEntity());
        this.archiveBuilder.addClassificationDef(this.getTaxonomyClassification());
        this.archiveBuilder.addClassificationDef(this.getCanonicalVocabularyClassification());
    }

    private EntityDef getGlossaryEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GLOSSARY, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LANGUAGE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USAGE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private ClassificationDef getTaxonomyClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.TAXONOMY_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ORGANIZING_PRINCIPLE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getCanonicalVocabularyClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CANONICAL_VOCABULARY_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCOPE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0320CategoryHierarchy() {
        this.archiveBuilder.addEntityDef(this.getGlossaryCategoryEntity());
        this.archiveBuilder.addRelationshipDef(this.getCategoryAnchorRelationship());
        this.archiveBuilder.addRelationshipDef(this.getCategoryHierarchyLinkRelationship());
        this.archiveBuilder.addClassificationDef(this.getSubjectAreaClassification());
    }

    private EntityDef getGlossaryCategoryEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GLOSSARY_CATEGORY, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getCategoryAnchorRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CATEGORY_ANCHOR_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "anchor";
        String end1AttributeDescription = "Owning glossary for this category.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY.typeName), "anchor", "Owning glossary for this category.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "categories";
        String end2AttributeDescription = "Categories owned by this glossary.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_CATEGORY.typeName), "categories", "Categories owned by this glossary.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getCategoryHierarchyLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CATEGORY_HIERARCHY_LINK_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "superCategory";
        String end1AttributeDescription = "Identifies the parent category.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_CATEGORY.typeName), "superCategory", "Identifies the parent category.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "subcategories";
        String end2AttributeDescription = "Glossary categories nested inside this category.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_CATEGORY.typeName), "subcategories", "Glossary categories nested inside this category.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getSubjectAreaClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.SUBJECT_AREA_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0330Terms() {
        this.archiveBuilder.addEnumDef(this.getTermRelationshipStatusEnum());
        this.archiveBuilder.addEntityDef(this.getGlossaryTermEntity());
        this.archiveBuilder.addRelationshipDef(this.getTermAnchorRelationship());
        this.archiveBuilder.addRelationshipDef(this.getTermCategorizationRelationship());
    }

    private EnumDef getTermRelationshipStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(GlossaryTermRelationshipStatus.getOpenTypeGUID(), GlossaryTermRelationshipStatus.getOpenTypeName(), GlossaryTermRelationshipStatus.getOpenTypeDescription(), GlossaryTermRelationshipStatus.getOpenTypeDescriptionGUID(), GlossaryTermRelationshipStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (GlossaryTermRelationshipStatus enumValues : GlossaryTermRelationshipStatus.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getGlossaryTermEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GLOSSARY_TERM, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SUMMARY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXAMPLES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ABBREVIATION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USAGE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getTermAnchorRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TERM_ANCHOR_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "anchor";
        String end1AttributeDescription = "Owning glossary.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY.typeName), "anchor", "Owning glossary.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "terms";
        String end2AttributeDescription = "Terms owned by this glossary.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "terms", "Terms owned by this glossary.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getTermCategorizationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TERM_CATEGORIZATION, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "categories";
        String end1AttributeDescription = "Glossary categories that this term is linked to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_CATEGORY.typeName), "categories", "Glossary categories that this term is linked to.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "terms";
        String end2AttributeDescription = "Glossary terms linked to this category.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "terms", "Glossary terms linked to this category.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0340Dictionary() {
        this.archiveBuilder.addEnumDef(this.getActivityTypeEnum());
        this.archiveBuilder.addClassificationDef(this.getActivityDescriptionClassification());
        this.archiveBuilder.addClassificationDef(this.getAbstractConceptClassification());
        this.archiveBuilder.addClassificationDef(this.getDataValueClassification());
    }

    private EnumDef getActivityTypeEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(GlossaryTermActivityType.getOpenTypeGUID(), GlossaryTermActivityType.getOpenTypeName(), GlossaryTermActivityType.getOpenTypeDescription(), GlossaryTermActivityType.getOpenTypeDescriptionGUID(), GlossaryTermActivityType.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (GlossaryTermActivityType enumValues : GlossaryTermActivityType.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private ClassificationDef getActivityDescriptionClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.ACTIVITY_TYPE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getAbstractConceptClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.ABSTRACT_CONCEPT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), false);
    }

    private ClassificationDef getDataValueClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.DATA_VALUE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), false);
    }

    private void add0350RelatedTerms() {
        this.archiveBuilder.addRelationshipDef(this.getRelatedTermRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSynonymRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAntonymRelationship());
        this.archiveBuilder.addRelationshipDef(this.getPreferredTermRelationship());
        this.archiveBuilder.addRelationshipDef(this.getReplacementTermRelationship());
        this.archiveBuilder.addRelationshipDef(this.getTranslationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getISARelationshipRelationship());
        this.archiveBuilder.addRelationshipDef(this.getValidValueRelationship());
    }

    private RelationshipDef getRelatedTermRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.RELATED_TERM_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "seeAlso";
        String end1AttributeDescription = "Related glossary terms.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "seeAlso", "Related glossary terms.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "seeAlso";
        String end2AttributeDescription = "Related glossary terms.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "seeAlso", "Related glossary terms.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TERM_RELATIONSHIP_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getSynonymRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SYNONYM_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "synonyms";
        String end1AttributeDescription = "Glossary terms with the same meaning.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "synonyms", "Glossary terms with the same meaning.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "synonyms";
        String end2AttributeDescription = "Glossary terms with the same meaning.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "synonyms", "Glossary terms with the same meaning.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TERM_RELATIONSHIP_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getAntonymRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ANTONYM_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "antonyms";
        String end1AttributeDescription = "Glossary terms with the opposite meaning.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "antonyms", "Glossary terms with the opposite meaning.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "antonyms";
        String end2AttributeDescription = "Glossary terms with the opposite meaning.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "antonyms", "Glossary terms with the opposite meaning.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TERM_RELATIONSHIP_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getPreferredTermRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PREFERRED_TERM_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "alternateTerms";
        String end1AttributeDescription = "Alternative glossary terms.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "alternateTerms", "Alternative glossary terms.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "preferredTerms";
        String end2AttributeDescription = "Related glossary terms.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "preferredTerms", "Related glossary terms.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TERM_RELATIONSHIP_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getReplacementTermRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.REPLACEMENT_TERM_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "replacedTerms";
        String end1AttributeDescription = "Replaced glossary terms.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "replacedTerms", "Replaced glossary terms.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "replacementTerms";
        String end2AttributeDescription = "Replacement glossary terms.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "replacementTerms", "Replacement glossary terms.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TERM_RELATIONSHIP_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getTranslationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TRANSLATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "translations";
        String end1AttributeDescription = "Translations of glossary term.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "translations", "Translations of glossary term.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "translations";
        String end2AttributeDescription = "Translations of glossary term.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "translations", "Translations of glossary term.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TERM_RELATIONSHIP_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getISARelationshipRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ISA_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "classifies";
        String end1AttributeDescription = "More specific glossary terms.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "classifies", "More specific glossary terms.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "isA";
        String end2AttributeDescription = "More general glossary terms.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "isA", "More general glossary terms.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TERM_RELATIONSHIP_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getValidValueRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.VALID_VALUE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "validValueFor";
        String end1AttributeDescription = "Glossary terms for data items that can be set to this value.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "validValueFor", "Glossary terms for data items that can be set to this value.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "validValues";
        String end2AttributeDescription = "Glossary terms for data values that can be used with data items represented by this glossary term.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "validValues", "Glossary terms for data values that can be used with data items represented by this glossary term.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TERM_RELATIONSHIP_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0360Contexts() {
        this.archiveBuilder.addRelationshipDef(this.getUsedInContextRelationship());
        this.archiveBuilder.addClassificationDef(this.getContextDefinitionClassification());
    }

    private RelationshipDef getUsedInContextRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.USED_IN_CONTEXT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "contextRelevantTerms";
        String end1AttributeDescription = "Glossary terms used in this specific context.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "contextRelevantTerms", "Glossary terms used in this specific context.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "usedInContexts";
        String end2AttributeDescription = "Glossary terms describing the contexts where this term is used.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "usedInContexts", "Glossary terms describing the contexts where this term is used.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TERM_RELATIONSHIP_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getContextDefinitionClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CONTEXT_DEFINITION_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCOPE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0370SemanticAssignment() {
        this.archiveBuilder.addEnumDef(this.getTermAssignmentStatusEnum());
        this.archiveBuilder.addRelationshipDef(this.getSemanticAssignmentRelationship());
    }

    private EnumDef getTermAssignmentStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(GlossaryTermAssignmentStatus.getOpenTypeGUID(), GlossaryTermAssignmentStatus.getOpenTypeName(), GlossaryTermAssignmentStatus.getOpenTypeDescription(), GlossaryTermAssignmentStatus.getOpenTypeDescriptionGUID(), GlossaryTermAssignmentStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (GlossaryTermAssignmentStatus enumValues : GlossaryTermAssignmentStatus.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private RelationshipDef getSemanticAssignmentRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "assignedDataAssetElements";
        String end1AttributeDescription = "Elements identified as managing data that has the same meaning as this glossary term.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "assignedDataAssetElements", "Elements identified as managing data that has the same meaning as this glossary term.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "meaning";
        String end2AttributeDescription = "Semantic definition for this element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "meaning", "Semantic definition for this element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TERM_ASSIGNMENT_STATUS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_PROPERTY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0380SpineObjects() {
        this.archiveBuilder.addRelationshipDef(this.getTermHASARelationshipRelationship());
        this.archiveBuilder.addRelationshipDef(this.getTermTYPEDBYRelationshipRelationship());
        this.archiveBuilder.addClassificationDef(this.getSpineObjectClassification());
        this.archiveBuilder.addClassificationDef(this.getSpineAttributeClassification());
        this.archiveBuilder.addClassificationDef(this.getObjectIdentifierClassification());
    }

    private RelationshipDef getTermHASARelationshipRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TERM_HAS_A_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "objects";
        String end1AttributeDescription = "Objects where this attribute may occur.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "objects", "Objects where this attribute may occur.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "attributes";
        String end2AttributeDescription = "Typical attributes for this object.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "attributes", "Typical attributes for this object.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TERM_RELATIONSHIP_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getTermTYPEDBYRelationshipRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TERM_TYPED_BY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "attributesTypedBy";
        String end1AttributeDescription = "Attributes of this type.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "attributesTypedBy", "Attributes of this type.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "types";
        String end2AttributeDescription = "Types for this attribute.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "types", "Types for this attribute.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TERM_RELATIONSHIP_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getSpineObjectClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.SPINE_OBJECT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), false);
    }

    private ClassificationDef getSpineAttributeClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.SPINE_ATTRIBUTE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), false);
    }

    private ClassificationDef getObjectIdentifierClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.OBJECT_IDENTIFIER_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
    }

    private void add0385ControlledGlossaryDevelopment() {
        this.archiveBuilder.addEntityDef(this.getControlledGlossaryTermEntity());
    }

    private EntityDef getControlledGlossaryTermEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CONTROLLED_GLOSSARY_TERM, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName));
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private void add0390GlossaryProject() {
        this.archiveBuilder.addClassificationDef(this.getGlossaryProjectClassification());
    }

    private ClassificationDef getGlossaryProjectClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.GLOSSARY_PROJECT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT.typeName), false);
    }

    private void addArea4Types() {
        this.add0401GovernanceDefinitions();
        this.add0405GovernanceDrivers();
        this.add0415GovernanceResponses();
        this.add0417GovernanceProject();
        this.add0420GovernanceControls();
        this.add0422GovernanceActionClassifications();
        this.add0423SecurityTags();
        this.add0424GovernanceZones();
        this.add0430TechnicalControls();
        this.add0438NamingStandards();
        this.add0440OrganizationalControls();
        this.add0442ProjectCharter();
        this.add0445GovernanceRoles();
        this.add0450GovernanceRollout();
        this.add0455ExceptionManagement();
        this.add0460GovernanceControls();
        this.add0481Licenses();
        this.add0482Certifications();
    }

    private void add0401GovernanceDefinitions() {
        this.archiveBuilder.addEnumDef(this.getGovernanceDomainEnum());
        this.archiveBuilder.addEntityDef(this.getGovernanceDefinitionEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceOfficerEntity());
    }

    private EnumDef getGovernanceDomainEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(GovernanceDomain.getOpenTypeGUID(), GovernanceDomain.getOpenTypeName(), GovernanceDomain.getOpenTypeDescription(), GovernanceDomain.getOpenTypeDescriptionGUID());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (GovernanceDomain enumValue : GovernanceDomain.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getGovernanceDefinitionEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_DEFINITION, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TITLE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SUMMARY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCOPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IMPORTANCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IMPLICATIONS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.OUTCOMES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RESULTS));
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private EntityDef getGovernanceOfficerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_OFFICER, this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName));
    }

    private void add0405GovernanceDrivers() {
        this.archiveBuilder.addEntityDef(this.getGovernanceDriverEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceStrategyEntity());
        this.archiveBuilder.addEntityDef(this.getRegulationEntity());
    }

    private EntityDef getGovernanceDriverEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_DRIVER, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_DEFINITION.typeName));
    }

    private EntityDef getGovernanceStrategyEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_STRATEGY, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_DRIVER.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.BUSINESS_IMPERATIVES));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getRegulationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.REGULATION, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_DRIVER.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.JURISDICTION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0415GovernanceResponses() {
        this.archiveBuilder.addEntityDef(this.getGovernancePolicyEntity());
        this.archiveBuilder.addEntityDef(this.getGovernancePrincipleEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceObligationEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceApproachEntity());
        this.archiveBuilder.addRelationshipDef(this.getGovernancePolicyLinkRelationship());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceResponseRelationship());
    }

    private EntityDef getGovernancePolicyEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_POLICY, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_DEFINITION.typeName));
    }

    private EntityDef getGovernancePrincipleEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_PRINCIPLE, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_POLICY.typeName));
    }

    private EntityDef getGovernanceObligationEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_OBLIGATION, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_POLICY.typeName));
    }

    private EntityDef getGovernanceApproachEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_APPROACH, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_POLICY.typeName));
    }

    private RelationshipDef getGovernancePolicyLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GOVERNANCE_POLICY_LINK_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "linkingPolicies";
        String end1AttributeDescription = "Policies that are dependent on this policy.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_POLICY.typeName), "linkingPolicies", "Policies that are dependent on this policy.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "linkedPolicies";
        String end2AttributeDescription = "Policies that further define aspects of this policy.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_POLICY.typeName), "linkedPolicies", "Policies that further define aspects of this policy.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getGovernanceResponseRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GOVERNANCE_RESPONSE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "drivers";
        String end1AttributeDescription = "Drivers that justify this policy.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_DRIVER.typeName), "drivers", "Drivers that justify this policy.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "policies";
        String end2AttributeDescription = "Governance policies that support this governance driver.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_POLICY.typeName), "policies", "Governance policies that support this governance driver.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RATIONALE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0417GovernanceProject() {
        this.archiveBuilder.addClassificationDef(this.getGovernanceProjectClassification());
    }

    private ClassificationDef getGovernanceProjectClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.GOVERNANCE_PROJECT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT.typeName), false);
    }

    private void add0420GovernanceControls() {
        this.archiveBuilder.addEntityDef(this.getGovernanceControlEntity());
        this.archiveBuilder.addEntityDef(this.getTechnicalControlEntity());
        this.archiveBuilder.addEntityDef(this.getOrganizationalControlEntity());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceImplementationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceControlLinkRelationship());
    }

    private EntityDef getGovernanceControlEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_CONTROL, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_DEFINITION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IMPLEMENTATION_DESCRIPTION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getTechnicalControlEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TECHNICAL_CONTROL, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_CONTROL.typeName));
    }

    private EntityDef getOrganizationalControlEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ORGANIZATIONAL_CONTROL, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_CONTROL.typeName));
    }

    private RelationshipDef getGovernanceImplementationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GOVERNANCE_IMPLEMENTATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "policies";
        String end1AttributeDescription = "The policies that are supported by this control.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_POLICY.typeName), "policies", "The policies that are supported by this control.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "implementations";
        String end2AttributeDescription = "The governance controls that implement this policy.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_CONTROL.typeName), "implementations", "The governance controls that implement this policy.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RATIONALE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getGovernanceControlLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GOVERNANCE_CONTROL_LINK_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "linkingControls";
        String end1AttributeDescription = "Governance controls that ate dependent on this control.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_CONTROL.typeName), "linkingControls", "Governance controls that ate dependent on this control.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "linkedControls";
        String end2AttributeDescription = "Governance controls that support the implementation of this control.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_CONTROL.typeName), "linkedControls", "Governance controls that support the implementation of this control.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0422GovernanceActionClassifications() {
        this.archiveBuilder.addEnumDef(this.getGovernanceClassificationStatusEnum());
        this.archiveBuilder.addEnumDef(this.getConfidentialityLevelEnum());
        this.archiveBuilder.addEnumDef(this.getConfidenceLevelEnum());
        this.archiveBuilder.addEnumDef(this.getRetentionBasisEnum());
        this.archiveBuilder.addEnumDef(this.getCriticalityLevelEnum());
        this.archiveBuilder.addClassificationDef(this.getConfidentialityClassification());
        this.archiveBuilder.addClassificationDef(this.getConfidenceClassification());
        this.archiveBuilder.addClassificationDef(this.getRetentionClassification());
        this.archiveBuilder.addClassificationDef(this.getCriticalityClassification());
    }

    private EnumDef getGovernanceClassificationStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(GovernanceClassificationStatus.getOpenTypeGUID(), GovernanceClassificationStatus.getOpenTypeName(), GovernanceClassificationStatus.getOpenTypeDescription(), GovernanceClassificationStatus.getOpenTypeDescriptionGUID(), GovernanceClassificationStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (CriticalityLevel enumValues : CriticalityLevel.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getConfidentialityLevelEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ConfidentialityLevel.getOpenTypeGUID(), ConfidentialityLevel.getOpenTypeName(), ConfidentialityLevel.getOpenTypeDescription(), ConfidentialityLevel.getOpenTypeDescriptionGUID(), ConfidentialityLevel.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ConfidentialityLevel enumValues : ConfidentialityLevel.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getConfidenceLevelEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ConfidenceLevel.getOpenTypeGUID(), ConfidenceLevel.getOpenTypeName(), ConfidenceLevel.getOpenTypeDescription(), ConfidenceLevel.getOpenTypeDescriptionGUID(), ConfidenceLevel.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ConfidenceLevel enumValues : ConfidenceLevel.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getRetentionBasisEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(RetentionBasis.getOpenTypeGUID(), RetentionBasis.getOpenTypeName(), RetentionBasis.getOpenTypeDescription(), RetentionBasis.getOpenTypeDescriptionGUID(), RetentionBasis.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (RetentionBasis enumValues : RetentionBasis.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getCriticalityLevelEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(CriticalityLevel.getOpenTypeGUID(), CriticalityLevel.getOpenTypeName(), CriticalityLevel.getOpenTypeDescription(), CriticalityLevel.getOpenTypeDescriptionGUID(), CriticalityLevel.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (CriticalityLevel enumValues : CriticalityLevel.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private ClassificationDef getConfidentialityClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getConfidenceClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CONFIDENCE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getRetentionClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.RETENTION_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ASSOCIATED_GUID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ARCHIVE_AFTER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DELETE_AFTER));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getCriticalityClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CRITICALITY_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0423SecurityTags() {
        this.archiveBuilder.addClassificationDef(this.getSecurityTagsClassification());
    }

    private ClassificationDef getSecurityTagsClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.SECURITY_TAGS_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SECURITY_LABELS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SECURITY_PROPERTIES));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0424GovernanceZones() {
        this.archiveBuilder.addClassificationDef(this.getAssetZoneMembershipClassification());
        this.archiveBuilder.addEntityDef(this.getGovernanceZoneEntity());
        this.archiveBuilder.addRelationshipDef(this.getZoneHierarchyRelationship());
    }

    private ClassificationDef getAssetZoneMembershipClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.ASSET_ZONE_MEMBERSHIP_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ZONE_MEMBERSHIP));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private EntityDef getGovernanceZoneEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_ZONE, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CRITERIA));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getZoneHierarchyRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ZONE_HIERARCHY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "inheritsFromZone";
        String end1AttributeDescription = "The zone that provides additional governance requirements.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ZONE.typeName), "inheritsFromZone", "The zone that provides additional governance requirements.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "controlsZone";
        String end2AttributeDescription = "The zones that are also governed in the same way.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ZONE.typeName), "controlsZone", "The zones that are also governed in the same way.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0430TechnicalControls() {
        this.archiveBuilder.addEntityDef(this.getGovernanceRuleEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceProcessEntity());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceRuleImplementationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceProcessImplementationRelationship());
    }

    private EntityDef getGovernanceRuleEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_RULE, this.archiveBuilder.getEntityDef(OpenMetadataType.TECHNICAL_CONTROL.typeName));
    }

    private EntityDef getGovernanceProcessEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_PROCESS, this.archiveBuilder.getEntityDef(OpenMetadataType.TECHNICAL_CONTROL.typeName));
    }

    private RelationshipDef getGovernanceRuleImplementationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GOVERNANCE_RULE_IMPLEMENTATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "implementsGovernanceRules";
        String end1AttributeDescription = "The rules that are implemented by this component.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_RULE.typeName), "implementsGovernanceRules", "The rules that are implemented by this component.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "implementations";
        String end2AttributeDescription = "The software components that implement this governance rule.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DEPLOYED_SOFTWARE_COMPONENT.typeName), "implementations", "The software components that implement this governance rule.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getGovernanceProcessImplementationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GOVERNANCE_PROCESS_IMPLEMENTATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "implementsGovernanceProcesses";
        String end1AttributeDescription = "The processes that are implemented by this component.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_PROCESS.typeName), "implementsGovernanceProcesses", "The processes that are implemented by this component.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "implementations";
        String end2AttributeDescription = "The processes that implement this governance process.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PROCESS.typeName), "implementations", "The processes that implement this governance process.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0438NamingStandards() {
        this.archiveBuilder.addEntityDef(this.getNamingStandardRuleEntity());
        this.archiveBuilder.addEntityDef(this.getNamingStandardRuleSetEntity());
        this.archiveBuilder.addClassificationDef(this.getPrimeWordClassification());
        this.archiveBuilder.addClassificationDef(this.getClassWordClassification());
    }

    private EntityDef getNamingStandardRuleEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.NAMING_STANDARD_RULE, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_RULE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME_PATTERNS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getNamingStandardRuleSetEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.NAMING_STANDARD_RULE_SET, this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName));
    }

    private ClassificationDef getPrimeWordClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.PRIME_WORD_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), false);
    }

    private ClassificationDef getClassWordClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.CLASS_WORD_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), false);
    }

    private void add0440OrganizationalControls() {
        this.archiveBuilder.addEnumDef(this.getBusinessCapabilityTypeEnum());
        this.archiveBuilder.addEntityDef(this.getOrganizationEntity());
        this.archiveBuilder.addEntityDef(this.getBusinessCapabilityEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceResponsibilityEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceProcedureEntity());
        this.archiveBuilder.addClassificationDef(this.getAssetOriginClassification());
        this.archiveBuilder.addRelationshipDef(this.getOrganizationCapabilityRelationship());
    }

    private EnumDef getBusinessCapabilityTypeEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(BusinessCapabilityType.getOpenTypeGUID(), BusinessCapabilityType.getOpenTypeName(), BusinessCapabilityType.getOpenTypeDescription(), BusinessCapabilityType.getOpenTypeDescriptionGUID());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (BusinessCapabilityType enumValue : BusinessCapabilityType.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getOrganizationEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ORGANIZATION, this.archiveBuilder.getEntityDef(OpenMetadataType.TEAM.typeName));
    }

    private EntityDef getBusinessCapabilityEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.BUSINESS_CAPABILITY, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getGovernanceResponsibilityEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_RESPONSIBILITY, this.archiveBuilder.getEntityDef(OpenMetadataType.ORGANIZATIONAL_CONTROL.typeName));
    }

    private EntityDef getGovernanceProcedureEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_PROCEDURE, this.archiveBuilder.getEntityDef(OpenMetadataType.ORGANIZATIONAL_CONTROL.typeName));
    }

    private ClassificationDef getAssetOriginClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.ASSET_ORIGIN_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ORGANIZATION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.BUSINESS_CAPABILITY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.OTHER_ORIGIN_VALUES));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private RelationshipDef getOrganizationCapabilityRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ORGANIZATIONAL_CAPABILITY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "supportsBusinessCapabilities";
        String end1AttributeDescription = "The business capabilities that this team supports.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.BUSINESS_CAPABILITY.typeName), "supportsBusinessCapabilities", "The business capabilities that this team supports.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "supportingTeams";
        String end2AttributeDescription = "The teams that support this business capability.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TEAM.typeName), "supportingTeams", "The teams that support this business capability.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0442ProjectCharter() {
        this.archiveBuilder.addEntityDef(this.getProjectCharterEntity());
        this.archiveBuilder.addRelationshipDef(this.getProjectCharterLinkRelationship());
    }

    private EntityDef getProjectCharterEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PROJECT_CHARTER, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MISSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROJECT_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PURPOSES));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getProjectCharterLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PROJECT_CHARTER_LINK_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "projects";
        String end1AttributeDescription = "The projects guided by this charter.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT.typeName), "projects", "The projects guided by this charter.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "charter";
        String end2AttributeDescription = "The charter guiding this project.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT_CHARTER.typeName), "charter", "The charter guiding this project.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0445GovernanceRoles() {
        this.archiveBuilder.addEntityDef(this.getGovernanceRoleEntity());
        this.archiveBuilder.addEntityDef(this.getAssetOwnerEntity());
        this.archiveBuilder.addEntityDef(this.getSubjectAreaOwnerEntity());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceResponsibilityAssignmentRelationship());
    }

    private EntityDef getGovernanceRoleEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_ROLE, this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName));
    }

    private EntityDef getAssetOwnerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ASSET_OWNER, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ROLE.typeName));
    }

    private EntityDef getSubjectAreaOwnerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SUBJECT_AREA_OWNER, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ROLE.typeName));
    }

    private RelationshipDef getGovernanceResponsibilityAssignmentRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GOVERNANCE_RESPONSIBILITY_ASSIGNMENT, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "performedByRoles";
        String end1AttributeDescription = "The roles assigned to this responsibility.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ROLE.typeName), "performedByRoles", "The roles assigned to this responsibility.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        String end2AttributeName = "governanceResponsibilities";
        String end2AttributeDescription = "The responsibilities performed by this role.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_RESPONSIBILITY.typeName), "governanceResponsibilities", "The responsibilities performed by this role.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        return relationshipDef;
    }

    private void add0450GovernanceRollout() {
        this.archiveBuilder.addEntityDef(this.getGovernanceMetricEntity());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceDefinitionMetricRelationship());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceResultsRelationship());
        this.archiveBuilder.addClassificationDef(this.getGovernanceMeasurementsDataSetClassification());
    }

    private EntityDef getGovernanceMetricEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_METRIC, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MEASUREMENT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TARGET));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getGovernanceDefinitionMetricRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GOVERNANCE_DEFINITION_METRIC_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "metrics";
        String end1AttributeDescription = "The metrics that measure the landscape against this governance definition.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_METRIC.typeName), "metrics", "The metrics that measure the landscape against this governance definition.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        String end2AttributeName = "measuredDefinitions";
        String end2AttributeDescription = "The governance definitions that are measured by this metric.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_DEFINITION.typeName), "measuredDefinitions", "The governance definitions that are measured by this metric.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RATIONALE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getGovernanceResultsRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GOVERNANCE_RESULTS_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "metrics";
        String end1AttributeDescription = "The governance metrics that are captured in this data set.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_METRIC.typeName), "metrics", "The governance metrics that are captured in this data set.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "measurements";
        String end2AttributeDescription = "The data set that captures the measurements for this governance metric.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName), "measurements", "The data set that captures the measurements for this governance metric.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUERY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUERY_TYPE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getGovernanceMeasurementsDataSetClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.GOVERNANCE_MEASUREMENTS_RESULTS_DATA_SET_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0455ExceptionManagement() {
        this.archiveBuilder.addClassificationDef(this.getExceptionBacklogClassification());
        this.archiveBuilder.addClassificationDef(this.getAuditLogClassification());
        this.archiveBuilder.addClassificationDef(this.getMeteringLogClassification());
        this.archiveBuilder.addClassificationDef(this.getStewardshipServerClassification());
        this.archiveBuilder.addClassificationDef(this.getGovernanceDaemonClassification());
    }

    private ClassificationDef getExceptionBacklogClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.EXCEPTION_BACKLOG_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROCESS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getAuditLogClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.AUDIT_LOG_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROCESS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getMeteringLogClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.METERING_LOG_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROCESS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getStewardshipServerClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.STEWARDSHIP_SERVER_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER.typeName), false);
    }

    private ClassificationDef getGovernanceDaemonClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.GOVERNANCE_DAEMON_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER.typeName), false);
    }

    private void add0460GovernanceControls() {
        this.archiveBuilder.addClassificationDef(this.getControlPointClassification());
        this.archiveBuilder.addClassificationDef(this.getVerificationPointClassification());
        this.archiveBuilder.addClassificationDef(this.getEnforcementPointClassification());
    }

    private ClassificationDef getControlPointClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.CONTROL_POINT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
    }

    private ClassificationDef getVerificationPointClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.VERIFICATION_POINT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
    }

    private ClassificationDef getEnforcementPointClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.ENFORCEMENT_POINT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
    }

    private void add0481Licenses() {
        this.archiveBuilder.addEntityDef(this.getLicenseTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.getLicenseRelationship());
    }

    private EntityDef getLicenseTypeEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.LICENSE_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_DEFINITION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DETAILS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getLicenseRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.LICENSE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "licensed";
        String end1AttributeDescription = "Items licensed by this type of license.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "licensed", "Items licensed by this type of license.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "licenses";
        String end2AttributeDescription = "The types of licenses that apply.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.LICENSE_TYPE.typeName), "licenses", "The types of licenses that apply.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LICENSE_GUID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.START));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.END));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONDITIONS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LICENSED_BY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CUSTODIAN));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LICENSEE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0482Certifications() {
        this.archiveBuilder.addEntityDef(this.getCertificationTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.getCertificationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getRegulationCertificationTypeRelationship());
    }

    private EntityDef getCertificationTypeEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CERTIFICATION_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_DEFINITION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DETAILS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getCertificationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CERTIFICATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "certifies";
        String end1AttributeDescription = "Items certified by this type of certification.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "certifies", "Items certified by this type of certification.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "certifications";
        String end2AttributeDescription = "The types of certifications that apply.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CERTIFICATION_TYPE.typeName), "certifications", "The types of certifications that apply.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CERTIFICATE_GUID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.START));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.END));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONDITIONS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CERTIFIED_BY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CUSTODIAN));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RECIPIENT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getRegulationCertificationTypeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.REGULATION_CERTIFICATION_TYPE, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "relatedRegulations";
        String end1AttributeDescription = "Regulations that require this type of certification.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REGULATION.typeName), "relatedRegulations", "Regulations that require this type of certification.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "requiredCertifications";
        String end2AttributeDescription = "The certifications required by this regulation.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CERTIFICATION_TYPE.typeName), "requiredCertifications", "The certifications required by this regulation.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void addArea5Types() {
        this.add0501SchemaElements();
        this.add0503AssetSchemas();
        this.add0504ImplementationSnippets();
        this.add0505SchemaAttributes();
        this.add0511SchemaMapElements();
        this.add0530TabularSchemas();
        this.add0531DocumentSchemas();
        this.add0532ObjectSchemas();
        this.add0533GraphSchemas();
        this.add0534RelationalSchemas();
        this.add0535EventSchemas();
        this.add0536APISchemas();
        this.add0540DataClasses();
        this.add0545ReferenceData();
        this.add0565DesignModelElements();
        this.add0566DesignModelOrganization();
        this.add0568DesignModelScoping();
        this.add0569DesignModelImplementation();
        this.add0570MetaModel();
        this.add0571ConceptModels();
        this.add0595DesignPatterns();
        this.add0598LineageRelationships();
    }

    private void add0501SchemaElements() {
        this.archiveBuilder.addEntityDef(this.getSchemaElementEntity());
        this.archiveBuilder.addEntityDef(this.getSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getSchemaTypeChoiceEntity());
        this.archiveBuilder.addEntityDef(this.getLiteralSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getSimpleSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getPrimitiveSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getEnumSchemaTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.getSchemaTypeOptionRelationship());
    }

    private EntityDef getSchemaElementEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SCHEMA_ELEMENT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getSchemaTypeEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ELEMENT.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAMESPACE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VERSION_NUMBER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AUTHOR));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENCODING_STANDARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USAGE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getSchemaTypeChoiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SCHEMA_TYPE_CHOICE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName));
    }

    private EntityDef getLiteralSchemaTypeEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.LITERAL_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DATA_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FIXED_VALUE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getSimpleSchemaTypeEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SIMPLE_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DATA_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DEFAULT_VALUE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getPrimitiveSchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PRIMITIVE_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.SIMPLE_SCHEMA_TYPE.typeName));
    }

    private EntityDef getEnumSchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ENUM_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.SIMPLE_SCHEMA_TYPE.typeName));
    }

    private RelationshipDef getSchemaTypeOptionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SCHEMA_TYPE_OPTION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "schemaOptionalUses";
        String end1AttributeDescription = "Potential place where this schema type is used.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE_CHOICE.typeName), "schemaOptionalUses", "Potential place where this schema type is used.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "schemaOptions";
        String end2AttributeDescription = "Possible structure of the content of this element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName), "schemaOptions", "Possible structure of the content of this element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0503AssetSchemas() {
        this.archiveBuilder.addRelationshipDef(this.getAssetSchemaTypeRelationship());
    }

    private RelationshipDef getAssetSchemaTypeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "describesAssets";
        String end1AttributeDescription = "Asset that conforms to the schema type.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "describesAssets", "Asset that conforms to the schema type.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "schema";
        String end2AttributeDescription = "Structure of the content of this asset.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName), "schema", "Structure of the content of this asset.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0504ImplementationSnippets() {
        this.archiveBuilder.addEntityDef(this.getImplementationSnippetEntity());
        this.archiveBuilder.addRelationshipDef(this.getSchemaTypeImplementationRelationship());
    }

    private EntityDef getImplementationSnippetEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.IMPLEMENTATION_SNIPPET, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SNIPPET));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IMPLEMENTATION_LANGUAGE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USAGE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getSchemaTypeImplementationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SCHEMA_TYPE_IMPLEMENTATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "implementationSchemaTypes";
        String end1AttributeDescription = "Logical structure for the data.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ELEMENT.typeName), "implementationSchemaTypes", "Logical structure for the data.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "implementations";
        String end2AttributeDescription = "Concrete implementation of the schema type.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PROCESS.typeName), "implementations", "Concrete implementation of the schema type.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0505SchemaAttributes() {
        this.archiveBuilder.addEnumDef(this.getDataItemSortOrderEnum());
        this.archiveBuilder.addEntityDef(this.getSchemaAttributeEntity());
        this.archiveBuilder.addEntityDef(this.getComplexSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getStructSchemaTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.getAttributeForSchemaRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSchemaAttributeTypeRelationship());
        this.archiveBuilder.addRelationshipDef(this.getNestedSchemaAttributeRelationship());
        this.archiveBuilder.addClassificationDef(this.getTypeEmbeddedAttributeClassification());
    }

    private EnumDef getDataItemSortOrderEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(DataItemSortOrder.getOpenTypeGUID(), DataItemSortOrder.getOpenTypeName(), DataItemSortOrder.getOpenTypeDescription(), DataItemSortOrder.getOpenTypeDescriptionGUID(), DataItemSortOrder.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (DataItemSortOrder enumValues : DataItemSortOrder.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getSchemaAttributeEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ELEMENT.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ALLOWS_DUPLICATE_VALUES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ORDERED_VALUES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NATIVE_CLASS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ALIASES));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.SORT_ORDER));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getComplexSchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.COMPLEX_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName));
    }

    private EntityDef getStructSchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.STRUCT_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.COMPLEX_SCHEMA_TYPE.typeName));
    }

    private RelationshipDef getAttributeForSchemaRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "parentSchemas";
        String end1AttributeDescription = "Schema types using this attribute.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.COMPLEX_SCHEMA_TYPE.typeName), "parentSchemas", "Schema types using this attribute.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "attributes";
        String end2AttributeDescription = "The attributes defining the internal structure of the schema type.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName), "attributes", "The attributes defining the internal structure of the schema type.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.POSITION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MIN_CARDINALITY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MAX_CARDINALITY));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getSchemaAttributeTypeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SCHEMA_ATTRIBUTE_TYPE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "usedInSchemas";
        String end1AttributeDescription = "Occurrences of this schema type in other schemas.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName), "usedInSchemas", "Occurrences of this schema type in other schemas.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "type";
        String end2AttributeDescription = "The structure of this attribute.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName), "type", "The structure of this attribute.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getNestedSchemaAttributeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "parentAttribute";
        String end1AttributeDescription = "Schema attribute containing this attribute.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName), "parentAttribute", "Schema attribute containing this attribute.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "nestedAttributes";
        String end2AttributeDescription = "The attributes defining the internal structure of the parent attribute.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName), "nestedAttributes", "The attributes defining the internal structure of the parent attribute.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.POSITION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MIN_CARDINALITY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MAX_CARDINALITY));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getTypeEmbeddedAttributeClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.TYPE_EMBEDDED_ATTRIBUTE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENCODING_STANDARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DATA_TYPE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0511SchemaMapElements() {
        this.archiveBuilder.addEntityDef(this.getMapSchemaTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.getMapFromElementTypeRelationship());
        this.archiveBuilder.addRelationshipDef(this.getMapToElementTypeRelationship());
    }

    private EntityDef getMapSchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.MAP_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName));
    }

    private RelationshipDef getMapFromElementTypeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.MAP_FROM_ELEMENT_TYPE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "parentMapFrom";
        String end1AttributeDescription = "Used in map.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.MAP_SCHEMA_TYPE.typeName), "parentMapFrom", "Used in map.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "mapFromElement";
        String end2AttributeDescription = "Key for this attribute.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName), "mapFromElement", "Key for this attribute.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getMapToElementTypeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.MAP_TO_ELEMENT_TYPE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "parentMapTo";
        String end1AttributeDescription = "Used in map.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.MAP_SCHEMA_TYPE.typeName), "parentMapTo", "Used in map.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "mapToElement";
        String end2AttributeDescription = "Value for this map.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName), "mapToElement", "Value for this map.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0530TabularSchemas() {
        this.archiveBuilder.addEntityDef(this.getTabularSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getTabularColumnEntity());
    }

    private EntityDef getTabularSchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TABULAR_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.COMPLEX_SCHEMA_TYPE.typeName));
    }

    private EntityDef getTabularColumnEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TABULAR_COLUMN, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName));
    }

    private void add0531DocumentSchemas() {
        this.archiveBuilder.addEntityDef(this.getDocumentSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getDocumentSchemaAttributeEntity());
    }

    private EntityDef getDocumentSchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DOCUMENT_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.COMPLEX_SCHEMA_TYPE.typeName));
    }

    private EntityDef getDocumentSchemaAttributeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DOCUMENT_SCHEMA_ATTRIBUTE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName));
    }

    private void add0532ObjectSchemas() {
        this.archiveBuilder.addEntityDef(this.getObjectSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getObjectAttributeEntity());
    }

    private EntityDef getObjectSchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.OBJECT_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.COMPLEX_SCHEMA_TYPE.typeName));
    }

    private EntityDef getObjectAttributeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.OBJECT_ATTRIBUTE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName));
    }

    private void add0533GraphSchemas() {
        this.archiveBuilder.addEntityDef(this.getGraphSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getGraphVertexEntity());
        this.archiveBuilder.addEntityDef(this.getGraphEdgeEntity());
        this.archiveBuilder.addRelationshipDef(this.getGraphEdgeLinkRelationship());
    }

    private EntityDef getGraphSchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GRAPH_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName));
    }

    private EntityDef getGraphVertexEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GRAPH_VERTEX, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName));
    }

    private EntityDef getGraphEdgeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GRAPH_EDGE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName));
    }

    private RelationshipDef getGraphEdgeLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GRAPH_EDGE_LINK_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "edges";
        String end1AttributeDescription = "Edges for this vertex.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GRAPH_EDGE.typeName), "edges", "Edges for this vertex.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "vertices";
        String end2AttributeDescription = "Vertices for this edge.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GRAPH_VERTEX.typeName), "vertices", "Vertices for this edge.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LINK_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RELATIONSHIP_END));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RELATIONSHIP_END_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MIN_CARDINALITY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MAX_CARDINALITY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0534RelationalSchemas() {
        this.archiveBuilder.addEntityDef(this.getRelationalDBSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getRelationalTableTypeEntity());
        this.archiveBuilder.addEntityDef(this.getRelationalTableEntity());
        this.archiveBuilder.addEntityDef(this.getRelationalColumnEntity());
        this.archiveBuilder.addClassificationDef(this.getPrimaryKeyClassification());
        this.archiveBuilder.addRelationshipDef(this.getForeignKeyRelationship());
    }

    private EntityDef getRelationalDBSchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.COMPLEX_SCHEMA_TYPE.typeName));
    }

    private EntityDef getRelationalTableTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RELATIONAL_TABLE_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.TABULAR_SCHEMA_TYPE.typeName));
    }

    private EntityDef getRelationalTableEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RELATIONAL_TABLE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName));
    }

    private EntityDef getRelationalColumnEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RELATIONAL_COLUMN, this.archiveBuilder.getEntityDef(OpenMetadataType.TABULAR_COLUMN.typeName));
    }

    private ClassificationDef getPrimaryKeyClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.PRIMARY_KEY_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.RELATIONAL_COLUMN.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.KEY_PATTERN));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private RelationshipDef getForeignKeyRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.FOREIGN_KEY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "primaryKey";
        String end1AttributeDescription = "Relational column holding the primary key.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.RELATIONAL_COLUMN.typeName), "primaryKey", "Relational column holding the primary key.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "foreignKey";
        String end2AttributeDescription = "Use of primary key from another table to enable table joins.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.RELATIONAL_COLUMN.typeName), "foreignKey", "Use of primary key from another table to enable table joins.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0535EventSchemas() {
        this.archiveBuilder.addEntityDef(this.getEventSetEntity());
        this.archiveBuilder.addEntityDef(this.getEventTypeEntity());
    }

    private EntityDef getEventSetEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EVENT_SET, this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName));
    }

    private EntityDef getEventTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EVENT_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.COMPLEX_SCHEMA_TYPE.typeName));
    }

    private void add0536APISchemas() {
        this.archiveBuilder.addEntityDef(this.getAPISchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getAPIOperationSchemaEntity());
        this.archiveBuilder.addRelationshipDef(this.getAPIOperationsRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAPIHeaderRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAPIRequestRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAPIResponseRelationship());
    }

    private EntityDef getAPISchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.API_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName));
    }

    private EntityDef getAPIOperationSchemaEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.API_OPERATION, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName));
    }

    private RelationshipDef getAPIOperationsRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.API_OPERATIONS_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "usedInAPI";
        String end1AttributeDescription = "API that this operation belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.API_SCHEMA_TYPE.typeName), "usedInAPI", "API that this operation belongs to.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "containsOperations";
        String end2AttributeDescription = "Operations for this API type.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.API_OPERATION.typeName), "containsOperations", "Operations for this API type.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAPIHeaderRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.API_HEADER_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "usedAsAPIHeader";
        String end1AttributeDescription = "API operations using this structure as the header.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.API_OPERATION.typeName), "usedAsAPIHeader", "API operations using this structure as the header.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "apiHeader";
        String end2AttributeDescription = "Header structure for this API operation.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName), "apiHeader", "Header structure for this API operation.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAPIRequestRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.API_REQUEST_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "usedAsAPIRequest";
        String end1AttributeDescription = "API operations using this structure as the request body.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.API_OPERATION.typeName), "usedAsAPIRequest", "API operations using this structure as the request body.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "apiRequest";
        String end2AttributeDescription = "Request structure for this API operation.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName), "apiRequest", "Request structure for this API operation.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAPIResponseRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.API_RESPONSE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "usedAsAPIResponse";
        String end1AttributeDescription = "API operations using this structure as the response.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.API_OPERATION.typeName), "usedAsAPIResponse", "API operations using this structure as the response.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "apiResponse";
        String end2AttributeDescription = "Response structure for this API operation.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName), "apiResponse", "Response structure for this API operation.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0540DataClasses() {
        this.archiveBuilder.addEnumDef(this.getDataClassAssignmentStatusEnum());
        this.archiveBuilder.addEntityDef(this.getDataClassEntity());
        this.archiveBuilder.addRelationshipDef(this.getDataClassHierarchyRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDataClassCompositionRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDataClassAssignmentRelationship());
    }

    private EnumDef getDataClassAssignmentStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(DataClassAssignmentStatus.getOpenTypeGUID(), DataClassAssignmentStatus.getOpenTypeName(), DataClassAssignmentStatus.getOpenTypeDescription(), DataClassAssignmentStatus.getOpenTypeDescriptionGUID(), DataClassAssignmentStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (CriticalityLevel enumValues : CriticalityLevel.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getDataClassEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_CLASS, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAMESPACE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MATCH_PROPERTY_NAMES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MATCH_THRESHOLD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SPECIFICATION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SPECIFICATION_DETAILS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DATA_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ALLOWS_DUPLICATE_VALUES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DEFAULT_VALUE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AVERAGE_VALUE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VALUE_LIST));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VALUE_RANGE_FROM));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VALUE_RANGE_TO));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SAMPLE_VALUES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DATA_PATTERNS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getDataClassHierarchyRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DATA_CLASS_HIERARCHY, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "superDataClass";
        String end1AttributeDescription = "Data class that is the more abstract.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_CLASS.typeName), "superDataClass", "Data class that is the more abstract.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "subDataClasses";
        String end2AttributeDescription = "Data classes that are more concrete.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_CLASS.typeName), "subDataClasses", "Data classes that are more concrete.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDataClassCompositionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DATA_CLASS_COMPOSITION, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "partOfDataClasses";
        String end1AttributeDescription = "Data classes that includes other data classes in its definition.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_CLASS.typeName), "partOfDataClasses", "Data classes that includes other data classes in its definition.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "madeOfDataClasses";
        String end2AttributeDescription = "Data classes that provide part of another data class's definitions.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_CLASS.typeName), "madeOfDataClasses", "Data classes that provide part of another data class's definitions.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDataClassAssignmentRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DATA_CLASS_ASSIGNMENT, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "elementsAssignedToDataClass";
        String end1AttributeDescription = "Elements identified as managing data values that match the specification of a data class.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "elementsAssignedToDataClass", "Elements identified as managing data values that match the specification of a data class.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "dataClassesAssignedToElement";
        String end2AttributeDescription = "Logical data type for this element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_CLASS.typeName), "dataClassesAssignedToElement", "Logical data type for this element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.METHOD));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.DATA_CLASS_ASSIGNMENT_STATUS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.THRESHOLD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_PROPERTY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0545ReferenceData() {
        this.archiveBuilder.addClassificationDef(this.getReferenceDataClassification());
        this.archiveBuilder.addEntityDef(this.getValidValueDefinitionEntity());
        this.archiveBuilder.addEntityDef(this.getValidValuesSetEntity());
        this.archiveBuilder.addRelationshipDef(this.getValidValuesAssignmentRelationship());
        this.archiveBuilder.addRelationshipDef(this.getValidValuesMemberRelationship());
        this.archiveBuilder.addRelationshipDef(this.getValidValuesImplementationRelationship());
    }

    private ClassificationDef getReferenceDataClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.REFERENCE_DATA_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), false);
    }

    private EntityDef getValidValueDefinitionEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.VALID_VALUE_DEFINITION, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USAGE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCOPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PREFERRED_VALUE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getValidValuesSetEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.VALID_VALUE_SET, this.archiveBuilder.getEntityDef(OpenMetadataType.VALID_VALUE_DEFINITION.typeName));
    }

    private RelationshipDef getValidValuesAssignmentRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "validValuesConsumer";
        String end1AttributeDescription = "The valid values set that this element belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "validValuesConsumer", "The valid values set that this element belongs to.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "validValues";
        String end2AttributeDescription = "A definition of the valid values for this element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.VALID_VALUE_DEFINITION.typeName), "validValues", "A definition of the valid values for this element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STRICT_REQUIREMENT));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getValidValuesMemberRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "validValuesSet";
        String end1AttributeDescription = "The valid values set that this element belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.VALID_VALUE_SET.typeName), "validValuesSet", "The valid values set that this element belongs to.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "memberOfValidValuesSet";
        String end2AttributeDescription = "Description of a single valid value.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.VALID_VALUE_DEFINITION.typeName), "memberOfValidValuesSet", "Description of a single valid value.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getValidValuesImplementationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "validValues";
        String end1AttributeDescription = "The valid values set that this element implements.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.VALID_VALUE_DEFINITION.typeName), "validValues", "The valid values set that this element implements.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "validValuesImplementation";
        String end2AttributeDescription = "The asset where the valid values are implemented.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "validValuesImplementation", "The asset where the valid values are implemented.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IMPLEMENTATION_VALUE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0565DesignModelElements() {
        this.archiveBuilder.addEntityDef(this.getDesignModelElementEntity());
    }

    private EntityDef getDesignModelElementEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DESIGN_MODEL_ELEMENT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TECHNICAL_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VERSION_NUMBER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AUTHOR));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0566DesignModelOrganization() {
        this.archiveBuilder.addEntityDef(this.getDesignModelEntity());
        this.archiveBuilder.addEntityDef(this.getDesignModelGroupEntity());
        this.archiveBuilder.addRelationshipDef(this.getDesignModelGroupMembershipRelationship());
    }

    private EntityDef getDesignModelEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DESIGN_MODEL, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TECHNICAL_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VERSION_NUMBER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AUTHOR));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDesignModelGroupEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DESIGN_MODEL_GROUP, this.archiveBuilder.getEntityDef(OpenMetadataType.DESIGN_MODEL_ELEMENT.typeName));
    }

    private RelationshipDef getDesignModelGroupMembershipRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DESIGN_MODEL_GROUP_MEMBERSHIP_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "memberOfModelGroups";
        String end1AttributeDescription = "Link to a list of groups this element is a member of.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DESIGN_MODEL_GROUP.typeName), "memberOfModelGroups", "Link to a list of groups this element is a member of.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "elementsInGroup";
        String end2AttributeDescription = "List of elements that belong to this group.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DESIGN_MODEL_ELEMENT.typeName), "elementsInGroup", "List of elements that belong to this group.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0568DesignModelScoping() {
        this.archiveBuilder.addEntityDef(this.getDesignModelScopeEntity());
        this.archiveBuilder.addRelationshipDef(this.getDesignModelElementsInScopeRelationship());
    }

    private EntityDef getDesignModelScopeEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DESIGN_MODEL_SCOPE, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TECHNICAL_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VERSION_NUMBER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AUTHOR));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getDesignModelElementsInScopeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DESIGN_MODEL_ELEMENTS_IN_SCOPE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "usedInScope";
        String end1AttributeDescription = "Link to a scope where this element is used.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DESIGN_MODEL_SCOPE.typeName), "usedInScope", "Link to a scope where this element is used.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        String end2AttributeName = "inScopeModelElements";
        String end2AttributeDescription = "List of elements that belong to this scope.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DESIGN_MODEL_ELEMENT.typeName), "inScopeModelElements", "List of elements that belong to this scope.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        return relationshipDef;
    }

    private void add0569DesignModelImplementation() {
        this.archiveBuilder.addRelationshipDef(this.geDesignModelImplementationRelationship());
    }

    private RelationshipDef geDesignModelImplementationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DESIGN_MODEL_IMPLEMENTATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "implementationFollowingModel";
        String end1AttributeDescription = "Definition of an implementation of the model.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "implementationFollowingModel", "Definition of an implementation of the model.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "modelDescribingBehavior";
        String end2AttributeDescription = "Descriptive abstraction.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DESIGN_MODEL_ELEMENT.typeName), "modelDescribingBehavior", "Descriptive abstraction.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0570MetaModel() {
        this.archiveBuilder.addClassificationDef(this.getMetamodelClassification());
    }

    private ClassificationDef getMetamodelClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.METAMODEL_INSTANCE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.DESIGN_MODEL_ELEMENT.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.METAMODEL_ELEMENT_GUID));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0571ConceptModels() {
        this.archiveBuilder.addEnumDef(this.getConceptModelAttributeCoverageCategoryEnum());
        this.archiveBuilder.addEnumDef(this.getConceptModelDecorationEnum());
        this.archiveBuilder.addEntityDef(this.getConceptModelElementEntity());
        this.archiveBuilder.addEntityDef(this.getConceptBeadEntity());
        this.archiveBuilder.addEntityDef(this.getConceptBeadLinkEntity());
        this.archiveBuilder.addEntityDef(this.getConceptBeadAttributeEntity());
        this.archiveBuilder.addRelationshipDef(this.getConceptBeadRelationshipEndRelationship());
        this.archiveBuilder.addRelationshipDef(this.getConceptBeadAttributeLinkRelationship());
        this.archiveBuilder.addClassificationDef(this.getConceptBeadAttributeCoverageClassification());
    }

    private EnumDef getConceptModelAttributeCoverageCategoryEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ConceptModelAttributeCoverageCategory.getOpenTypeGUID(), ConceptModelAttributeCoverageCategory.getOpenTypeName(), ConceptModelAttributeCoverageCategory.getOpenTypeDescription(), ConceptModelAttributeCoverageCategory.getOpenTypeDescriptionGUID(), ConceptModelAttributeCoverageCategory.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ConceptModelAttributeCoverageCategory enumValue : ConceptModelAttributeCoverageCategory.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getConceptModelDecorationEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ConceptModelDecoration.getOpenTypeGUID(), ConceptModelDecoration.getOpenTypeName(), ConceptModelDecoration.getOpenTypeDescription(), ConceptModelDecoration.getOpenTypeDescriptionGUID());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ConceptModelDecoration enumValue : ConceptModelDecoration.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getConceptModelElementEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CONCEPT_MODEL_ELEMENT, this.archiveBuilder.getEntityDef(OpenMetadataType.DESIGN_MODEL_ELEMENT.typeName));
    }

    private EntityDef getConceptBeadEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CONCEPT_BEAD, this.archiveBuilder.getEntityDef(OpenMetadataType.CONCEPT_MODEL_ELEMENT.typeName));
    }

    private EntityDef getConceptBeadLinkEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CONCEPT_BEAD_LINK, this.archiveBuilder.getEntityDef(OpenMetadataType.CONCEPT_MODEL_ELEMENT.typeName));
    }

    private EntityDef getConceptBeadAttributeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CONCEPT_BEAD_ATTRIBUTE, this.archiveBuilder.getEntityDef(OpenMetadataType.CONCEPT_MODEL_ELEMENT.typeName));
    }

    private RelationshipDef getConceptBeadRelationshipEndRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONCEPT_BEAD_RELATIONSHIP_END, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "relationships";
        String end1AttributeDescription = "The relationships that the concept bead can be a part of.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONCEPT_BEAD_LINK.typeName), "relationships", "The relationships that the concept bead can be a part of.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "endBeads";
        String end2AttributeDescription = "The concept beads that are linked via this relationship.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONCEPT_BEAD.typeName), "endBeads", "The concept beads that are linked via this relationship.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ATTRIBUTE_NAME));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.DECORATION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.POSITION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MIN_CARDINALITY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MAX_CARDINALITY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.UNIQUE_VALUES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ORDERED_VALUES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAVIGABLE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getConceptBeadAttributeLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONCEPT_BEAN_ATTRIBUTE_LINK, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "parentBead";
        String end1AttributeDescription = "Concept bead that this attribute belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONCEPT_BEAD.typeName), "parentBead", "Concept bead that this attribute belongs to.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "attributes";
        String end2AttributeDescription = "Attribute detail for the concept bead.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONCEPT_BEAD_ATTRIBUTE.typeName), "attributes", "Attribute detail for the concept bead.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.POSITION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MIN_CARDINALITY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MAX_CARDINALITY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.UNIQUE_VALUES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ORDERED_VALUES));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getConceptBeadAttributeCoverageClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CONCEPT_BEAD_ATTRIBUTE_COVERAGE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.CONCEPT_BEAD_ATTRIBUTE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.COVERAGE_CATEGORY));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0595DesignPatterns() {
        this.archiveBuilder.addEntityDef(this.getDesignPatternEntity());
        this.archiveBuilder.addRelationshipDef(this.getRelatedPatternRelationship());
    }

    private EntityDef getDesignPatternEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DESIGN_PATTERN, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONTEXT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORCES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROBLEM_STATEMENT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROBLEM_EXAMPLE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOLUTION_DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOLUTION_EXAMPLE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.BENEFITS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LIABILITIES));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getRelatedPatternRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.RELATED_DESIGN_PATTERN_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "relatedDesignPattern";
        String end1AttributeDescription = "Another design pattern that operates in similar contexts.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DESIGN_PATTERN.typeName), "relatedDesignPattern", "Another design pattern that operates in similar contexts.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "relatedDesignPattern";
        String end2AttributeDescription = "Another design pattern that operates in similar contexts.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DESIGN_PATTERN.typeName), "relatedDesignPattern", "Another design pattern that operates in similar contexts.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0598LineageRelationships() {
        this.archiveBuilder.addRelationshipDef(this.getPortSchemaRelationship());
        this.archiveBuilder.addRelationshipDef(this.getLineageMappingRelationship());
    }

    private RelationshipDef getPortSchemaRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PORT_SCHEMA_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "port";
        String end1AttributeDescription = "Port";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PORT.typeName), "port", "Port", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "schemaType";
        String end2AttributeDescription = "Schema Type";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName), "schemaType", "Schema Type", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getLineageMappingRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.LINEAGE_MAPPING_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "sourceElement";
        String end1AttributeDescription = "Source Attribute.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName), "sourceElement", "Source Attribute.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "targetElement";
        String end2AttributeDescription = "Target Attribute.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName), "targetElement", "Target Attribute.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void addArea6Types() {
        this.add0610Annotations();
        this.add0612AnnotationReviews();
        this.add0615SchemaExtraction();
        this.add0617DataFieldAnalysis();
        this.add0620DataProfiling();
        this.add0625DataClassDiscovery();
        this.add0630SemanticDiscovery();
        this.add0635ClassificationDiscovery();
        this.add0640QualityScores();
        this.add0650RelationshipDiscovery();
        this.add0660ResourceMeasures();
        this.add0690RequestForAction();
    }

    private void add0610Annotations() {
        this.archiveBuilder.addEntityDef(this.getAnnotationEntity());
        this.archiveBuilder.addRelationshipDef(this.getAnnotationExtensionRelationship());
    }

    private EntityDef getAnnotationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ANNOTATION, null);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ANNOTATION_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SUMMARY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE_LEVEL));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPLANATION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ANALYSIS_STEP));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.JSON_PROPERTIES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getAnnotationExtensionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "extendedAnnotations";
        String end1AttributeDescription = "The annotations being extended.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ANNOTATION.typeName), "extendedAnnotations", "The annotations being extended.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "annotationExtensions";
        String end2AttributeDescription = "The annotations providing additional information.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ANNOTATION.typeName), "annotationExtensions", "The annotations providing additional information.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0612AnnotationReviews() {
        this.archiveBuilder.addEnumDef(this.getAnnotationStatusEnum());
        this.archiveBuilder.addEntityDef(this.getAnnotationReviewEntity());
        this.archiveBuilder.addRelationshipDef(this.getAnnotationReviewLinkRelationship());
    }

    private EnumDef getAnnotationStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(AnnotationStatus.getOpenTypeGUID(), AnnotationStatus.getOpenTypeName(), AnnotationStatus.getOpenTypeDescription(), AnnotationStatus.getOpenTypeDescriptionGUID(), AnnotationStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (AnnotationStatus annotationStatus : AnnotationStatus.values()) {
            elementDefs.add(this.archiveHelper.getEnumElementDef(annotationStatus.getOrdinal(), annotationStatus.getName(), annotationStatus.getDescription(), annotationStatus.getDescriptionGUID()));
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getAnnotationReviewEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ANNOTATION_REVIEW, null);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REVIEW_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COMMENT));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getAnnotationReviewLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "reviewedAnnotations";
        String end1AttributeDescription = "The annotations being reviewed.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ANNOTATION.typeName), "reviewedAnnotations", "The annotations being reviewed.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "annotationReviews";
        String end2AttributeDescription = "The feedback about the annotations.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ANNOTATION_REVIEW.typeName), "annotationReviews", "The feedback about the annotations.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.ANNOTATION_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0615SchemaExtraction() {
        this.archiveBuilder.addEntityDef(this.getSchemaAnalysisAnnotationEntity());
        this.archiveBuilder.addRelationshipDef(this.getDiscoveredSchemaTypeRelationship());
    }

    private EntityDef getSchemaAnalysisAnnotationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.ANNOTATION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCHEMA_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCHEMA_TYPE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getDiscoveredSchemaTypeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DISCOVERED_SCHEMA_TYPE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "discoveringAnnotation";
        String end1AttributeDescription = "The analyser of the schema type.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.typeName), "discoveringAnnotation", "The analyser of the schema type.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "discoveredSchema";
        String end2AttributeDescription = "Discovered schema structure.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName), "discoveredSchema", "Discovered schema structure.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0617DataFieldAnalysis() {
        this.archiveBuilder.addEntityDef(this.getDataFieldAnnotationEntity());
    }

    private EntityDef getDataFieldAnnotationEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_FIELD_ANNOTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.ANNOTATION.typeName));
    }

    private void add0620DataProfiling() {
        this.archiveBuilder.addEntityDef(this.getDataProfileAnnotationEntity());
        this.archiveBuilder.addEntityDef(this.getResourceProfileLogAnnotationEntity());
        this.archiveBuilder.addRelationshipDef(this.getResourceProfileLogFileRelationship());
    }

    private EntityDef getDataProfileAnnotationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RESOURCE_PROFILE_ANNOTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FIELD_ANNOTATION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LENGTH));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INFERRED_DATA_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INFERRED_FORMAT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INFERRED_LENGTH));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INFERRED_PRECISION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INFERRED_SCALE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROFILE_PROPERTIES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROFILE_FLAGS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROFILE_COUNTS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VALUE_LIST));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VALUE_COUNT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VALUE_RANGE_FROM));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VALUE_RANGE_TO));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AVERAGE_VALUE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROFILE_DOUBLES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROFILE_START_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROFILE_END_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROFILE_DATES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROFILE_PROPERTY_NAMES));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getResourceProfileLogAnnotationEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RESOURCE_PROFILE_LOG_ANNOTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FIELD_ANNOTATION.typeName));
    }

    private RelationshipDef getResourceProfileLogFileRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.RESOURCE_PROFILE_DATA_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "resourceProfileAnnotations";
        String end1AttributeDescription = "The annotations that refer to this log file.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.RESOURCE_PROFILE_LOG_ANNOTATION.typeName), "resourceProfileAnnotations", "The annotations that refer to this log file.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "resourceProfileLogs";
        String end2AttributeDescription = "Location of the profile information.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "resourceProfileLogs", "Location of the profile information.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0625DataClassDiscovery() {
        this.archiveBuilder.addEntityDef(this.getDataClassAnnotationEntity());
    }

    private EntityDef getDataClassAnnotationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_CLASS_ANNOTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FIELD_ANNOTATION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CANDIDATE_DATA_CLASS_GUIDS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MATCHING_VALUES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NON_MATCHING_VALUES));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0630SemanticDiscovery() {
        this.archiveBuilder.addEntityDef(this.getSemanticAnnotationEntity());
    }

    private EntityDef getSemanticAnnotationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SEMANTIC_ANNOTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FIELD_ANNOTATION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INFORMAL_TERM));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CANDIDATE_GLOSSARY_TERM_GUIDS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INFORMAL_CATEGORY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CANDIDATE_GLOSSARY_CATEGORY_GUIDS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0635ClassificationDiscovery() {
        this.archiveBuilder.addEntityDef(this.getClassificationAnnotationEntity());
    }

    private EntityDef getClassificationAnnotationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CLASSIFICATION_ANNOTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FIELD_ANNOTATION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CANDIDATE_CLASSIFICATIONS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0640QualityScores() {
        this.archiveBuilder.addEntityDef(this.getQualityAnnotationEntity());
    }

    private EntityDef getQualityAnnotationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.QUALITY_ANNOTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FIELD_ANNOTATION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUALITY_DIMENSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUALITY_SCORE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0650RelationshipDiscovery() {
        this.archiveBuilder.addEntityDef(this.getRelationshipAdviceAnnotationEntity());
        this.archiveBuilder.addRelationshipDef(this.getRelationshipAnnotationRelationship());
    }

    private EntityDef getRelationshipAdviceAnnotationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RELATIONSHIP_ADVICE_ANNOTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FIELD_ANNOTATION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RELATIONSHIP_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RELATIONSHIP_PROPERTIES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RELATED_ENTITY_GUID));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getRelationshipAnnotationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.RELATIONSHIP_ANNOTATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "relatedFromObjectAnnotations";
        String end1AttributeDescription = "The referenceables linked from.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "relatedFromObjectAnnotations", "The referenceables linked from.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "relatedToObjectAnnotations";
        String end2AttributeDescription = "The referenceables linked to.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "relatedToObjectAnnotations", "The referenceables linked to.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ANNOTATION_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SUMMARY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE_LEVEL));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPLANATION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ANALYSIS_STEP));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.JSON_PROPERTIES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.ANNOTATION_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0660ResourceMeasures() {
        this.archiveBuilder.addEntityDef(this.getResourceMeasureAnnotationEntity());
        this.archiveBuilder.addEntityDef(this.getDataSourcePhysicalStatusAnnotationEntity());
    }

    private EntityDef getResourceMeasureAnnotationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RESOURCE_MEASURE_ANNOTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.ANNOTATION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RESOURCE_PROPERTIES));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDataSourcePhysicalStatusAnnotationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RESOURCE_PHYSICAL_STATUS_ANNOTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RESOURCE_CREATE_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RESOURCE_UPDATE_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SIZE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENCODING));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0690RequestForAction() {
        this.archiveBuilder.addEntityDef(this.getRequestForActionAnnotationEntity());
    }

    private EntityDef getRequestForActionAnnotationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FIELD_ANNOTATION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTION_SOURCE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTION_REQUESTED));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTION_PROPERTIES));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }
}

