/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SolutionPortDirection;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive1_6;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive1_7 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "1.7";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1516313040008L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive1_7() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive1_7(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive1_6 previousTypes = new OpenMetadataTypesArchive1_6(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0424GovernanceZones();
        this.update042SubjectAreas();
        this.add0435PolicyManagementCapabilities();
        this.update0438NamingStandards();
        this.update0440OrganizationalControls();
        this.update05454ReferenceData();
        this.addArea7Lineage();
    }

    private void update0424GovernanceZones() {
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceZoneEntity());
    }

    private TypeDefPatch updateGovernanceZoneEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.GOVERNANCE_ZONE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCOPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update042SubjectAreas() {
        this.archiveBuilder.addEntityDef(this.addSubjectAreaDefinitionEntity());
        this.archiveBuilder.addRelationshipDef(this.getSubjectAreaHierarchyRelationship());
    }

    private EntityDef addSubjectAreaDefinitionEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SUBJECT_AREA_DEFINITION, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USAGE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCOPE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getSubjectAreaHierarchyRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "broaderSubjectArea";
        String end1AttributeDescription = "The subject area that describes a broader topic.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName), "broaderSubjectArea", "The subject area that describes a broader topic.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "nestedSubjectArea";
        String end2AttributeDescription = "The subdivisions of the broader topic.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName), "nestedSubjectArea", "The subdivisions of the broader topic.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0435PolicyManagementCapabilities() {
        this.archiveBuilder.addClassificationDef(this.getPolicyAdministrationPointClassification());
        this.archiveBuilder.addClassificationDef(this.getPolicyDecisionPointClassification());
        this.archiveBuilder.addClassificationDef(this.getPolicyEnforcementPointClassification());
        this.archiveBuilder.addClassificationDef(this.getPolicyInformationPointClassification());
        this.archiveBuilder.addClassificationDef(this.getPolicyRetrievalPointClassification());
    }

    private ClassificationDef getPolicyAdministrationPointClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.POLICY_ADMINISTRATION_POINT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getPolicyDecisionPointClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.POLICY_DECISION_POINT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getPolicyEnforcementPointClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.POLICY_ENFORCEMENT_POINT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getPolicyInformationPointClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.POLICY_INFORMATION_POINT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getPolicyRetrievalPointClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.POLICY_RETRIEVAL_POINT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0438NamingStandards() {
        this.archiveBuilder.addClassificationDef(this.getModifierClassification());
        this.archiveBuilder.addTypeDefPatch(this.updatePrimeWordClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateClassWordClassification());
    }

    private ClassificationDef getModifierClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.MODIFIER_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
    }

    private TypeDefPatch updatePrimeWordClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PRIME_WORD_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.REFERENCEABLE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateClassWordClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CLASS_WORD_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.REFERENCEABLE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private void update0440OrganizationalControls() {
        this.archiveBuilder.addTypeDefPatch(this.updateOrganizationalCapabilityRelationship());
    }

    private TypeDefPatch updateOrganizationalCapabilityRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ORGANIZATIONAL_CAPABILITY_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCOPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update05454ReferenceData() {
        this.archiveBuilder.addRelationshipDef(this.getValidValuesMappingRelationship());
        this.archiveBuilder.addRelationshipDef(this.getReferenceValueAssignmentRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateValidValuesImplementationRelationship());
    }

    private RelationshipDef getValidValuesMappingRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.VALID_VALUES_MAPPING_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "matchingValue";
        String end1AttributeDescription = "A valid value from a different valid value set that is equivalent.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.VALID_VALUE_DEFINITION.typeName), "matchingValue", "A valid value from a different valid value set that is equivalent.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "matchingValue";
        String end2AttributeDescription = "A valid value from a different valid value set that is equivalent.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.VALID_VALUE_DEFINITION.typeName), "matchingValue", "A valid value from a different valid value set that is equivalent.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ASSOCIATION_DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getReferenceValueAssignmentRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "assignedItem";
        String end1AttributeDescription = "An element that has been tagged by a valid value.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "assignedItem", "An element that has been tagged by a valid value.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "referenceValue";
        String end2AttributeDescription = "A valid value that represents the meaning or classification of the assigned item.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.VALID_VALUE_DEFINITION.typeName), "referenceValue", "A valid value that represents the meaning or classification of the assigned item.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private TypeDefPatch updateValidValuesImplementationRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SYMBOLIC_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_VALUES));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void addArea7Lineage() {
        this.add0710DigitalServices();
        this.add0715DigitalServiceOwnership();
        this.add0720InformationSupplyChains();
        this.add0730SolutionComponents();
        this.add0735SolutionPortsAndWires();
        this.add0740SolutionBlueprints();
        this.add0750DataPassing();
        this.add0760BusinessLineage();
    }

    private void add0710DigitalServices() {
        this.archiveBuilder.addEntityDef(this.getDigitalServiceEntity());
        this.archiveBuilder.addRelationshipDef(this.getDigitalServiceDependencyRelationship());
    }

    private EntityDef getDigitalServiceEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DIGITAL_SERVICE, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VERSION_IDENTIFIER));
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.APPROVED_CONCEPT);
        validInstanceStatusList.add(InstanceStatus.UNDER_DEVELOPMENT);
        validInstanceStatusList.add(InstanceStatus.DEVELOPMENT_COMPLETE);
        validInstanceStatusList.add(InstanceStatus.APPROVED_FOR_DEPLOYMENT);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DISABLED);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private RelationshipDef getDigitalServiceDependencyRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DIGITAL_SERVICE_DEPENDENCY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "callsDigitalServices";
        String end1AttributeDescription = "The digital services dependent on the others.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DIGITAL_SERVICE.typeName), "callsDigitalServices", "The digital services dependent on the others.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "calledByDigitalServices";
        String end2AttributeDescription = "The digital services that the others depends on.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DIGITAL_SERVICE.typeName), "calledByDigitalServices", "The digital services that the others depends on.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DELEGATION_ESCALATION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0715DigitalServiceOwnership() {
        this.archiveBuilder.addEntityDef(this.getDigitalServiceManagerEntity());
        this.archiveBuilder.addRelationshipDef(this.getDigitalServiceManagementRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDigitalSupportRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDigitalServiceOperatorRelationship());
    }

    private EntityDef getDigitalServiceManagerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DIGITAL_SERVICE_MANAGER, this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName));
    }

    private RelationshipDef getDigitalServiceManagementRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DIGITAL_SERVICE_MANAGEMENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "managesDigitalServices";
        String end1AttributeDescription = "The digital services that this individual manages.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DIGITAL_SERVICE.typeName), "managesDigitalServices", "The digital services that this individual manages.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "digitalServiceManager";
        String end2AttributeDescription = "The individual responsible for the digital services.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DIGITAL_SERVICE_MANAGER.typeName), "digitalServiceManager", "The individual responsible for the digital services.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDigitalSupportRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DIGITAL_SUPPORT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "usesDigitalServices";
        String end1AttributeDescription = "The digital services that this business capability depends on.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DIGITAL_SERVICE.typeName), "usesDigitalServices", "The digital services that this business capability depends on.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "consumingBusinessCapabilities";
        String end2AttributeDescription = "The business capabilities that depend on the digital services.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.BUSINESS_CAPABILITY.typeName), "consumingBusinessCapabilities", "The business capabilities that depend on the digital services.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDigitalServiceOperatorRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DIGITAL_SERVICE_OPERATOR_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "operatesDigitalServices";
        String end1AttributeDescription = "The digital services that this organization operates.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DIGITAL_SERVICE.typeName), "operatesDigitalServices", "The digital services that this organization operates.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "digitalServiceOperators";
        String end2AttributeDescription = "The organizations that support the digital service's operations.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ORGANIZATION.typeName), "digitalServiceOperators", "The organizations that support the digital service's operations.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCOPE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0720InformationSupplyChains() {
        this.archiveBuilder.addEntityDef(this.getInformationSupplyChainEntity());
        this.archiveBuilder.addEntityDef(this.getInformationSupplyChainSegmentEntity());
        this.archiveBuilder.addRelationshipDef(this.getInformationSupplyChainCompositionRelationship());
    }

    private EntityDef getInformationSupplyChainEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.INFORMATION_SUPPLY_CHAIN, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCOPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PURPOSES));
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DISABLED);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private EntityDef getInformationSupplyChainSegmentEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.INFORMATION_SUPPLY_CHAIN_SEGMENT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCOPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INTEGRATION_STYLE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ESTIMATED_VOLUMETRICS));
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DISABLED);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private RelationshipDef getInformationSupplyChainCompositionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.INFORMATION_SUPPLY_CHAIN_COMPOSITION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "informationSupplyChains";
        String end1AttributeDescription = "Owning information supply chain.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.INFORMATION_SUPPLY_CHAIN.typeName), "informationSupplyChains", "Owning information supply chain.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "segments";
        String end2AttributeDescription = "A role performed by this person.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.INFORMATION_SUPPLY_CHAIN_SEGMENT.typeName), "segments", "A role performed by this person.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0730SolutionComponents() {
        this.archiveBuilder.addEntityDef(this.getSolutionComponentEntity());
        this.archiveBuilder.addRelationshipDef(this.getSolutionCompositionRelationship());
    }

    private EntityDef getSolutionComponentEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SOLUTION_COMPONENT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VERSION_IDENTIFIER));
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DISABLED);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private RelationshipDef getSolutionCompositionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SOLUTION_COMPOSITION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "usedInSolutionComponents";
        String end1AttributeDescription = "The solution components that embed this component.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOLUTION_COMPONENT.typeName), "usedInSolutionComponents", "The solution components that embed this component.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "nestedSolutionComponents";
        String end2AttributeDescription = "The sub-parts of this solution component.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOLUTION_COMPONENT.typeName), "nestedSolutionComponents", "The sub-parts of this solution component.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0735SolutionPortsAndWires() {
        this.archiveBuilder.addEnumDef(this.getSolutionPortDirectionEnum());
        this.archiveBuilder.addEntityDef(this.getSolutionPortEntity());
        this.archiveBuilder.addRelationshipDef(this.getSolutionLinkingWireRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSolutionComponentPortRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSolutionPortDelegationRelationship());
    }

    private EnumDef getSolutionPortDirectionEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(SolutionPortDirection.getOpenTypeGUID(), SolutionPortDirection.getOpenTypeName(), SolutionPortDirection.getOpenTypeDescription(), SolutionPortDirection.getOpenTypeDescriptionGUID(), SolutionPortDirection.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (SolutionPortDirection enumValue : SolutionPortDirection.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getSolutionPortEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SOLUTION_PORT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VERSION_IDENTIFIER));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.DIRECTION));
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DISABLED);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private RelationshipDef getSolutionLinkingWireRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SOLUTION_LINKING_WIRE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "connectedPorts";
        String end1AttributeDescription = "Port that the wire connects to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOLUTION_PORT.typeName), "connectedPorts", "Port that the wire connects to.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "connectedPorts";
        String end2AttributeDescription = "Port that the wire connects to.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOLUTION_PORT.typeName), "connectedPorts", "Port that the wire connects to.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INFORMATION_SUPPLY_CHAIN_SEGMENTS_GUIDS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getSolutionComponentPortRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SOLUTION_COMPONENT_PORT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "solutionComponent";
        String end1AttributeDescription = "Owning solution component that this port belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOLUTION_COMPONENT.typeName), "solutionComponent", "Owning solution component that this port belongs to.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "solutionPorts";
        String end2AttributeDescription = "List ports for this solution component.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOLUTION_PORT.typeName), "solutionPorts", "List ports for this solution component.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getSolutionPortDelegationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SOLUTION_PORT_DELEGATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "alignsToPort";
        String end1AttributeDescription = "Encapsulating solution component's port";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOLUTION_PORT.typeName), "alignsToPort", "Encapsulating solution component's port", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "delegationPorts";
        String end2AttributeDescription = "Ports from nested components that align with the port from the encapsulating solution component.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOLUTION_PORT.typeName), "delegationPorts", "Ports from nested components that align with the port from the encapsulating solution component.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0740SolutionBlueprints() {
        this.archiveBuilder.addEntityDef(this.getSolutionBlueprintEntity());
        this.archiveBuilder.addRelationshipDef(this.getSolutionBlueprintCompositionRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDigitalServiceDesignRelationship());
    }

    private EntityDef getSolutionBlueprintEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SOLUTION_BLUEPRINT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VERSION_IDENTIFIER));
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DISABLED);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private RelationshipDef getSolutionBlueprintCompositionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SOLUTION_BLUEPRINT_COMPOSITION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "usedInSolutionBlueprints";
        String end1AttributeDescription = "The solutions where this component features.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOLUTION_BLUEPRINT.typeName), "usedInSolutionBlueprints", "The solutions where this component features.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "containsSolutionComponents";
        String end2AttributeDescription = "List of solution components that make up the solution.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOLUTION_COMPONENT.typeName), "containsSolutionComponents", "List of solution components that make up the solution.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ROLE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getDigitalServiceDesignRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DIGITAL_SERVICE_DESIGN_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "describesDigitalService";
        String end1AttributeDescription = "Digital service described by the blueprint.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DIGITAL_SERVICE.typeName), "describesDigitalService", "Digital service described by the blueprint.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "digitalServiceDesigns";
        String end2AttributeDescription = "The difference versions of the digital service's designs.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOLUTION_BLUEPRINT.typeName), "digitalServiceDesigns", "The difference versions of the digital service's designs.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0750DataPassing() {
        this.archiveBuilder.addRelationshipDef(this.getProcessCallRelationship());
    }

    private RelationshipDef getProcessCallRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PROCESS_CALL_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "calls";
        String end1AttributeDescription = "Caller asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "calls", "Caller asset.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "calledBy";
        String end2AttributeDescription = "Called asset.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "calledBy", "Called asset.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0760BusinessLineage() {
        this.archiveBuilder.addClassificationDef(this.getBusinessSignificantClassification());
    }

    private ClassificationDef getBusinessSignificantClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.BUSINESS_SIGNIFICANT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCOPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.BUSINESS_CAPABILITY));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }
}

