/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive1_7;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_0 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.0";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_0() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_0(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive1_7 previousTypes = new OpenMetadataTypesArchive1_7(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.add0011ManagingReferenceables();
        this.update0220FilesAndFolders();
        this.update0221DocumentStores();
        this.update0224Databases();
    }

    private void add0011ManagingReferenceables() {
        this.archiveBuilder.addClassificationDef(this.addTemplateClassification());
    }

    private ClassificationDef addTemplateClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.TEMPLATE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0220FilesAndFolders() {
        this.archiveBuilder.addClassificationDef(this.getFileManagerClassification());
    }

    private ClassificationDef getFileManagerClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.FILE_MANAGER_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName), false);
    }

    private void update0221DocumentStores() {
        this.archiveBuilder.addClassificationDef(this.getContentCollectionManagerClassification());
    }

    private ClassificationDef getContentCollectionManagerClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.CONTENT_COLLECTION_MANAGER, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName), false);
    }

    private void update0224Databases() {
        this.archiveBuilder.addEntityDef(this.addDatabaseManagerEntity());
    }

    private EntityDef addDatabaseManagerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATABASE_MANAGER, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
    }

    private void add0217AutomatedProcesses() {
    }

    private void add0260Transformations() {
    }

    private void add0265AnalyticsAssets() {
    }

    private void add0270IoTAssets() {
    }

    private void add0280ModelAssets() {
    }

    private void add0435GovernanceRules() {
    }

    private void add0447GovernanceProcesses() {
    }

    private void add0452GovernanceDaemons() {
    }

    private void add0480RightsManagement() {
    }

    private void add0550LogicSpecificationModel() {
    }

    private void add0560MappingModel() {
    }
}

