/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_10;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_11 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.11";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_11() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_11(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_10 previousTypes = new OpenMetadataTypesArchive2_10(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0050ApplicationsAndProcesses();
        this.update04xxGovernanceDefinitions();
        this.update0530TabularSchema();
        this.update0534RelationalSchema();
        this.update0535EventSchemas();
        this.update0536APISchemas();
        this.update0537DisplaySchemas();
    }

    private void update0050ApplicationsAndProcesses() {
        this.archiveBuilder.addEntityDef(this.addAPIManagerEntity());
        this.archiveBuilder.addEntityDef(this.addEventBrokerEntity());
    }

    private EntityDef addAPIManagerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.API_MANAGER, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
    }

    private EntityDef addEventBrokerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EVENT_BROKER, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
    }

    private void update04xxGovernanceDefinitions() {
        this.archiveBuilder.addEntityDef(this.addThreatEntity());
        this.archiveBuilder.addRelationshipDef(this.addGovernanceDefinitionScopeRelationship());
    }

    private RelationshipDef addGovernanceDefinitionScopeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GOVERNANCE_DEFINITION_SCOPE, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "definitionAppliesTo";
        String end1AttributeDescription = "Elements defining the scope that the governance definition applies to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "definitionAppliesTo", "Elements defining the scope that the governance definition applies to.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        String end2AttributeName = "associatedGovernanceDefinitions";
        String end2AttributeDescription = "Governance definitions for this scope.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_DEFINITION.typeName), "associatedGovernanceDefinitions", "Governance definitions for this scope.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        return relationshipDef;
    }

    private EntityDef addThreatEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.THREAT, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_DRIVER.typeName));
    }

    private void update0530TabularSchema() {
        this.archiveBuilder.addEntityDef(this.addTabularFileColumnEntity());
    }

    private EntityDef addTabularFileColumnEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TABULAR_FILE_COLUMN, this.archiveBuilder.getEntityDef(OpenMetadataType.TABULAR_COLUMN.typeName));
    }

    private void update0534RelationalSchema() {
        this.archiveBuilder.addTypeDefPatch(this.updateRelationalTableTypeEntity());
    }

    private TypeDefPatch updateRelationalTableTypeEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.RELATIONAL_TABLE_TYPE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.COMPLEX_SCHEMA_TYPE.typeName));
        return typeDefPatch;
    }

    private void update0535EventSchemas() {
        this.archiveBuilder.addEntityDef(this.addEventTypeListEntity());
        this.archiveBuilder.addEntityDef(this.addEventSchemaAttributeEntity());
    }

    private EntityDef addEventTypeListEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EVENT_TYPE_LIST, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE_CHOICE.typeName));
    }

    private EntityDef addEventSchemaAttributeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EVENT_SCHEMA_ATTRIBUTE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName));
    }

    private void update0536APISchemas() {
        this.archiveBuilder.addEntityDef(this.addAPIParameterListEntity());
        this.archiveBuilder.addEntityDef(this.addAPIParameterEntity());
    }

    private EntityDef addAPIParameterListEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.API_PARAMETER_LIST, this.archiveBuilder.getEntityDef(OpenMetadataType.COMPLEX_SCHEMA_TYPE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REQUIRED));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addAPIParameterEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.API_PARAMETER, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PARAMETER_TYPE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void update0537DisplaySchemas() {
        this.archiveBuilder.addEntityDef(this.addDisplayDataSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.addDisplayDataContainerEntity());
        this.archiveBuilder.addEntityDef(this.addDisplayDataFieldEntity());
        this.archiveBuilder.addEntityDef(this.addQuerySchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.addQueryDataContainerEntity());
        this.archiveBuilder.addEntityDef(this.addQueryDataFieldEntity());
    }

    private EntityDef addDisplayDataSchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DISPLAY_DATA_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.COMPLEX_SCHEMA_TYPE.typeName));
    }

    private EntityDef addDisplayDataContainerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DISPLAY_DATA_CONTAINER, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName));
    }

    private EntityDef addDisplayDataFieldEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DISPLAY_DATA_FIELD, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INPUT_FIELD));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addQuerySchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.QUERY_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.COMPLEX_SCHEMA_TYPE.typeName));
    }

    private EntityDef addQueryDataContainerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.QUERY_DATA_CONTAINER, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName));
    }

    private EntityDef addQueryDataFieldEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.QUERY_DATA_FIELD, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName));
    }
}

