/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.enums.LatestChangeAction;
import org.odpi.openmetadata.frameworks.openmetadata.enums.LatestChangeTarget;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_0;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_4 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.4";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_4() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_4(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_0 previousTypes = new OpenMetadataTypesArchive2_0(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0011ManagingReferenceables();
        this.update0012SearchKeywords();
        this.update0030HostsAndPlatforms();
        this.add0057IntegrationCapabilities();
        this.update0150Feedback();
        this.update0215SoftwareComponents();
        this.update04xxGovernanceEnums();
        this.update05xxSchemaAttributes();
        this.update0545ReferenceData();
        this.updateClashingControlProperties();
    }

    private void update0011ManagingReferenceables() {
        this.archiveBuilder.addEnumDef(this.getLatestChangeTargetEnum());
        this.archiveBuilder.addEnumDef(this.getLatestChangeActionEnum());
        this.archiveBuilder.addClassificationDef(this.addAnchorsClassification());
        this.archiveBuilder.addClassificationDef(this.addLatestChangeClassification());
        this.archiveBuilder.addRelationshipDef(this.addSourcedFromRelationship());
    }

    private EnumDef getLatestChangeTargetEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(LatestChangeTarget.getOpenTypeGUID(), LatestChangeTarget.getOpenTypeName(), LatestChangeTarget.getOpenTypeDescription(), LatestChangeTarget.getOpenTypeDescriptionGUID(), LatestChangeTarget.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (LatestChangeTarget enumValue : LatestChangeTarget.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getLatestChangeActionEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(LatestChangeAction.getOpenTypeGUID(), LatestChangeAction.getOpenTypeName(), LatestChangeAction.getOpenTypeDescription(), LatestChangeAction.getOpenTypeDescriptionGUID(), LatestChangeAction.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (LatestChangeAction enumValue : LatestChangeAction.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private ClassificationDef addLatestChangeClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.LATEST_CHANGE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.CHANGE_TARGET));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.CHANGE_ACTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CLASSIFICATION_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ATTACHMENT_GUID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ATTACHMENT_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RELATIONSHIP_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTION_DESCRIPTION));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef addAnchorsClassification() {
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.ANNOTATION.typeName));
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.ANNOTATION_REVIEW.typeName));
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.LIKE.typeName));
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.RATING.typeName));
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.ANCHORS_CLASSIFICATION, null, linkedToEntities, true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ANCHOR_GUID));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private RelationshipDef addSourcedFromRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SOURCED_FROM_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "resultingElement";
        String end1AttributeDescription = "Element created from the template.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "resultingElement", "Element created from the template.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "templateElement";
        String end2AttributeDescription = "Template element providing information.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "templateElement", "Template element providing information.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0012SearchKeywords() {
        this.archiveBuilder.addEntityDef(this.getSearchKeywordEntity());
        this.archiveBuilder.addRelationshipDef(this.addSearchKeywordLinkRelationship());
    }

    private EntityDef getSearchKeywordEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SEARCH_KEYWORD, null);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.KEYWORD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addSearchKeywordLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "linkedElements";
        String end1AttributeDescription = "Element described by the search keyword.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "linkedElements", "Element described by the search keyword.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "searchKeywords";
        String end2AttributeDescription = "Keywords to describe the element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SEARCH_KEYWORD.typeName), "searchKeywords", "Keywords to describe the element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0030HostsAndPlatforms() {
        this.archiveBuilder.addTypeDefPatch(this.correctOperatingPlatformEntity());
    }

    private TypeDefPatch correctOperatingPlatformEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.OPERATING_PLATFORM.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.BYTE_ORDERING));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0057IntegrationCapabilities() {
        this.archiveBuilder.addEntityDef(this.addSoftwareServiceEntity());
        this.archiveBuilder.addEntityDef(this.addMetadataIntegrationServiceEntity());
        this.archiveBuilder.addEntityDef(this.addMetadataAccessServiceEntity());
        this.archiveBuilder.addEntityDef(this.addEngineHostingServiceEntity());
        this.archiveBuilder.addEntityDef(this.addUserViewServiceEntity());
    }

    private EntityDef addSoftwareServiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SOFTWARE_SERVICE, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
    }

    private EntityDef addMetadataIntegrationServiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.METADATA_INTEGRATION_SERVICE, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVICE.typeName));
    }

    private EntityDef addMetadataAccessServiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.METADATA_ACCESS_SERVICE, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVICE.typeName));
    }

    private EntityDef addEngineHostingServiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ENGINE_HOSTING_SERVICES, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVICE.typeName));
    }

    private EntityDef addUserViewServiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.USER_VIEW_SERVICE, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVICE.typeName));
    }

    private void update0150Feedback() {
        this.archiveBuilder.addTypeDefPatch(this.updateCommentEntity());
    }

    private TypeDefPatch updateCommentEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.COMMENT.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.COMMENT_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0215SoftwareComponents() {
        this.archiveBuilder.addEntityDef(this.addDeployedConnectorEntity());
    }

    private EntityDef addDeployedConnectorEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DEPLOYED_CONNECTOR, this.archiveBuilder.getEntityDef(OpenMetadataType.DEPLOYED_SOFTWARE_COMPONENT.typeName));
    }

    private void update04xxGovernanceEnums() {
        this.archiveBuilder.addRelationshipDef(this.getGovernedByRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateCriticalityClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateRetentionClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateConfidenceClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateConfidentialityClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceDefinitionEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceMetricEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceZoneEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateSubjectAreaDefinitionEntity());
    }

    private RelationshipDef getGovernedByRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GOVERNED_BY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "governedBy";
        String end1AttributeDescription = "The governance definition that defines how this element is governed.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_DEFINITION.typeName), "governedBy", "The governance definition that defines how this element is governed.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        String end2AttributeName = "governedElements";
        String end2AttributeDescription = "An element that is governed according to the governance definition.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "governedElements", "An element that is governed according to the governance definition.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch updateCriticalityClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CRITICALITY_LEVEL_IDENTIFIER));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateRetentionClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.RETENTION_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RETENTION_BASIS_IDENTIFIER));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateConfidenceClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE_LEVEL_IDENTIFIER));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateConfidentialityClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENTIALITY_LEVEL_IDENTIFIER));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceDefinitionEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.GOVERNANCE_DEFINITION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DOMAIN_IDENTIFIER));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateSubjectAreaDefinitionEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DOMAIN_IDENTIFIER));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceMetricEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.GOVERNANCE_METRIC.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DOMAIN_IDENTIFIER));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceZoneEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.GOVERNANCE_ZONE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DOMAIN_IDENTIFIER));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update05xxSchemaAttributes() {
        this.archiveBuilder.addTypeDefPatch(this.addPrecisionToSchemaAttributeEntity());
        this.archiveBuilder.addClassificationDef(this.getCalculatedValueClassification());
        this.archiveBuilder.addEntityDef(this.getExternalSchemaTypeEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateMapFromElementTypeRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateMapToElementTypeRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateSchemaTypeOptionRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDerivedSchemaTypeQueryTargetRelationship());
        this.archiveBuilder.addRelationshipDef(this.getLinkedExternalSchemaTypeRelationship());
    }

    private TypeDefPatch addPrecisionToSchemaAttributeEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PRECISION));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private ClassificationDef getCalculatedValueClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMULA));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private EntityDef getExternalSchemaTypeEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EXTERNAL_SCHEMA_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName));
    }

    private RelationshipDef getLinkedExternalSchemaTypeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.LINKED_EXTERNAL_SCHEMA_TYPE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "usedInSchema";
        String end1AttributeDescription = "Connection point for a reusable schema type.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ELEMENT.typeName), "usedInSchema", "Connection point for a reusable schema type.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "externalSchemaType";
        String end2AttributeDescription = "The schema type that is being reused in another schema.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_TYPE.typeName), "externalSchemaType", "The schema type that is being reused in another schema.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDerivedSchemaTypeQueryTargetRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DERIVED_SCHEMA_TYPE_QUERY_TARGET_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "usedBy";
        String end1AttributeDescription = "Use of another schema type to derive all or part of this schema type's value.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ELEMENT.typeName), "usedBy", "Use of another schema type to derive all or part of this schema type's value.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "queryTarget";
        String end2AttributeDescription = "Used to provide data values to the other schema type.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ELEMENT.typeName), "queryTarget", "Used to provide data values to the other schema type.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUERY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUERY_ID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUERY_TYPE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private TypeDefPatch updateSchemaTypeOptionRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SCHEMA_TYPE_OPTION_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "schemaOptionalUses";
        String end1AttributeDescription = "Schema where this schema type is reused.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ELEMENT.typeName), "schemaOptionalUses", "Schema where this schema type is reused.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private TypeDefPatch updateMapFromElementTypeRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.MAP_FROM_ELEMENT_TYPE_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "parentMapFrom";
        String end1AttributeDescription = "Used in map to describe the domain (value mapped from).";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ELEMENT.typeName), "parentMapFrom", "Used in map to describe the domain (value mapped from).", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private TypeDefPatch updateMapToElementTypeRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.MAP_TO_ELEMENT_TYPE_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "parentMapTo";
        String end1AttributeDescription = "Used in map to describe the range (value mapped to).";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ELEMENT.typeName), "parentMapTo", "Used in map to describe the range (value mapped to).", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0545ReferenceData() {
        this.archiveBuilder.addTypeDefPatch(this.addIsDeprecated());
    }

    private TypeDefPatch addIsDeprecated() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.VALID_VALUE_DEFINITION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_DEPRECATED));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void updateClashingControlProperties() {
        this.archiveBuilder.addTypeDefPatch(this.updateSoftwareServerPlatformEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateSoftwareServerEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateCloudPlatformClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateCloudTenantClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateCloudServiceClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateLogFileEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateDatabaseEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateDatabaseServerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateBusinessCapabilityEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateExternalReferenceEntity());
        this.archiveBuilder.addTypeDefPatch(this.updatePropertyFacetEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateCohortMemberEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateImplementationSnippetEntity());
        this.archiveBuilder.addTypeDefPatch(this.updatePolicyAdministrationPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updatePolicyDecisionPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updatePolicyEnforcementPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updatePolicyInformationPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updatePolicyRetrievalPointClassification());
    }

    private TypeDefPatch updateSoftwareServerPlatformEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PLATFORM_VERSION));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateSoftwareServerEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SOFTWARE_SERVER.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SERVER_VERSION));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCloudPlatformClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CLOUD_PLATFORM_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCloudTenantClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CLOUD_TENANT_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TENANT_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCloudServiceClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CLOUD_SERVICE_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SERVICE_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateLogFileEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.LOG_FILE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PURPOSE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateDatabaseEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DATABASE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DATABASE_VERSION));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateDatabaseServerClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DATABASE_SERVER_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOFTWARE_VERSION));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateBusinessCapabilityEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.BUSINESS_CAPABILITY.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.BUSINESS_CAPABILITY_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateExternalReferenceEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.EXTERNAL_REFERENCE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REFERENCE_VERSION));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePropertyFacetEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PROPERTY_FACET.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCHEMA_VERSION));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCohortMemberEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.COHORT_MEMBER.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROTOCOL_VERSION));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateImplementationSnippetEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.IMPLEMENTATION_SNIPPET.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VERSION_IDENTIFIER));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePolicyAdministrationPointClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.POLICY_ADMINISTRATION_POINT_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.POINT_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePolicyDecisionPointClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.POLICY_DECISION_POINT_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.POINT_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePolicyEnforcementPointClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.POLICY_ENFORCEMENT_POINT_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.POINT_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePolicyInformationPointClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.POLICY_INFORMATION_POINT_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.POINT_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePolicyRetrievalPointClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.POLICY_RETRIEVAL_POINT_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.POINT_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

