/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_4;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_5 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.5";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_5() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_5(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_4 previousTypes = new OpenMetadataTypesArchive2_4(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010BaseEntity();
        this.update0017ExternalIdentifiers();
        this.add0056AssetManager();
        this.add0395SupplementaryProperties();
        this.update0750DataPassing();
        this.update0770LineageMapping();
    }

    private void update0010BaseEntity() {
        this.archiveBuilder.addEntityDef(this.addOpenMetadataRootEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateReferenceable());
        this.archiveBuilder.addTypeDefPatch(this.updateSearchKeyword());
        this.archiveBuilder.addTypeDefPatch(this.updateLike());
        this.archiveBuilder.addTypeDefPatch(this.updateRating());
        this.archiveBuilder.addTypeDefPatch(this.updateInformalTag());
        this.archiveBuilder.addTypeDefPatch(this.updateAnnotation());
        this.archiveBuilder.addTypeDefPatch(this.updateAnnotationReview());
        this.archiveBuilder.addTypeDefPatch(this.updateAnchorsClassification());
    }

    private EntityDef addOpenMetadataRootEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.OPEN_METADATA_ROOT, null);
    }

    private TypeDefPatch updateReferenceable() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.REFERENCEABLE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateSearchKeyword() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SEARCH_KEYWORD.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateLike() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.LIKE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateRating() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.RATING.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateInformalTag() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.INFORMAL_TAG.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateAnnotation() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ANNOTATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateAnnotationReview() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ANNOTATION_REVIEW.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateAnchorsClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ANCHORS_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        typeDefPatch.setValidEntityDefs(linkedToEntities);
        return typeDefPatch;
    }

    private void update0017ExternalIdentifiers() {
        this.archiveBuilder.addEnumDef(this.getPermittedSynchronizationEnum());
        this.archiveBuilder.addTypeDefPatch(this.updateExternalIdScopeRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateExternalIdLinkRelationship());
    }

    private EnumDef getPermittedSynchronizationEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(PermittedSynchronization.getOpenTypeGUID(), PermittedSynchronization.getOpenTypeName(), PermittedSynchronization.getOpenTypeDescription(), PermittedSynchronization.getOpenTypeDescriptionGUID(), PermittedSynchronization.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (PermittedSynchronization enumValue : PermittedSynchronization.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private TypeDefPatch updateExternalIdScopeRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.PERMITTED_SYNCHRONIZATION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateExternalIdLinkRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "resources";
        String end1AttributeDescription = "Resource being identified.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "resources", "Resource being identified.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LAST_SYNCHRONIZED));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MAPPING_PROPERTIES));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0056AssetManager() {
        this.archiveBuilder.addClassificationDef(this.addAssetManagerClassification());
    }

    private ClassificationDef addAssetManagerClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.ASSET_MANAGER, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
    }

    private void add0395SupplementaryProperties() {
        this.archiveBuilder.addClassificationDef(this.addElementSupplementClassification());
        this.archiveBuilder.addRelationshipDef(this.getSupplementaryPropertiesRelationship());
    }

    private ClassificationDef addElementSupplementClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.ELEMENT_SUPPLEMENT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), false);
    }

    private RelationshipDef getSupplementaryPropertiesRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SUPPLEMENTARY_PROPERTIES_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "supplementsElement";
        String end1AttributeDescription = "Describes this technical element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "supplementsElement", "Describes this technical element.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "supplementaryProperties";
        String end2AttributeDescription = "Provides more information about this element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "supplementaryProperties", "Provides more information about this element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0750DataPassing() {
        this.archiveBuilder.addTypeDefPatch(this.updateProcessCallRelationship());
        this.archiveBuilder.addRelationshipDef(this.addDataFlowRelationship());
        this.archiveBuilder.addRelationshipDef(this.addControlFlowRelationship());
    }

    private TypeDefPatch updateProcessCallRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PROCESS_CALL_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setDescription(OpenMetadataType.PROCESS_CALL_RELATIONSHIP.description);
        String end1AttributeName = "caller";
        String end1AttributeDescription = "Call originator.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "caller", "Call originator.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2AttributeName = "called";
        String end2AttributeDescription = "Called element that performs the processing.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "called", "Called element that performs the processing.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ISC_QUALIFIED_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMULA));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private RelationshipDef addDataFlowRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DATA_FLOW_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "dataSupplier";
        String end1AttributeDescription = "Caller element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "dataSupplier", "Caller element.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "dataConsumer";
        String end2AttributeDescription = "Called element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "dataConsumer", "Called element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ISC_QUALIFIED_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMULA));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addControlFlowRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONTROL_FLOW_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "currentStep";
        String end1AttributeDescription = "Element that executes first.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "currentStep", "Element that executes first.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "nextStep";
        String end2AttributeDescription = "Element that executes next.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "nextStep", "Element that executes next.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ISC_QUALIFIED_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.GUARD));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0770LineageMapping() {
        this.archiveBuilder.addTypeDefPatch(this.updateLineageMappingRelationship());
    }

    private TypeDefPatch updateLineageMappingRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.LINEAGE_MAPPING_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "sourceElement";
        String end1AttributeDescription = "Source Attribute.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "sourceElement", "Source Attribute.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2AttributeName = "targetElement";
        String end2AttributeDescription = "Target Attribute.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "targetElement", "Target Attribute.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }
}

