/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CriticalityLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ImpactSeverity;
import org.odpi.openmetadata.frameworks.openmetadata.enums.IncidentReportStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_5;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_6 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.6";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_6() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_6(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_5 previousTypes = new OpenMetadataTypesArchive2_5(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010ManagingMemento();
        this.update0215MoreProcessTypes();
        this.update0422GovernanceActionClassifications();
        this.update0460GovernanceExecutionPoints();
        this.add0461GovernanceActionEngines();
        this.add0462GovernanceActionProcesses();
        this.add0463EngineActions();
        this.add0465DuplicateProcessing();
        this.add0470IncidentReports();
        this.add0550InstanceMetadata();
    }

    private void update0010ManagingMemento() {
        this.archiveBuilder.addClassificationDef(this.addMementoClassification());
    }

    private ClassificationDef addMementoClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.MEMENTO_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ARCHIVE_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ARCHIVE_USER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ARCHIVE_PROCESS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ARCHIVE_SERVICE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ARCHIVE_METHOD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ARCHIVE_PROPERTIES));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0215MoreProcessTypes() {
        this.archiveBuilder.addEntityDef(this.addEmbeddedProcessEntity());
        this.archiveBuilder.addEntityDef(this.addTransientEmbeddedProcessEntity());
    }

    private EntityDef addEmbeddedProcessEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EMBEDDED_PROCESS, this.archiveBuilder.getEntityDef(OpenMetadataType.PROCESS.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROCESS_START_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROCESS_END_TIME));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addTransientEmbeddedProcessEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TRANSIENT_EMBEDDED_PROCESS, this.archiveBuilder.getEntityDef(OpenMetadataType.EMBEDDED_PROCESS.typeName));
    }

    private void update0422GovernanceActionClassifications() {
        this.archiveBuilder.addEnumDef(this.getImpactSeverityEnum());
        this.archiveBuilder.addClassificationDef(this.addImpactClassification());
    }

    private EnumDef getImpactSeverityEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ImpactSeverity.getOpenTypeGUID(), ImpactSeverity.getOpenTypeName(), ImpactSeverity.getOpenTypeDescription(), ImpactSeverity.getOpenTypeDescriptionGUID(), ImpactSeverity.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ImpactSeverity enumValues : ImpactSeverity.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private ClassificationDef addImpactClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.IMPACT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    public void update0460GovernanceExecutionPoints() {
        this.archiveBuilder.addEntityDef(this.addExecutionPointDefinitionEntity());
        this.archiveBuilder.addEntityDef(this.addControlPointDefinitionEntity());
        this.archiveBuilder.addEntityDef(this.addVerificationPointDefinitionEntity());
        this.archiveBuilder.addEntityDef(this.addEnforcementPointDefinitionEntity());
        this.archiveBuilder.addRelationshipDef(this.addExecutionPointUseRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateControlPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateVerificationPointClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateEnforcementPointClassification());
    }

    private EntityDef addExecutionPointDefinitionEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EXECUTION_POINT_DEFINITION, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addControlPointDefinitionEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CONTROL_POINT_DEFINITION, this.archiveBuilder.getEntityDef(OpenMetadataType.EXECUTION_POINT_DEFINITION.typeName));
    }

    private EntityDef addVerificationPointDefinitionEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.VERIFICATION_POINT_DEFINITION, this.archiveBuilder.getEntityDef(OpenMetadataType.EXECUTION_POINT_DEFINITION.typeName));
    }

    private EntityDef addEnforcementPointDefinitionEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ENFORCEMENT_POINT_DEFINITION, this.archiveBuilder.getEntityDef(OpenMetadataType.EXECUTION_POINT_DEFINITION.typeName));
    }

    private RelationshipDef addExecutionPointUseRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.EXECUTION_POINT_USE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "supportsGovernanceDefinitions";
        String end1AttributeDescription = "Governance definition that is implemented by this execution point.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_DEFINITION.typeName), "supportsGovernanceDefinitions", "Governance definition that is implemented by this execution point.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "executedThrough";
        String end2AttributeDescription = "Description of the execution points that support the implementation of this governance definition.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.EXECUTION_POINT_DEFINITION.typeName), "executedThrough", "Description of the execution points that support the implementation of this governance definition.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch updateControlPointClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CONTROL_POINT_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUALIFIED_NAME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateVerificationPointClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.VERIFICATION_POINT_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUALIFIED_NAME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateEnforcementPointClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ENFORCEMENT_POINT_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.QUALIFIED_NAME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0461GovernanceActionEngines() {
        this.archiveBuilder.addEntityDef(this.addGovernanceEngineEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceServiceEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceActionEngineEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceActionServiceEntity());
        this.archiveBuilder.addRelationshipDef(this.addSupportedGovernanceServiceRelationship());
    }

    private EntityDef addGovernanceEngineEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_ENGINE, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
    }

    private EntityDef addGovernanceServiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_SERVICE, this.archiveBuilder.getEntityDef(OpenMetadataType.DEPLOYED_CONNECTOR.typeName));
    }

    private EntityDef addGovernanceActionEngineEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_ACTION_ENGINE, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ENGINE.typeName));
    }

    private EntityDef addGovernanceActionServiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_ACTION_SERVICE, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_SERVICE.typeName));
    }

    private RelationshipDef addSupportedGovernanceServiceRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "calledFromGovernanceEngines";
        String end1AttributeDescription = "Governance Engine making use of the governance service.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ENGINE.typeName), "calledFromGovernanceEngines", "Governance Engine making use of the governance service.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "supportedGovernanceServices";
        String end2AttributeDescription = "Governance service that is part of the governance engine.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_SERVICE.typeName), "supportedGovernanceServices", "Governance service that is part of the governance engine.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REQUEST_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REQUEST_PARAMETERS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0462GovernanceActionProcesses() {
        this.archiveBuilder.addEntityDef(this.addGovernanceActionProcessEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceActionTypeEntity());
        this.archiveBuilder.addEntityDef(this.addGovernanceActionProcessStepEntity());
        this.archiveBuilder.addRelationshipDef(this.addGovernanceActionProcessFlowRelationship());
        this.archiveBuilder.addRelationshipDef(this.addNextGovernanceActionProcessStepRelationship());
        this.archiveBuilder.addRelationshipDef(this.addGovernanceActionExecutorRelationship());
    }

    private EntityDef addGovernanceActionProcessEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_ACTION_PROCESS, this.archiveBuilder.getEntityDef(OpenMetadataType.PROCESS.typeName));
    }

    private EntityDef addGovernanceActionTypeEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_ACTION_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DOMAIN_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.WAIT_TIME));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addGovernanceActionProcessStepEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ACTION_TYPE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IGNORE_MULTIPLE_TRIGGERS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addGovernanceActionProcessFlowRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_FLOW_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "triggeredFrom";
        String end1AttributeDescription = "Governance process that describes the set of process steps.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName), "triggeredFrom", "Governance process that describes the set of process steps.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "firstStep";
        String end2AttributeDescription = "First step to execute in a governance action process.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName), "firstStep", "First step to execute in a governance action process.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef addNextGovernanceActionProcessStepRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.NEXT_GOVERNANCE_ACTION_PROCESS_STEP_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "dependedOnProcessSteps";
        String end1AttributeDescription = "Governance Action Process Step caller.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName), "dependedOnProcessSteps", "Governance Action Process Step caller.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "followOnProcessSteps";
        String end2AttributeDescription = "Governance Action Process Step called.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName), "followOnProcessSteps", "Governance Action Process Step called.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.GUARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MANDATORY_GUARD));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addGovernanceActionExecutorRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.GOVERNANCE_ACTION_EXECUTOR_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "supportsGovernanceActions";
        String end1AttributeDescription = "Governance action that drives calls to a governance engine.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ACTION_TYPE.typeName), "supportsGovernanceActions", "Governance action that drives calls to a governance engine.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "governanceActionExecutor";
        String end2AttributeDescription = "Governance engine that will run the requested action.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ENGINE.typeName), "governanceActionExecutor", "Governance engine that will run the requested action.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REQUEST_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REQUEST_PARAMETERS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0463EngineActions() {
        this.archiveBuilder.addEnumDef(this.getEngineActionStatusEnum());
        this.archiveBuilder.addEntityDef(this.addEngineActionEntity());
        this.archiveBuilder.addRelationshipDef(this.addEngineActionRequestSourceRelationship());
        this.archiveBuilder.addRelationshipDef(this.addTargetForActionRelationship());
        this.archiveBuilder.addRelationshipDef(this.addNextEngineActionRelationship());
    }

    private EnumDef getEngineActionStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(EngineActionStatus.getOpenTypeGUID(), EngineActionStatus.getOpenTypeName(), EngineActionStatus.getOpenTypeDescription(), EngineActionStatus.getOpenTypeDescriptionGUID(), EngineActionStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (EngineActionStatus enumValues : EngineActionStatus.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef addEngineActionEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ENGINE_ACTION, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DOMAIN_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROCESSING_ENGINE_USER_ID));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.ACTION_STATUS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.START_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COMPLETION_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COMPLETION_GUARDS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RECEIVED_GUARDS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addEngineActionRequestSourceRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ENGINE_ACTION_REQUEST_SOURCE, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "sourceActivity";
        String end1AttributeDescription = "Element(s) that caused this engine action to be created.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "sourceActivity", "Element(s) that caused this engine action to be created.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "identifiedActions";
        String end2AttributeDescription = "Engine actions that were initiated for the linked element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ENGINE_ACTION.typeName), "identifiedActions", "Engine actions that were initiated for the linked element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ORIGIN_GOVERNANCE_SERVICE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ORIGIN_GOVERNANCE_ENGINE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REQUEST_SOURCE_NAME));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addTargetForActionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "identifiedEngineActions";
        String end1AttributeDescription = "Engine action that is acting on this element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ENGINE_ACTION.typeName), "identifiedEngineActions", "Engine action that is acting on this element.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "actionTarget";
        String end2AttributeDescription = "Element(s) to work on.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "actionTarget", "Element(s) to work on.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.ACTION_STATUS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.START_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COMPLETION_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTION_TARGET_NAME));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addNextEngineActionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.NEXT_ENGINE_ACTION, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "previousActions";
        String end1AttributeDescription = "Engine action that triggered this engine action.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ENGINE_ACTION.typeName), "previousActions", "Engine action that triggered this engine action.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "followOnActions";
        String end2AttributeDescription = "Engine action(s) that should run next.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ENGINE_ACTION.typeName), "followOnActions", "Engine action(s) that should run next.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.GUARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MANDATORY_GUARD));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    public void add0465DuplicateProcessing() {
        this.archiveBuilder.addClassificationDef(this.addKnowDuplicateClassification());
    }

    private ClassificationDef addKnowDuplicateClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.KNOWN_DUPLICATE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), true);
    }

    public void add0470IncidentReports() {
        this.archiveBuilder.addEnumDef(this.getIncidentReportStatusEnum());
        this.archiveBuilder.addEntityDef(this.addIncidentReportEntity());
        this.archiveBuilder.addRelationshipDef(this.addIncidentOriginatorRelationship());
        this.archiveBuilder.addRelationshipDef(this.addImpactedResourceRelationship());
        this.archiveBuilder.addRelationshipDef(this.addIncidentDependencyRelationship());
    }

    private EnumDef getIncidentReportStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(IncidentReportStatus.getOpenTypeGUID(), IncidentReportStatus.getOpenTypeName(), IncidentReportStatus.getOpenTypeDescription(), IncidentReportStatus.getOpenTypeDescriptionGUID(), IncidentReportStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (CriticalityLevel enumValues : CriticalityLevel.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef addIncidentReportEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.INCIDENT_REPORT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DOMAIN_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.BACKGROUND));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.START_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COMPLETION_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INCIDENT_CLASSIFIERS));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.INCIDENT_STATUS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addIncidentOriginatorRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.INCIDENT_ORIGINATOR_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "originators";
        String end1AttributeDescription = "Source(s) of the incident report.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "originators", "Source(s) of the incident report.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "resultingIncidentReports";
        String end2AttributeDescription = "Descriptions of detected incidents.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.INCIDENT_REPORT.typeName), "resultingIncidentReports", "Descriptions of detected incidents.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef addImpactedResourceRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.IMPACTED_RESOURCE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "impactedResources";
        String end1AttributeDescription = "Resources impacted by the incident.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "impactedResources", "Resources impacted by the incident.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "incidentReports";
        String end2AttributeDescription = "Descriptions of incidents affecting this resource and the action taken.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.INCIDENT_REPORT.typeName), "incidentReports", "Descriptions of incidents affecting this resource and the action taken.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SEVERITY_LEVEL_IDENTIFIER));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addIncidentDependencyRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.INCIDENT_DEPENDENCY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "priorReportedIncidents";
        String end1AttributeDescription = "Previous reports on the same or related incident.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.INCIDENT_REPORT.typeName), "priorReportedIncidents", "Previous reports on the same or related incident.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "followOnReportedIncidents";
        String end2AttributeDescription = "Subsequent reports on the same or related incident.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.INCIDENT_REPORT.typeName), "followOnReportedIncidents", "Subsequent reports on the same or related incident.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    public void add0550InstanceMetadata() {
        this.archiveBuilder.addClassificationDef(this.addInstanceMetadataClassification());
    }

    private ClassificationDef addInstanceMetadataClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.INSTANCE_METADATA_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.SCHEMA_ELEMENT.typeName), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INSTANCE_METADATA_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }
}

