/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_12;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_13 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.13";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_13() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_13(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_12 previousTypes = new OpenMetadataTypesArchive3_12(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010BaseModel();
        this.update0022Translations();
        this.addArea1Actors();
        this.add0222DataFilesAndFolders();
        this.add0223DataFeed();
        this.add0430ServiceLevelObjectives();
        this.update0481Licenses();
        this.add0483TermsAndConditions();
        this.add0484Agreements();
        this.add00710DigitalProduct();
        this.add00711DigitalSubscription();
        this.update0715DigitalServiceOwnership();
    }

    private void update0010BaseModel() {
        this.archiveBuilder.addTypeDefPatch(this.updateAsset());
    }

    private TypeDefPatch updateAsset() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ASSET.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VERSION_IDENTIFIER));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0022Translations() {
        this.archiveBuilder.addTypeDefPatch(this.updateTranslation());
    }

    private TypeDefPatch updateTranslation() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.TRANSLATION_DETAIL.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LANGUAGE_CODE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void addArea1Actors() {
        this.archiveBuilder.addEntityDef(this.getActorEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateActorProfile());
        this.archiveBuilder.addTypeDefPatch(this.updateUserIdentity());
        this.archiveBuilder.addTypeDefPatch(this.updatePersonRole());
        this.archiveBuilder.addTypeDefPatch(this.updateProjectTeam());
        this.archiveBuilder.addTypeDefPatch(this.updateToDo());
        this.archiveBuilder.addTypeDefPatch(this.updateActionAssignment());
        this.archiveBuilder.addTypeDefPatch(this.updateCrowdSourcingContribution());
    }

    private EntityDef getActorEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ACTOR, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
    }

    private TypeDefPatch updateActorProfile() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ACTOR_PROFILE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateUserIdentity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.USER_IDENTITY.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updatePersonRole() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PERSON_ROLE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateProjectTeam() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2AttributeName = "supportingActors";
        String end2AttributeDescription = "People and teams supporting this project.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR.typeName), "supportingActors", "People and teams supporting this project.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private TypeDefPatch updateToDo() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.TO_DO.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TO_DO_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateActionAssignment() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ACTION_ASSIGNMENT_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "assignedActor";
        String end1AttributeDescription = "The person/people assigned to perform the action(s) requested in the to do.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR.typeName), "assignedActor", "The person/people assigned to perform the action(s) requested in the to do.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        return typeDefPatch;
    }

    private TypeDefPatch updateCrowdSourcingContribution() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CROWD_SOURCING_CONTRIBUTION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2AttributeName = "contributors";
        String end2AttributeDescription = "The person/people making the contribution.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR.typeName), "contributors", "The person/people making the contribution.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void add0222DataFilesAndFolders() {
        this.archiveBuilder.addEntityDef(this.getParquetFileEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateDataFileEntity());
    }

    private TypeDefPatch updateDataFileEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DATA_FILE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FILE_NAME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private EntityDef getParquetFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PARQUET_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
    }

    private void add0223DataFeed() {
        this.archiveBuilder.addEntityDef(this.getDataFeedEntity());
    }

    private EntityDef getDataFeedEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_FEED, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_ASSET.typeName));
    }

    private void add0430ServiceLevelObjectives() {
        this.archiveBuilder.addEntityDef(this.getServiceLevelObjectivesEntity());
    }

    private EntityDef getServiceLevelObjectivesEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SERVICE_LEVEL_OBJECTIVE, this.archiveBuilder.getEntityDef(OpenMetadataType.TECHNICAL_CONTROL.typeName));
    }

    private void update0481Licenses() {
        this.archiveBuilder.addTypeDefPatch(this.updateLicenseRelationship());
    }

    private TypeDefPatch updateLicenseRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.LICENSE_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENTITLEMENTS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RESTRICTIONS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.OBLIGATIONS));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0483TermsAndConditions() {
        this.archiveBuilder.addEntityDef(this.getTermsAndConditionsEntity());
        this.archiveBuilder.addRelationshipDef(this.getAttachedTermsAndConditionsRelationship());
    }

    private EntityDef getTermsAndConditionsEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TERMS_AND_CONDITIONS, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENTITLEMENTS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RESTRICTIONS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.OBLIGATIONS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getAttachedTermsAndConditionsRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTACHED_TERMS_AND_CONDITIONS_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "subjectOfTermsAndConditions";
        String end1AttributeDescription = "Entity that the terms and condition applied.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "subjectOfTermsAndConditions", "Entity that the terms and condition applied.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "termsAndConditions";
        String end2AttributeDescription = "Entitlements, restrictions and obligations.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TERMS_AND_CONDITIONS.typeName), "termsAndConditions", "Entitlements, restrictions and obligations.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0484Agreements() {
        this.archiveBuilder.addEntityDef(this.getAgreementEntity());
        this.archiveBuilder.addRelationshipDef(this.getAgreementActorRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAgreementItemRelationship());
        this.archiveBuilder.addRelationshipDef(this.getContractLinkRelationship());
    }

    private EntityDef getAgreementEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.AGREEMENT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AGREEMENT_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getAgreementActorRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.AGREEMENT_ACTOR_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "relatedAgreements";
        String end1AttributeDescription = "The agreements that include the actor.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.AGREEMENT.typeName), "relatedAgreements", "The agreements that include the actor.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "agreementActors";
        String end2AttributeDescription = "The actors that are named in the agreement.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR.typeName), "agreementActors", "The actors that are named in the agreement.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTOR_NAME));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getAgreementItemRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.AGREEMENT_ITEM_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        relationshipDef.setMultiLink(true);
        String end1AttributeName = "agreementContents";
        String end1AttributeDescription = "The agreement that the item relates to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.AGREEMENT.typeName), "agreementContents", "The agreement that the item relates to.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "agreementItems";
        String end2AttributeDescription = "Specific items in the agreement.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "agreementItems", "Specific items in the agreement.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AGREEMENT_ITEM_ID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AGREEMENT_START));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AGREEMENT_END));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENTITLEMENTS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RESTRICTIONS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.OBLIGATIONS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USAGE_MEASUREMENTS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getContractLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONTRACT_LINK_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "agreements";
        String end1AttributeDescription = "Agreements related to the contract.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.AGREEMENT.typeName), "agreements", "Agreements related to the contract.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "contracts";
        String end2AttributeDescription = "Details of the contract documents.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.EXTERNAL_REFERENCE.typeName), "contracts", "Details of the contract documents.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONTRACT_ID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONTRACT_LIAISON));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONTRACT_LIAISON_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONTRACT_LIAISON_PROPERTY_NAME));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add00710DigitalProduct() {
        this.archiveBuilder.addClassificationDef(this.addDigitalProductClassification());
    }

    private ClassificationDef addDigitalProductClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.DIGITAL_PRODUCT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), true);
    }

    private void add00711DigitalSubscription() {
        this.archiveBuilder.addEntityDef(this.getDigitalSubscriptionEntity());
        this.archiveBuilder.addRelationshipDef(this.getDigitalSubscriberRelationship());
    }

    private EntityDef getDigitalSubscriptionEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DIGITAL_SUBSCRIPTION, this.archiveBuilder.getEntityDef(OpenMetadataType.AGREEMENT.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SUPPORT_LEVEL));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SERVICE_LEVELS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getDigitalSubscriberRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DIGITAL_SUBSCRIBER_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "digitalSubscribers";
        String end1AttributeDescription = "The digital subscribers registered under a subscription.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "digitalSubscribers", "The digital subscribers registered under a subscription.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "digitalSubscriptions";
        String end2AttributeDescription = "The digital subscriptions in use by the subscriber.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DIGITAL_SUBSCRIPTION.typeName), "digitalSubscriptions", "The digital subscriptions in use by the subscriber.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SUPPORT_LEVEL));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0715DigitalServiceOwnership() {
        this.archiveBuilder.addTypeDefPatch(this.updateDigitalServiceOperator());
    }

    private TypeDefPatch updateDigitalServiceOperator() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DIGITAL_SERVICE_OPERATOR_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "operatesDigitalServices";
        String end1AttributeDescription = "The digital services that this team/organization operates.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DIGITAL_SERVICE.typeName), "operatesDigitalServices", "The digital services that this team/organization operates.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2AttributeName = "digitalServiceOperators";
        String end2AttributeDescription = "The teams/organizations responsible for operating the digital service.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TEAM.typeName), "digitalServiceOperators", "The teams/organizations responsible for operating the digital service.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }
}

