/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_14;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_15 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.15";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_15() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_15(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_14 previousTypes = new OpenMetadataTypesArchive3_14(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.updateGovernanceEngines();
        this.updateEngineActions();
        this.update0710DigitalServices();
        this.update0715DigitalServiceOwnership();
        this.update0735SolutionPortsAndWires();
    }

    private void updateGovernanceEngines() {
        this.archiveBuilder.addTypeDefPatch(this.updateSupportedGovernanceServiceRelationship());
    }

    private TypeDefPatch updateSupportedGovernanceServiceRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SERVICE_REQUEST_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void updateEngineActions() {
        this.archiveBuilder.addTypeDefPatch(this.updateEngineActionEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateTargetForActionRelationship());
    }

    private TypeDefPatch updateEngineActionEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ENGINE_ACTION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COMPLETION_MESSAGE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateTargetForActionRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.TARGET_FOR_ACTION_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COMPLETION_MESSAGE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0710DigitalServices() {
        this.archiveBuilder.addRelationshipDef(this.getDigitalServiceProductRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateDigitalProductClassification());
    }

    private RelationshipDef getDigitalServiceProductRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DIGITAL_SERVICE_PRODUCT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "managingDigitalService";
        String end1AttributeDescription = "Digital service responsible for the production of the digital product.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DIGITAL_SERVICE.typeName), "managingDigitalService", "Digital service responsible for the production of the digital product.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "digitalProducts";
        String end2AttributeDescription = "The associated digital products.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "digitalProducts", "The associated digital products.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch updateDigitalProductClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DIGITAL_PRODUCT_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PRODUCT_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PRODUCT_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INTRODUCTION_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MATURITY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SERVICE_LIFE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CURRENT_VERSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NEXT_VERSION_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.WITHDRAW_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0715DigitalServiceOwnership() {
        this.archiveBuilder.addTypeDefPatch(this.updateDigitalServiceOperatorRelationship());
    }

    private TypeDefPatch updateDigitalServiceOperatorRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DIGITAL_SERVICE_OPERATOR_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2AttributeName = "digitalServiceOperators";
        String end2AttributeDescription = "The unit (team, capability, ...) responsible for managing this digital service.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "digitalServiceOperators", "The unit (team, capability, ...) responsible for managing this digital service.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0735SolutionPortsAndWires() {
        this.archiveBuilder.addTypeDefPatch(this.updateSolutionLinkingWireRelationship());
    }

    private TypeDefPatch updateSolutionLinkingWireRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SOLUTION_LINKING_WIRE_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "wiredTo";
        String end1AttributeDescription = "Port that the wire connects to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "wiredTo", "Port that the wire connects to.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2AttributeName = "wiredTo";
        String end2AttributeDescription = "Port that the wire connects to.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "wiredTo", "Port that the wire connects to.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }
}

