/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_1;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_2 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.2";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_2() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_2(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_1 previousTypes = new OpenMetadataTypesArchive3_1(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0030HostsAndOperatingPlatforms();
        this.update0422GovernanceActionClassifications();
        this.update0450GovernanceRollout();
        this.update0455ExceptionManagement();
        this.update0465DuplicateProcessing();
        this.update0620DataProfiling();
    }

    private void update0030HostsAndOperatingPlatforms() {
        this.archiveBuilder.addEntityDef(this.addSoftwareArchiveEntity());
    }

    private EntityDef addSoftwareArchiveEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SOFTWARE_ARCHIVE, this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName));
    }

    private void update0422GovernanceActionClassifications() {
        this.archiveBuilder.addTypeDefPatch(this.updateImpactClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateCriticalityClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateConfidentialityClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateConfidenceClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateRetentionClassification());
    }

    private TypeDefPatch updateImpactClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.IMPACT_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STATUS_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SEVERITY_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_PROPERTY_NAME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCriticalityClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STATUS_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LEVEL_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_PROPERTY_NAME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateConfidentialityClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STATUS_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LEVEL_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_PROPERTY_NAME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateConfidenceClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STATUS_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LEVEL_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_PROPERTY_NAME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateRetentionClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.RETENTION_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STATUS_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RETENTION_BASIS_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_PROPERTY_NAME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0450GovernanceRollout() {
        this.archiveBuilder.addClassificationDef(this.getGovernanceExpectationsClassification());
    }

    private ClassificationDef getGovernanceExpectationsClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.GOVERNANCE_EXPECTATIONS_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COUNTS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VALUES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FLAGS));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0455ExceptionManagement() {
        this.archiveBuilder.addClassificationDef(this.getLogAnalysisClassification());
        this.archiveBuilder.addClassificationDef(this.getLineageLogClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateExceptionBacklogClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateMeteringLogClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateAuditLogClassification());
    }

    private ClassificationDef getLogAnalysisClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.LOG_ANALYSIS_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROCESS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COUNTS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VALUES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FLAGS));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getLineageLogClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.LINEAGE_LOG_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROCESS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private TypeDefPatch updateAuditLogClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.AUDIT_LOG_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> linkToList = new ArrayList<TypeDefLink>();
        linkToList.add(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName));
        typeDefPatch.setValidEntityDefs(linkToList);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROCESS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateMeteringLogClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.METERING_LOG_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> linkToList = new ArrayList<TypeDefLink>();
        linkToList.add(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName));
        typeDefPatch.setValidEntityDefs(linkToList);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROCESS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateExceptionBacklogClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.EXCEPTION_BACKLOG_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> linkToList = new ArrayList<TypeDefLink>();
        linkToList.add(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName));
        typeDefPatch.setValidEntityDefs(linkToList);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROCESS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_PROPERTY_NAME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0465DuplicateProcessing() {
        this.archiveBuilder.addClassificationDef(this.addConsolidatedDuplicateClassification());
        this.archiveBuilder.addRelationshipDef(this.addPeerDuplicateLinkRelationship());
        this.archiveBuilder.addRelationshipDef(this.addConsolidatedDuplicateLinkRelationship());
    }

    private ClassificationDef addConsolidatedDuplicateClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CONSOLIDATED_DUPLICATE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STATUS_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_PROPERTY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private RelationshipDef addPeerDuplicateLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.PEER_DUPLICATE_LINK, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "peerDuplicateOrigin";
        String end1AttributeDescription = "Oldest element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "peerDuplicateOrigin", "Oldest element.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "peerDuplicatePartner";
        String end2AttributeDescription = "Newest element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "peerDuplicatePartner", "Newest element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STATUS_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_PROPERTY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addConsolidatedDuplicateLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONSOLIDATED_DUPLICATE_LINK, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "consolidatedDuplicateOrigin";
        String end1AttributeDescription = "Detected duplicate element - the source of the properties.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "consolidatedDuplicateOrigin", "Detected duplicate element - the source of the properties.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "consolidatedDuplicateResult";
        String end2AttributeDescription = "Element resulting from combining the duplicate entities.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "consolidatedDuplicateResult", "Element resulting from combining the duplicate entities.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0620DataProfiling() {
        this.archiveBuilder.addEntityDef(this.addFingerprintAnnotationEntity());
    }

    private EntityDef addFingerprintAnnotationEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.FINGERPRINT_ANNOTATION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FIELD_ANNOTATION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FINGERPRINT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FINGERPRINT_ALGORITHM));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.HASH));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.HASH_ALGORITHM));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }
}

