/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_4;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_5 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.5";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_5() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_5(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_4 previousTypes = new OpenMetadataTypesArchive3_4(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0041ServerPurpose();
        this.update00420045SoftwareCapabilities();
        this.extend0112Person();
        this.update0130Projects();
        this.update0140Communities();
    }

    private void update00420045SoftwareCapabilities() {
        this.archiveBuilder.addEntityDef(this.getSoftwareCapabilityEntity());
        this.archiveBuilder.addRelationshipDef(this.getSupportedSoftwareCapabilityRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateSoftwareServerCapabilityEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateFileSystemClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateFileManagerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateNotificationManagerClassification());
        this.archiveBuilder.addClassificationDef(this.addSourceControlLibraryClassification());
        this.archiveBuilder.addClassificationDef(this.addChangeManagementLibraryClassification());
        this.archiveBuilder.addClassificationDef(this.addSoftwareLibraryClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateDatabaseManagerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateContentCollectionManagerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateCloudServiceClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateServerAssetUseRelationship());
    }

    private EntityDef getSoftwareCapabilityEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SOFTWARE_CAPABILITY, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CAPABILITY_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CAPABILITY_VERSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PATCH_LEVEL));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getSupportedSoftwareCapabilityRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "hostedByDeployedITInfrastructure";
        String end1AttributeDescription = "IT infrastructure hosting this capability.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.IT_INFRASTRUCTURE.typeName), "hostedByDeployedITInfrastructure", "IT infrastructure hosting this capability.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "capabilities";
        String end2AttributeDescription = "Capabilities deployed on this IT infrastructure.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_CAPABILITY.typeName), "capabilities", "Capabilities deployed on this IT infrastructure.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DEPLOYMENT_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DEPLOYER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DEPLOYER_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DEPLOYER_PROPERTY_NAME));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.OPERATIONAL_STATUS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private TypeDefPatch updateSoftwareServerCapabilityEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_CAPABILITY.typeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateFileSystemClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.FILE_SYSTEM_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.REFERENCEABLE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateFileManagerClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.FILE_MANAGER_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.REFERENCEABLE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateNotificationManagerClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.NOTIFICATION_MANAGER.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.REFERENCEABLE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateContentCollectionManagerClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CONTENT_COLLECTION_MANAGER.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.REFERENCEABLE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private ClassificationDef addSourceControlLibraryClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.SOURCE_CONTROL_LIBRARY_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LIBRARY_TYPE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef addChangeManagementLibraryClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CHANGE_MANAGEMENT_LIBRARY_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LIBRARY_TYPE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef addSoftwareLibraryClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.SOFTWARE_LIBRARY_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LIBRARY_TYPE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private TypeDefPatch updateCloudServiceClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CLOUD_SERVICE_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.SOFTWARE_CAPABILITY.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateDatabaseManagerClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DATABASE_MANAGER.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.DATA_MANAGER.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateServerAssetUseRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "consumedBy";
        String end1AttributeDescription = "Capability consuming this asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_CAPABILITY.typeName), "consumedBy", "Capability consuming this asset.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2AttributeName = "consumedAsset";
        String end2AttributeDescription = "Asset that this software capability is dependent on.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "consumedAsset", "Asset that this software capability is dependent on.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0041ServerPurpose() {
        this.archiveBuilder.addClassificationDef(this.addServerPurposeClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateApplicationServerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateWebserverClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateDatabaseServerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateMetadataServerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateRepositoryProxyClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceDaemonClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateStewardshipServerClassification());
        this.archiveBuilder.addClassificationDef(this.addIntegrationServerClassification());
    }

    private ClassificationDef addServerPurposeClassification() {
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef(OpenMetadataType.IT_INFRASTRUCTURE.typeName));
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION, null, linkedToEntities, false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private TypeDefPatch updateApplicationServerClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.APPLICATION_SERVER_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.IT_INFRASTRUCTURE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateWebserverClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.WEBSERVER_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.IT_INFRASTRUCTURE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateDatabaseServerClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DATABASE_SERVER_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.IT_INFRASTRUCTURE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateMetadataServerClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.METADATA_SERVER_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.IT_INFRASTRUCTURE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateRepositoryProxyClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.REPOSITORY_PROXY_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.IT_INFRASTRUCTURE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceDaemonClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.GOVERNANCE_DAEMON_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.IT_INFRASTRUCTURE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateStewardshipServerClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.STEWARDSHIP_SERVER_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName(OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(OpenMetadataType.IT_INFRASTRUCTURE.typeName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private ClassificationDef addIntegrationServerClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.INTEGRATION_SERVER_CLASSIFICATION, (TypeDefLink)this.archiveBuilder.getClassificationDef(OpenMetadataType.SERVER_PURPOSE_CLASSIFICATION.typeName), this.archiveBuilder.getEntityDef(OpenMetadataType.IT_INFRASTRUCTURE.typeName), false);
    }

    private void extend0112Person() {
        this.archiveBuilder.addTypeDefPatch(this.updatePersonEntity());
    }

    private TypeDefPatch updatePersonEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PERSON.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COURTESY_TITLE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.GIVEN_NAMES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SURNAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EMPLOYEE_NUMBER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EMPLOYEE_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PREFERRED_LANGUAGE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INITIALS));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0130Projects() {
        this.archiveBuilder.addTypeDefPatch(this.updateProjectManagementRelationship());
    }

    private TypeDefPatch updateProjectManagementRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2AttributeName = "projectManagers";
        String end2AttributeDescription = "The roles for managing this project.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName), "projectManagers", "The roles for managing this project.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0140Communities() {
        this.archiveBuilder.addTypeDefPatch(this.updateCommunityMembershipRelationship());
    }

    private TypeDefPatch updateCommunityMembershipRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.COMMUNITY_MEMBERSHIP_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2AttributeName = "communityMembers";
        String end2AttributeDescription = "Members of the community.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName), "communityMembers", "Members of the community.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }
}

