/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_7;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_8 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.8";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_8() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_8(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_7 previousTypes = new OpenMetadataTypesArchive3_7(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0011ManagingReferenceables();
        this.update0015LinkedMediaTypes();
        this.update0160NoteLogs();
        this.update0030OperatingPlatforms();
        this.update0057SoftwareServices();
        this.update0070NetworksAndGateways();
        this.update0461GovernanceEngines();
        this.update0566DesignModelOrganization();
        this.update0571ConceptModels();
    }

    private void update0011ManagingReferenceables() {
        this.archiveBuilder.addTypeDefPatch(this.updateSourcedFromRelationship());
    }

    private TypeDefPatch updateSourcedFromRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "resultingElement";
        String end1AttributeDescription = "Element created from the template.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "resultingElement", "Element created from the template.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2AttributeName = "templateElement";
        String end2AttributeDescription = "Template element providing information.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "templateElement", "Template element providing information.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0015LinkedMediaTypes() {
        this.archiveBuilder.addTypeDefPatch(this.updateExternalReferenceLinkRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateMediaReferenceRelationship());
    }

    private TypeDefPatch updateExternalReferenceLinkRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private TypeDefPatch updateMediaReferenceRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.MEDIA_REFERENCE_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private void update0057SoftwareServices() {
        this.archiveBuilder.addEntityDef(this.addMetadataRepositoryServiceEntity());
        this.archiveBuilder.addEntityDef(this.addSecurityServiceEntity());
    }

    private EntityDef addMetadataRepositoryServiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.METADATA_REPOSITORY_SERVICE, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVICE.typeName));
    }

    private EntityDef addSecurityServiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SECURITY_SERVICE, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVICE.typeName));
    }

    private void update0030OperatingPlatforms() {
        this.archiveBuilder.addRelationshipDef(this.addSoftwarePackageDependencyRelationship());
    }

    private RelationshipDef addSoftwarePackageDependencyRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SOFTWARE_PACKAGE_DEPENDENCY_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "runningWithAsset";
        String end1AttributeDescription = "Assets making use of software package.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "runningWithAsset", "Assets making use of software package.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "dependsOnSoftwarePackages";
        String end2AttributeDescription = "Collection of software packages.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName), "dependsOnSoftwarePackages", "Collection of software packages.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0070NetworksAndGateways() {
        this.archiveBuilder.addRelationshipDef(this.getVisibleEndpointRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateNetworkGatewayLinkRelationship());
    }

    private RelationshipDef getVisibleEndpointRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.VISIBLE_ENDPOINT, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "visibleEndpoints";
        String end1AttributeDescription = "Endpoint callable through network.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ENDPOINT.typeName), "visibleEndpoints", "Endpoint callable through network.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "visibleInNetwork";
        String end2AttributeDescription = "Networks from which the endpoint can be called.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.NETWORK.typeName), "visibleInNetwork", "Networks from which the endpoint can be called.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch updateNetworkGatewayLinkRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.NETWORK_GATEWAY_LINK_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXTERNAL_ENDPOINT_ADDRESS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.INTERNAL_ENDPOINT_ADDRESS));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0160NoteLogs() {
        this.archiveBuilder.addTypeDefPatch(this.updateNoteLogAuthorshipRelationship());
    }

    private TypeDefPatch updateNoteLogAuthorshipRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.NOTE_LOG_AUTHORSHIP_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "authors";
        String end1AttributeDescription = "Person contributing to the note log.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.PERSON_ROLE.typeName), "authors", "Person contributing to the note log.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        String end2AttributeName = "authoredNoteLogs";
        String end2AttributeDescription = "Note log containing contributions.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.NOTE_LOG.typeName), "authoredNoteLogs", "Note log containing contributions.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0461GovernanceEngines() {
        this.archiveBuilder.addEntityDef(this.getRepositoryGovernanceEngineEntity());
        this.archiveBuilder.addEntityDef(this.getRepositoryGovernanceServiceEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateSupportedGovernanceServiceRelationship());
    }

    private TypeDefPatch updateSupportedGovernanceServiceRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private EntityDef getRepositoryGovernanceEngineEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.REPOSITORY_GOVERNANCE_ENGINE, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ENGINE.typeName));
    }

    private EntityDef getRepositoryGovernanceServiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.REPOSITORY_GOVERNANCE_SERVICE, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_SERVICE.typeName));
    }

    private void update0566DesignModelOrganization() {
        this.archiveBuilder.addRelationshipDef(this.addDesignModelOwnershipRelationship());
    }

    private RelationshipDef addDesignModelOwnershipRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DESIGN_MODEL_OWNERSHIP_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "owningDesignModel";
        String end1AttributeDescription = "Owning model.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DESIGN_MODEL.typeName), "owningDesignModel", "Owning model.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "designModelElements";
        String end2AttributeDescription = "List of elements that belong to this model.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.DESIGN_MODEL_ELEMENT.typeName), "designModelElements", "List of elements that belong to this model.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0571ConceptModels() {
        this.archiveBuilder.addClassificationDef(this.addConceptModelClassification());
    }

    private ClassificationDef addConceptModelClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.CONCEPT_MODEL_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.DESIGN_MODEL.typeName), false);
    }
}

