/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_8;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_9 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.9";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_9() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_9(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_8 previousTypes = new OpenMetadataTypesArchive3_8(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0015LinkedMediaTypes();
    }

    private void update0015LinkedMediaTypes() {
        this.archiveBuilder.addTypeDefPatch(this.updateExternalReferenceLinkRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateMediaReferenceRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateRelatedMediaEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateExternalReferenceEntity());
    }

    private TypeDefPatch updateExternalReferenceLinkRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PAGES));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateMediaReferenceRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.MEDIA_REFERENCE_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.MEDIA_USAGE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MEDIA_USAGE_OTHER_ID));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateRelatedMediaEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.RELATED_MEDIA.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.DEFAULT_MEDIA_USAGE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DEFAULT_MEDIA_USAGE_OTHER_ID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MEDIA_TYPE_OTHER_ID));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateExternalReferenceEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.EXTERNAL_REFERENCE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REFERENCE_TITLE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REFERENCE_ABSTRACT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AUTHORS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NUMBER_OF_PAGES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PAGE_RANGE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ORGANIZATION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PUBLICATION_SERIES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PUBLICATION_SERIES_VOLUME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EDITION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REFERENCE_VERSION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.URL));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PUBLISHER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FIRST_PUB_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PUBLICATION_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PUBLICATION_CITY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PUBLICATION_YEAR));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PUBLICATION_NUMBERS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LICENSE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COPYRIGHT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ATTRIBUTION));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

