/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CollectionMemberStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_15;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive4_0 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "4.0";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive4_0() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive4_0(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_15 previousTypes = new OpenMetadataTypesArchive3_15(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0021Collections();
        this.update0137ToDos();
        this.add0220DataFileCollectionDataSet();
        this.add0224TableDataSet();
        this.add0239DeployedReportType();
        this.update0385ControlledGlossaries();
        this.update0462GovernanceActionProcesses();
        this.create0464DynamicIntegrationGroups();
        this.update0484AgreementActor();
        this.update0545ReferenceData();
        this.update0720InformationSupplyChains();
        this.addFormulaTypeAttribute();
    }

    private void update0385ControlledGlossaries() {
        this.archiveBuilder.addTypeDefPatch(this.updateControlledGlossaryTermEntity());
    }

    private TypeDefPatch updateControlledGlossaryTermEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CONTROLLED_GLOSSARY_TERM.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USER_DEFINED_STATUS));
        typeDefPatch.setPropertyDefinitions(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        typeDefPatch.setValidInstanceStatusList(validInstanceStatusList);
        return typeDefPatch;
    }

    private void update0021Collections() {
        this.archiveBuilder.addEnumDef(this.getMembershipStatusEnum());
        this.archiveBuilder.addTypeDefPatch(this.updateCollectionMembershipRelationship());
    }

    private EnumDef getMembershipStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(CollectionMemberStatus.getOpenTypeGUID(), CollectionMemberStatus.getOpenTypeName(), CollectionMemberStatus.getOpenTypeDescription(), CollectionMemberStatus.getOpenTypeDescriptionGUID(), CollectionMemberStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (CollectionMemberStatus collectionMemberStatus : CollectionMemberStatus.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(collectionMemberStatus.getOrdinal(), collectionMemberStatus.getName(), collectionMemberStatus.getDescription(), collectionMemberStatus.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!collectionMemberStatus.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private TypeDefPatch updateCollectionMembershipRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MEMBERSHIP_RATIONALE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPRESSION));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.MEMBERSHIP_STATUS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0137ToDos() {
        this.archiveBuilder.addTypeDefPatch(this.updateActionTargetRelationship());
    }

    private TypeDefPatch updateActionTargetRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ACTION_TARGET_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.TO_DO_STATUS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.START_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COMPLETION_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTION_TARGET_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COMPLETION_MESSAGE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0220DataFileCollectionDataSet() {
        this.archiveBuilder.addEntityDef(this.getDataFileCollectionDataSetEntity());
    }

    private EntityDef getDataFileCollectionDataSetEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_FILE_COLLECTION, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName));
    }

    private void add0224TableDataSet() {
        this.archiveBuilder.addEntityDef(this.getTableDataSetEntity());
    }

    private EntityDef getTableDataSetEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TABLE_DATA_SET, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName));
    }

    private void add0239DeployedReportType() {
        this.archiveBuilder.addEntityDef(this.getDeployedReportTypeEntity());
    }

    private EntityDef getDeployedReportTypeEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DEPLOYED_REPORT_TYPE, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.AUTHOR));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.URL));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CREATED_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LAST_MODIFIED_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LAST_MODIFIER));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void update0462GovernanceActionProcesses() {
        this.archiveBuilder.addTypeDefPatch(this.update0462GovernanceActionExecutorRelationship());
    }

    private TypeDefPatch update0462GovernanceActionExecutorRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.GOVERNANCE_ACTION_EXECUTOR_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REQUEST_PARAMETER_FILTER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REQUEST_PARAMETER_MAP));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTION_TARGET_FILTER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTION_TARGET_MAP));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void create0464DynamicIntegrationGroups() {
        this.archiveBuilder.addEntityDef(this.addIntegrationGroupEntity());
        this.archiveBuilder.addEntityDef(this.addIntegrationConnectorEntity());
        this.archiveBuilder.addEntityDef(this.addIntegrationReportEntity());
        this.archiveBuilder.addRelationshipDef(this.addRegisteredIntegrationConnectorRelationship());
        this.archiveBuilder.addRelationshipDef(this.addCatalogTargetRelationship());
        this.archiveBuilder.addRelationshipDef(this.addRelatedIntegrationReportRelationship());
    }

    private EntityDef addIntegrationGroupEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.INTEGRATION_GROUP, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
    }

    private EntityDef addIntegrationConnectorEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.INTEGRATION_CONNECTOR, this.archiveBuilder.getEntityDef(OpenMetadataType.DEPLOYED_CONNECTOR.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USES_BLOCKING_CALLS));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef addIntegrationReportEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.INTEGRATION_REPORT, this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SERVER_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONNECTOR_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONNECTOR_ID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REFRESH_START_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REFRESH_COMPLETION_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CREATED_ELEMENTS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.UPDATED_ELEMENTS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DELETED_ELEMENTS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addRegisteredIntegrationConnectorRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.REGISTERED_INTEGRATION_CONNECTOR_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "includedInIntegrationGroups";
        String end1AttributeDescription = "An integration group that this integration connector is a member of.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.INTEGRATION_GROUP.typeName), "includedInIntegrationGroups", "An integration group that this integration connector is a member of.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "registeredIntegrationConnectors";
        String end2AttributeDescription = "An integration connector that should run as part of the integration group.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.INTEGRATION_CONNECTOR.typeName), "registeredIntegrationConnectors", "An integration connector that should run as part of the integration group.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONNECTOR_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONNECTOR_USER_ID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.METADATA_SOURCE_QUALIFIED_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.START_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REFRESH_TIME_INTERVAL));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STOP_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.GENERATE_INTEGRATION_REPORT));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.PERMITTED_SYNCHRONIZATION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addCatalogTargetRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CATALOG_TARGET_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "cataloguedByConnectors";
        String end1AttributeDescription = "An integration connector managing metadata synchronization.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.INTEGRATION_CONNECTOR.typeName), "cataloguedByConnectors", "An integration connector managing metadata synchronization.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "catalogTargets";
        String end2AttributeDescription = "An open metadata element that the integration connector is working on.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "catalogTargets", "An open metadata element that the integration connector is working on.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CATALOG_TARGET_NAME));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addRelatedIntegrationReportRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.RELATED_INTEGRATION_REPORT, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "anchorSubject";
        String end1AttributeDescription = "The anchor entity that the integration report describes.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "anchorSubject", "The anchor entity that the integration report describes.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "integrationReports";
        String end2AttributeDescription = "A description of the changes made to the anchor entity by an integration report.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.INTEGRATION_REPORT.typeName), "integrationReports", "A description of the changes made to the anchor entity by an integration report.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0545ReferenceData() {
        this.archiveBuilder.addTypeDefPatch(this.updateReferenceValueAssignment());
    }

    private TypeDefPatch updateReferenceValueAssignment() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ATTRIBUTE_NAME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void addFormulaTypeAttribute() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataSet());
        this.archiveBuilder.addTypeDefPatch(this.updateProcess());
        this.archiveBuilder.addTypeDefPatch(this.updateCalculatedValue());
        this.archiveBuilder.addTypeDefPatch(this.updateProcessCall());
        this.archiveBuilder.addTypeDefPatch(this.updateDataFlow());
    }

    private TypeDefPatch updateDataSet() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DATA_SET.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMULA_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateProcess() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PROCESS.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMULA_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCalculatedValue() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMULA_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateProcessCall() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PROCESS_CALL_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMULA_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateDataFlow() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DATA_FLOW_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FORMULA_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0484AgreementActor() {
        this.archiveBuilder.addTypeDefPatch(this.updateAgreementActorRelationship());
    }

    private TypeDefPatch updateAgreementActorRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.AGREEMENT_ACTOR_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private void update0720InformationSupplyChains() {
        this.archiveBuilder.addRelationshipDef(this.getInformationSupplyChainLinkRelationship());
    }

    private RelationshipDef getInformationSupplyChainLinkRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.INFORMATION_SUPPLY_CHAIN_LINK_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "supplyFrom";
        String end1AttributeDescription = "Logical source of the information supply chain.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "supplyFrom", "Logical source of the information supply chain.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "supplyTo";
        String end2AttributeDescription = "Logical destination of an information supply chain.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "supplyTo", "Logical destination of an information supply chain.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }
}

