/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive4_0;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive4_1 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "4.1";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive4_1() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive4_1(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive4_0 previousTypes = new OpenMetadataTypesArchive4_0(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010BasicModel();
        this.update0011ManagingReferenceables();
        this.update0320CategoryHierarchy();
        this.update0385ControlledGlossaryDevelopment();
        this.update0423SecurityAccessControl();
        this.update504ImplementationSnippets();
        this.update0710DigitalServices();
    }

    private void update0010BasicModel() {
        this.archiveBuilder.addRelationshipDef(this.getSampleDataRelationship());
    }

    private RelationshipDef getSampleDataRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SAMPLE_DATA_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "sourceOfSample";
        String end1AttributeDescription = "Represents the resource where the sample was taken from.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "sourceOfSample", "Represents the resource where the sample was taken from.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "sampleData";
        String end2AttributeDescription = "Describes the location of the resource that holds the sample data.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "sampleData", "Describes the location of the resource that holds the sample data.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SAMPLING_METHOD));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0011ManagingReferenceables() {
        this.archiveBuilder.addClassificationDef(this.getTemplateSubstituteClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateSourcedFromRelationship());
    }

    private TypeDefPatch updateSourcedFromRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE_VERSION_NUMBER));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private ClassificationDef getTemplateSubstituteClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.TEMPLATE_SUBSTITUTE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
    }

    private void update0320CategoryHierarchy() {
        this.archiveBuilder.addClassificationDef(this.getRootCategoryClassification());
    }

    private ClassificationDef getRootCategoryClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.ROOT_CATEGORY_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_CATEGORY.typeName), false);
    }

    private void update0385ControlledGlossaryDevelopment() {
        this.archiveBuilder.addClassificationDef(this.getEditingGlossaryClassification());
        this.archiveBuilder.addClassificationDef(this.getStagingGlossaryClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateGlossaryTermEntity());
    }

    private ClassificationDef getEditingGlossaryClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.EDITING_GLOSSARY_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getStagingGlossaryClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.STAGING_GLOSSARY_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private TypeDefPatch updateGlossaryTermEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.GLOSSARY_TERM.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PUBLISH_VERSION_ID));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0423SecurityAccessControl() {
        this.archiveBuilder.addTypeDefPatch(this.updateSecurityTagsClassification());
        this.archiveBuilder.addEntityDef(this.addSecurityAccessControlEntity());
        this.archiveBuilder.addRelationshipDef(this.addAssociatedGroupRelationship());
    }

    private TypeDefPatch updateSecurityTagsClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.SECURITY_TAGS_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACCESS_GROUPS));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private RelationshipDef addAssociatedGroupRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ASSOCIATED_GROUP_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "usedInAccessControls";
        String end1AttributeDescription = "An access control definition that uses the security group.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SECURITY_ACCESS_CONTROL.typeName), "usedInAccessControls", "An access control definition that uses the security group.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "associatedSecurityGroups";
        String end2AttributeDescription = "The security groups to use to validate access for the operation.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SECURITY_GROUP.typeName), "associatedSecurityGroups", "The security groups to use to validate access for the operation.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.OPERATION_NAME));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private EntityDef addSecurityAccessControlEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SECURITY_ACCESS_CONTROL, this.archiveBuilder.getEntityDef(OpenMetadataType.TECHNICAL_CONTROL.typeName));
    }

    private void update504ImplementationSnippets() {
        this.archiveBuilder.addRelationshipDef(this.getAssociatedSnippetRelationship());
    }

    private RelationshipDef getAssociatedSnippetRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ASSOCIATED_SNIPPET_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "snippetRelevantForElements";
        String end1AttributeDescription = "Element describing logical structure for data element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "snippetRelevantForElements", "Element describing logical structure for data element.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "implementationSnippetsForElement";
        String end2AttributeDescription = "Template implementation of the element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.IMPLEMENTATION_SNIPPET.typeName), "implementationSnippetsForElement", "Template implementation of the element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0710DigitalServices() {
        this.archiveBuilder.addTypeDefPatch(this.updateDigitalProductClassification());
    }

    private TypeDefPatch updateDigitalProductClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DIGITAL_PRODUCT_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PRODUCT_STATUS));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

