/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive4_3;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive5_0 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "5.0";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive5_0() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive5_0(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive4_3 previousTypes = new OpenMetadataTypesArchive4_3(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010BaseModel();
        this.update0011UpdateTemplates();
        this.update0021Collections();
        this.update0050ApplicationsAndProcesses();
        this.update0137Actions();
        this.update0130Projects();
        this.update0210DataStores();
        this.update0220DataFiles();
        this.update0221MediaFiles();
        this.add0226ArchiveFiles();
        this.update0280SoftwareArtifacts();
        this.update0380TermInheritance();
        this.update0461GovernanceEngines();
        this.update0464IntegrationGroups();
        this.update0545ReferenceData();
        this.update0462GovernanceActionTypes();
        this.add00475ContextEvents();
        this.add0603SurveyReports();
        this.update0690RequestForAction();
        this.add0755UltimateSourcesDestinations();
    }

    private void update0010BaseModel() {
        this.archiveBuilder.addTypeDefPatch(this.updateAnchors());
    }

    private TypeDefPatch updateAnchors() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ANCHORS_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ANCHOR_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ANCHOR_DOMAIN_NAME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0021Collections() {
        this.archiveBuilder.addTypeDefPatch(this.updateCollection());
        this.archiveBuilder.addClassificationDef(this.getRootCollectionClassification());
        this.archiveBuilder.addClassificationDef(this.getHomeCollectionClassification());
        this.archiveBuilder.addClassificationDef(this.getRecentAccessClassification());
        this.archiveBuilder.addClassificationDef(this.getWorkItemListClassification());
    }

    private TypeDefPatch updateCollection() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.COLLECTION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COLLECTION_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private ClassificationDef getRootCollectionClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.ROOT_COLLECTION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName), false);
    }

    private ClassificationDef getHomeCollectionClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.HOME_COLLECTION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName), false);
    }

    private ClassificationDef getRecentAccessClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.RECENT_ACCESS, null, this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName), false);
    }

    private ClassificationDef getWorkItemListClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.WORK_ITEM_LIST, null, this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName), false);
    }

    private void update0050ApplicationsAndProcesses() {
        this.archiveBuilder.addEntityDef(this.addEventManagerEntity());
        this.archiveBuilder.addEntityDef(this.addAuthorizationManagerEntity());
        this.archiveBuilder.addEntityDef(this.addUserAuthenticationManagerEntity());
    }

    private EntityDef addEventManagerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EVENT_MANAGER, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
    }

    private EntityDef addAuthorizationManagerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.AUTHORIZATION_MANAGER, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
    }

    private EntityDef addUserAuthenticationManagerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.USER_AUTHENTICATION_MANAGER, this.archiveBuilder.getEntityDef(OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName));
    }

    private void update0137Actions() {
        this.archiveBuilder.addEntityDef(this.addActionEntity());
        this.archiveBuilder.addRelationshipDef(this.getActionsRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateToDoEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateEngineActionEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateActionSponsorRelationship());
    }

    private EntityDef addActionEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ACTION, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
    }

    private RelationshipDef getActionsRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ACTIONS_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "actionCause";
        String end1AttributeDescription = "The reason that the action is required.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "actionCause", "The reason that the action is required.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "relatedActions";
        String end2AttributeDescription = "Actions related to this element.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTION.typeName), "relatedActions", "Actions related to this element.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch updateToDoEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.TO_DO.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LAST_REVIEW_TIME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateEngineActionEntity() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ENGINE_ACTION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTION.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REQUESTER_USER_ID));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REQUESTED_START_DATE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateActionSponsorRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ACTION_SPONSOR_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "actionSponsor";
        String end1AttributeDescription = "Element such as person, team, rule, incident, project, that is driving the need for the action.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "actionSponsor", "Element such as person, team, rule, incident, project, that is driving the need for the action.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2AttributeName = "trackedActions";
        String end2AttributeDescription = "Actions that need to be completed.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTION.typeName), "trackedActions", "Actions that need to be completed.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0130Projects() {
        this.archiveBuilder.addTypeDefPatch(this.updateProject());
        this.archiveBuilder.addClassificationDef(this.getPersonalProjectClassification());
        this.archiveBuilder.addClassificationDef(this.getStudyProjectClassification());
    }

    private TypeDefPatch updateProject() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PROJECT.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROJECT_HEALTH));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PRIORITY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROJECT_PHASE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private ClassificationDef getPersonalProjectClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.PERSONAL_PROJECT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT.typeName), false);
    }

    private ClassificationDef getStudyProjectClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.STUDY_PROJECT_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.PROJECT.typeName), false);
    }

    private void update0011UpdateTemplates() {
        this.archiveBuilder.addRelationshipDef(this.addCatalogTemplateRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateTemplateClassification());
    }

    private RelationshipDef addCatalogTemplateRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "implementationTypes";
        String end1AttributeDescription = "Description of a type of technology.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "implementationTypes", "Description of a type of technology.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "templatesForCataloguing";
        String end2AttributeDescription = "Template element for a new catalog entry.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "templatesForCataloguing", "Template element for a new catalog entry.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch updateTemplateClassification() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.VERSION_IDENTIFIER));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0210DataStores() {
        this.archiveBuilder.addClassificationDef(this.getDataScopeClassification());
    }

    private ClassificationDef getDataScopeClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.DATA_SCOPE_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MIN_LONGITUDE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MIN_LATITUDE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MAX_LONGITUDE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MAX_LATITUDE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MIN_HEIGHT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.MAX_HEIGHT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DATA_COLLECTION_START_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DATA_COLLECTION_END_TIME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0220DataFiles() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataFile());
        this.archiveBuilder.addEntityDef(this.addXMLFileEntity());
        this.archiveBuilder.addEntityDef(this.addSpreadsheetFileEntity());
    }

    private TypeDefPatch updateDataFile() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DATA_FILE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.FILE_EXTENSION));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private EntityDef addSpreadsheetFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SPREADSHEET_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
    }

    private EntityDef addXMLFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.XML_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
    }

    private void update0221MediaFiles() {
        this.archiveBuilder.addEntityDef(this.addAudioFileEntity());
        this.archiveBuilder.addEntityDef(this.addVideoFileEntity());
        this.archiveBuilder.addEntityDef(this.add3DImageFileEntity());
        this.archiveBuilder.addEntityDef(this.addRasterFileEntity());
        this.archiveBuilder.addEntityDef(this.addVectorFileEntity());
    }

    private EntityDef addAudioFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.AUDIO_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName));
    }

    private EntityDef addVideoFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.VIDEO_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName));
    }

    private EntityDef add3DImageFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.THREE_D_IMAGE_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName));
    }

    private EntityDef addRasterFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RASTER_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName));
    }

    private EntityDef addVectorFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.VECTOR_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName));
    }

    private void add0226ArchiveFiles() {
        this.archiveBuilder.addEntityDef(this.addArchiveFileEntity());
        this.archiveBuilder.addRelationshipDef(this.addArchiveContentsRelationship());
    }

    private EntityDef addArchiveFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ARCHIVE_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
    }

    private RelationshipDef addArchiveContentsRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ARCHIVE_CONTENTS_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "packagedInArchiveFiles";
        String end1AttributeDescription = "Associated archive file.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ARCHIVE_FILE.typeName), "packagedInArchiveFiles", "Associated archive file.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "archiveFileContents";
        String end2AttributeDescription = "Collection describing the archive's contents.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName), "archiveFileContents", "Collection describing the archive's contents.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0280SoftwareArtifacts() {
        this.archiveBuilder.addEntityDef(this.addSourceCodeFileEntity());
        this.archiveBuilder.addEntityDef(this.addBuildInstructionFileEntity());
        this.archiveBuilder.addEntityDef(this.addExecutableFileEntity());
        this.archiveBuilder.addEntityDef(this.addScriptFileEntity());
        this.archiveBuilder.addEntityDef(this.addPropertiesFileEntity());
        this.archiveBuilder.addEntityDef(this.addYAMLFileEntity());
    }

    private EntityDef addSourceCodeFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SOURCE_CODE_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
    }

    private EntityDef addBuildInstructionFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.BUILD_INSTRUCTION_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
    }

    private EntityDef addExecutableFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.EXECUTABLE_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
    }

    private EntityDef addScriptFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SCRIPT_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
    }

    private EntityDef addPropertiesFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.PROPERTIES_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName));
    }

    private EntityDef addYAMLFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.YAML_FILE, this.archiveBuilder.getEntityDef(OpenMetadataType.PROPERTIES_FILE.typeName));
    }

    private void update0380TermInheritance() {
        this.archiveBuilder.addRelationshipDef(this.addTermISATYPEOFRelationship());
    }

    private RelationshipDef addTermISATYPEOFRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TERM_IS_A_TYPE_OF_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "inherited";
        String end1AttributeDescription = "Inherited (Subtypes) for this object.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "inherited", "Inherited (Subtypes) for this object.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "inheritedFrom";
        String end2AttributeDescription = "Inherited from type (Supertypes) for this object.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GLOSSARY_TERM.typeName), "inheritedFrom", "Inherited from type (Supertypes) for this object.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.STATUS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0461GovernanceEngines() {
        this.archiveBuilder.addEntityDef(this.getSurveyActionEngineEntity());
        this.archiveBuilder.addEntityDef(this.getSurveyActionServiceEntity());
    }

    private EntityDef getSurveyActionEngineEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SURVEY_ACTION_ENGINE, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ENGINE.typeName));
    }

    private EntityDef getSurveyActionServiceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SURVEY_ACTION_SERVICE, this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_SERVICE.typeName));
    }

    private void update0464IntegrationGroups() {
        this.archiveBuilder.addTypeDefPatch(this.updateCatalogTarget());
    }

    private TypeDefPatch updateCatalogTarget() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CATALOG_TARGET_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.TEMPLATES));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONNECTION_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.METADATA_SOURCE_QUALIFIED_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIGURATION_PROPERTIES));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add00475ContextEvents() {
        this.archiveBuilder.addEntityDef(this.addContextEventEntity());
        this.archiveBuilder.addRelationshipDef(this.addContextEventEvidenceRelationship());
        this.archiveBuilder.addRelationshipDef(this.addContextEventForTimelineEffectsRelationship());
        this.archiveBuilder.addRelationshipDef(this.addContextEventImpactRelationship());
        this.archiveBuilder.addRelationshipDef(this.addDependentContextEventRelationship());
        this.archiveBuilder.addRelationshipDef(this.addRelatedContextEventRelationship());
        this.archiveBuilder.addClassificationDef(this.getContextEventCollectionClassification());
    }

    private EntityDef addContextEventEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CONTEXT_EVENT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EVENT_EFFECT));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONTEXT_EVENT_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PLANNED_START_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTUAL_START_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PLANNED_DURATION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTUAL_DURATION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REPEAT_INTERVAL));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PLANNED_COMPLETION_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTUAL_COMPLETION_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REFERENCE_EFFECTIVE_FROM));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REFERENCE_EFFECTIVE_TO));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addContextEventEvidenceRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONTEXT_EVENT_EVIDENCE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "relatedToContextEvents";
        String end1AttributeDescription = "Description of a related event.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONTEXT_EVENT.typeName), "relatedToContextEvents", "Description of a related event.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "contextEventEvidence";
        String end2AttributeDescription = "Descriptions of notifications, incidents and other indications that the context event is underway.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "contextEventEvidence", "Descriptions of notifications, incidents and other indications that the context event is underway.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef addContextEventForTimelineEffectsRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONTEXT_EVENT_FOR_TIMELINE_EFFECTS_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "eventEffectedResources";
        String end1AttributeDescription = "Entities whose data is impacted by the context event.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "eventEffectedResources", "Entities whose data is impacted by the context event.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "associatedEventForTimelines";
        String end2AttributeDescription = "Descriptions of events that have impacted this resource.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONTEXT_EVENT.typeName), "associatedEventForTimelines", "Descriptions of events that have impacted this resource.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef addContextEventImpactRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONTEXT_EVENT_IMPACT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "eventImpacts";
        String end1AttributeDescription = "Resources impacted by the context event.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "eventImpacts", "Resources impacted by the context event.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "impactedByContextEvents";
        String end2AttributeDescription = "Descriptions of context events affecting this resource and the action taken.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONTEXT_EVENT.typeName), "impactedByContextEvents", "Descriptions of context events affecting this resource and the action taken.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SEVERITY_LEVEL_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getContextEventCollectionClassification() {
        return this.archiveHelper.getClassificationDef(OpenMetadataType.CONTEXT_EVENT_COLLECTION_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.COLLECTION.typeName), false);
    }

    private RelationshipDef addDependentContextEventRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DEPENDENT_CONTEXT_EVENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "parentContextEvents";
        String end1AttributeDescription = "Context event that is driving the child context events.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONTEXT_EVENT.typeName), "parentContextEvents", "Context event that is driving the child context events.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "childContextEvents";
        String end2AttributeDescription = "Subsequent context events created to help manage the parent context events.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONTEXT_EVENT.typeName), "childContextEvents", "Subsequent context events created to help manage the parent context events.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addRelatedContextEventRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.RELATED_CONTEXT_EVENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "relatedContextEvents";
        String end1AttributeDescription = "Context event that is affecting the other context event.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONTEXT_EVENT.typeName), "relatedContextEvents", "Context event that is affecting the other context event.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "relatedContextEvents";
        String end2AttributeDescription = "Context event that is affecting the other context event.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONTEXT_EVENT.typeName), "relatedContextEvents", "Context event that is affecting the other context event.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STATUS_IDENTIFIER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CONFIDENCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_TYPE_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.STEWARD_PROPERTY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SOURCE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NOTES));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0545ReferenceData() {
        this.archiveBuilder.addTypeDefPatch(this.updateValidValueDefinition());
        this.archiveBuilder.addTypeDefPatch(this.updateValidValuesImplementation());
        this.archiveBuilder.addRelationshipDef(this.getConsistentValidValuesRelationship());
        this.archiveBuilder.addRelationshipDef(this.getValidValueAssociationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSpecificationPropertyAssignmentRelationship());
    }

    private TypeDefPatch updateValidValueDefinition() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.VALID_VALUE_DEFINITION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.CATEGORY));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IS_CASE_SENSITIVE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DATA_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateValidValuesImplementation() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1AttributeName = "validValueImplementations";
        String end1AttributeDescription = "The location where mapped value is stored.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "validValueImplementations", "The location where mapped value is stored.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        typeDefPatch.setEndDef1(relationshipEndDef);
        return typeDefPatch;
    }

    private RelationshipDef getConsistentValidValuesRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONSISTENT_VALID_VALUES_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "consistentValue";
        String end1AttributeDescription = "Valid value for another valid value set (property) that is consistent with this value.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.VALID_VALUE_DEFINITION.typeName), "consistentValue", "Valid value for another valid value set (property) that is consistent with this value.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "consistentValue";
        String end2AttributeDescription = "Valid value for another valid value set (property) that is consistent with this value.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.VALID_VALUE_DEFINITION.typeName), "consistentValue", "Valid value for another valid value set (property) that is consistent with this value.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getValidValueAssociationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.VALID_VALUE_ASSOCIATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "associatedValues1";
        String end1AttributeDescription = "Valid value at end one of this association.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.VALID_VALUE_DEFINITION.typeName), "associatedValues1", "Valid value at end one of this association.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "associatedValues2";
        String end2AttributeDescription = "Valid value at end two of this association.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.VALID_VALUE_DEFINITION.typeName), "associatedValues2", "Valid value at end two of this association.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ASSOCIATION_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ASSOCIATION_TYPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ADDITIONAL_PROPERTIES));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getSpecificationPropertyAssignmentRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "implementingItem";
        String end1AttributeDescription = "Connector or template, or similar implementation.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "implementingItem", "Connector or template, or similar implementation.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "specificationProperty";
        String end2AttributeDescription = "Valid value representing a property type that controls its behaviour.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.VALID_VALUE_DEFINITION.typeName), "specificationProperty", "Valid value representing a property type that controls its behaviour.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PROPERTY_TYPE));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0462GovernanceActionTypes() {
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceActionType());
    }

    private TypeDefPatch updateGovernanceActionType() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.GOVERNANCE_ACTION_TYPE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PRODUCED_GUARDS));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0603SurveyReports() {
        this.archiveBuilder.addEntityDef(this.addSurveyReportEntity());
        this.archiveBuilder.addRelationshipDef(this.addAssetSurveyReportRelationship());
        this.archiveBuilder.addRelationshipDef(this.addEngineActionSurveyReportRelationship());
        this.archiveBuilder.addRelationshipDef(this.getReportedAnnotationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAssociatedAnnotationRelationship());
    }

    private EntityDef addSurveyReportEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SURVEY_REPORT, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DISPLAY_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.PURPOSE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.USER));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ANALYSIS_PARAMETERS));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ANALYSIS_STEP));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.START_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COMPLETION_DATE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.COMPLETION_MESSAGE));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef addAssetSurveyReportRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "surveyReportTarget";
        String end1AttributeDescription = "The asset describing the resource that was surveyed.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), "surveyReportTarget", "The asset describing the resource that was surveyed.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "surveyReports";
        String end2AttributeDescription = "Survey reports for the asset.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SURVEY_REPORT.typeName), "surveyReports", "Survey reports for the asset.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef addEngineActionSurveyReportRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ENGINE_ACTION_SURVEY_REPORT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "engineAction";
        String end1AttributeDescription = "The engine action controlling the survey action service invocation.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ENGINE_ACTION.typeName), "engineAction", "The engine action controlling the survey action service invocation.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "surveyReport";
        String end2AttributeDescription = "Survey report generated form the execution of the survey action service.  Typically only one unless failures occurred.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SURVEY_REPORT.typeName), "surveyReport", "Survey report generated form the execution of the survey action service.  Typically only one unless failures occurred.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getReportedAnnotationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "fromSurveyReport";
        String end1AttributeDescription = "The report that the annotations belong to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.SURVEY_REPORT.typeName), "fromSurveyReport", "The report that the annotations belong to.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "reportedAnnotations";
        String end2AttributeDescription = "The annotations providing the contents for the report.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ANNOTATION.typeName), "reportedAnnotations", "The annotations providing the contents for the report.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAssociatedAnnotationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "annotationSubject";
        String end1AttributeDescription = "The element described in the annotation.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "annotationSubject", "The element described in the annotation.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "associatedAnnotations";
        String end2AttributeDescription = "The annotations describing the element or its real-world counterpart.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ANNOTATION.typeName), "associatedAnnotations", "The annotations describing the element or its real-world counterpart.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0690RequestForAction() {
        this.archiveBuilder.addRelationshipDef(this.getRequestForActionTargetRelationship());
    }

    private RelationshipDef getRequestForActionTargetRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.REQUEST_FOR_ACTION_TARGET, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "identifiedInRequestForActions";
        String end1AttributeDescription = "Request for action that originated the action.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.typeName), "identifiedInRequestForActions", "Request for action that originated the action.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "requestForActionTargets";
        String end2AttributeDescription = "Elements that originated the data.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "requestForActionTargets", "Elements that originated the data.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTION_TARGET_NAME));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0755UltimateSourcesDestinations() {
        this.archiveBuilder.addRelationshipDef(this.getUltimateSourceRelationship());
        this.archiveBuilder.addRelationshipDef(this.getUltimateDestinationRelationship());
    }

    private RelationshipDef getUltimateSourceRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ULTIMATE_SOURCE, null, ClassificationPropagationRule.NONE);
        relationshipDef.setMultiLink(true);
        String end1AttributeName = "downstreamFromLineageSource";
        String end1AttributeDescription = "Elements that receives data from the ultimate source (via other processing).";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "downstreamFromLineageSource", "Elements that receives data from the ultimate source (via other processing).", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "ultimateSources";
        String end2AttributeDescription = "Elements that originated the data.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "ultimateSources", "Elements that originated the data.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ISC_QUALIFIED_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.HOPS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getUltimateDestinationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ULTIMATE_DESTINATION, null, ClassificationPropagationRule.NONE);
        relationshipDef.setMultiLink(true);
        String end1AttributeName = "upstreamFromLineageDestination";
        String end1AttributeDescription = "Elements that sends data from the ultimate destination (via other processing).";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "upstreamFromLineageDestination", "Elements that sends data from the ultimate destination (via other processing).", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "ultimateDestinations";
        String end2AttributeDescription = "Elements that ultimately receive the data.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), "ultimateDestinations", "Elements that ultimately receive the data.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ISC_QUALIFIED_NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.HOPS));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }
}

