/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DeleteMethod;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive5_0;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive5_1 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "5.1-SNAPSHOT";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive5_1() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive5_1(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive5_0 previousTypes = new OpenMetadataTypesArchive5_0(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010Base();
        this.update0201Connections();
        this.update0210DataStores();
        this.update0235InformationView();
        this.update0462GovernanceActionProcesses();
        this.update0464IntegrationGroups();
    }

    private void update0010Base() {
        this.archiveBuilder.addTypeDefPatch(this.updateAsset());
    }

    private TypeDefPatch updateAsset() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ASSET.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.RESOURCE_NAME));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0201Connections() {
        this.archiveBuilder.addTypeDefPatch(this.updateConnectorType());
    }

    private TypeDefPatch updateConnectorType() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CONNECTOR_TYPE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SUPPORTED_DEPLOYED_IMPLEMENTATION_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0210DataStores() {
        this.archiveBuilder.addClassificationDef(this.getDataAssetEncodingClassification());
    }

    private ClassificationDef getDataAssetEncodingClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.DATA_ASSET_ENCODING_CLASSIFICATION, null, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_ASSET.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENCODING));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENCODING_LANGUAGE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENCODING_DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ENCODING_PROPERTIES));
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0235InformationView() {
        this.archiveBuilder.addEntityDef(this.getVirtualRelationalTableEntity());
    }

    private EntityDef getVirtualRelationalTableEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.VIRTUAL_RELATIONAL_TABLE, this.archiveBuilder.getEntityDef(OpenMetadataType.INFORMATION_VIEW.typeName));
    }

    private void update0462GovernanceActionProcesses() {
        this.archiveBuilder.addEntityDef(this.getGovernanceActionProcessInstanceEntity());
        this.archiveBuilder.addRelationshipDef(this.getTargetForActionType());
        this.archiveBuilder.addRelationshipDef(this.getTargetForActionProcess());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceActionProcessFlow());
    }

    private EntityDef getGovernanceActionProcessInstanceEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_INSTANCE, this.archiveBuilder.getEntityDef(OpenMetadataType.TRANSIENT_EMBEDDED_PROCESS.typeName));
    }

    private RelationshipDef getTargetForActionType() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TARGET_FOR_ACTION_TYPE_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "associatedGovernanceActionType";
        String end1AttributeDescription = "Describes the governance action that will use this target for action.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ACTION_TYPE.typeName), "associatedGovernanceActionType", "Describes the governance action that will use this target for action.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "predefinedTargetForAction";
        String end2AttributeDescription = "Provides a fixed target for action that will be used when this governance action executes.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "predefinedTargetForAction", "Provides a fixed target for action that will be used when this governance action executes.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTION_TARGET_NAME));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getTargetForActionProcess() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TARGET_FOR_ACTION_PROCESS_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "associatedGovernanceActionProcess";
        String end1AttributeDescription = "Describes the governance action that will use this target for action.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.GOVERNANCE_ACTION_PROCESS.typeName), "associatedGovernanceActionProcess", "Describes the governance action that will use this target for action.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "predefinedTargetForAction";
        String end2AttributeDescription = "Provides a fixed target for action that will be used when this governance action executes.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.OPEN_METADATA_ROOT.typeName), "predefinedTargetForAction", "Provides a fixed target for action that will be used when this governance action executes.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.ACTION_TARGET_NAME));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private TypeDefPatch updateGovernanceActionProcessFlow() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.GOVERNANCE_ACTION_PROCESS_FLOW_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.REQUEST_PARAMETERS));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0464IntegrationGroups() {
        this.archiveBuilder.addEnumDef(this.getDeleteMethodEnum());
        this.archiveBuilder.addTypeDefPatch(this.updateCatalogTarget());
    }

    private EnumDef getDeleteMethodEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(DeleteMethod.getOpenTypeGUID(), DeleteMethod.getOpenTypeName(), DeleteMethod.getOpenTypeDescription(), DeleteMethod.getOpenTypeDescriptionGUID(), DeleteMethod.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (DeleteMethod deleteMethod : DeleteMethod.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(deleteMethod.getOrdinal(), deleteMethod.getName(), deleteMethod.getDescription(), deleteMethod.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!deleteMethod.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private TypeDefPatch updateCatalogTarget() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CATALOG_TARGET_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.PERMITTED_SYNCHRONIZATION));
        properties.add(this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.DELETE_METHOD));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

