/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive5_1;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive5_2 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "5.1";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive5_2() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive5_2(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive5_1 previousTypes = new OpenMetadataTypesArchive5_1(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0050ApplicationsAndProcesses();
        this.add0265AnalyticsAssets();
        this.add0118ActorRoles();
        this.addLabelToLineage();
    }

    private void update0050ApplicationsAndProcesses() {
        this.archiveBuilder.addEntityDef(this.addDataAccessManagerEntity());
    }

    private EntityDef addDataAccessManagerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_ACCESS_MANAGER, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_MANAGER.typeName));
    }

    private void add0118ActorRoles() {
        this.archiveBuilder.addEntityDef(this.getActorRoleEntity());
        this.archiveBuilder.addTypeDefPatch(this.updatePersonRole());
        this.archiveBuilder.addEntityDef(this.getTeamRoleEntity());
        this.archiveBuilder.addEntityDef(this.getITProfileRoleEntity());
        this.archiveBuilder.addTypeDefPatch(this.updatePersonRoleAppointmentRelationship());
        this.archiveBuilder.addRelationshipDef(this.getTeamRoleAppointmentRelationship());
        this.archiveBuilder.addRelationshipDef(this.getITProfileRoleRelationship());
        this.archiveBuilder.addRelationshipDef(this.getContributionRelationship());
    }

    private EntityDef getActorRoleEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ACTOR_ROLE, this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.NAME));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DESCRIPTION));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.SCOPE));
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.IDENTIFIER));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private TypeDefPatch updatePersonRole() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PERSON_ROLE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR_ROLE.typeName));
        return typeDefPatch;
    }

    private EntityDef getTeamRoleEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TEAM_ROLE, this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR_ROLE.typeName));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.HEAD_COUNT));
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getITProfileRoleEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.IT_PROFILE_ROLE, this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR_ROLE.typeName));
    }

    private TypeDefPatch updatePersonRoleAppointmentRelationship() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PERSON_ROLE_APPOINTMENT_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPECTED_TIME_ALLOCATION_PERCENT));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private RelationshipDef getTeamRoleAppointmentRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TEAM_ROLE_APPOINTMENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "rolePerformers";
        String end1AttributeDescription = "The teams performing this role.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TEAM.typeName), "rolePerformers", "The teams performing this role.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        String end2AttributeName = "performsRoles";
        String end2AttributeDescription = "Roles performed by this team.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.TEAM_ROLE.typeName), "performsRoles", "Roles performed by this team.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.EXPECTED_TIME_ALLOCATION_PERCENT));
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getITProfileRoleRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.IT_PROFILE_ROLE_APPOINTMENT_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "rolePerformers";
        String end1AttributeDescription = "The automated software executables performing this role.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.IT_PROFILE.typeName), "rolePerformers", "The automated software executables performing this role.", end1AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef2(relationshipEndDef);
        String end2AttributeName = "performsRoles";
        String end2AttributeDescription = "Roles performed by this software executable.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.IT_PROFILE_ROLE.typeName), "performsRoles", "Roles performed by this software executable.", end2AttributeDescriptionGUID, RelationshipEndCardinality.ANY_NUMBER);
        relationshipDef.setEndDef1(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getContributionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONTRIBUTION_RELATIONSHIP, null, ClassificationPropagationRule.NONE);
        String end1AttributeName = "contributorProfile";
        String end1AttributeDescription = "The actor profile associated via userId to the contribution.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.ACTOR_PROFILE.typeName), "contributorProfile", "The actor profile associated via userId to the contribution.", end1AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2AttributeName = "profileContributionRecord";
        String end2AttributeDescription = "The record of activity by this actor profile.";
        String end2AttributeDescriptionGUID = null;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(OpenMetadataType.CONTRIBUTION_RECORD.typeName), "profileContributionRecord", "The record of activity by this actor profile.", end2AttributeDescriptionGUID, RelationshipEndCardinality.AT_MOST_ONE);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0265AnalyticsAssets() {
        this.archiveBuilder.addEntityDef(this.getDeployedAnalyticsModelEntity());
        this.archiveBuilder.addEntityDef(this.getAnalyticsModelRunEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateTransientEmbeddedProcess());
    }

    private EntityDef getDeployedAnalyticsModelEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DEPLOYED_ANALYTICS_MODEL, this.archiveBuilder.getEntityDef(OpenMetadataType.DEPLOYED_SOFTWARE_COMPONENT.typeName));
    }

    private EntityDef getAnalyticsModelRunEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.ANALYTICS_MODEL_RUN, this.archiveBuilder.getEntityDef(OpenMetadataType.TRANSIENT_EMBEDDED_PROCESS.typeName));
    }

    private TypeDefPatch updateTransientEmbeddedProcess() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.TRANSIENT_EMBEDDED_PROCESS.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void addLabelToLineage() {
        this.archiveBuilder.addTypeDefPatch(this.updateProcessCall());
        this.archiveBuilder.addTypeDefPatch(this.updateDataFlow());
        this.archiveBuilder.addTypeDefPatch(this.updateControlFlow());
        this.archiveBuilder.addTypeDefPatch(this.updateUltimateSource());
        this.archiveBuilder.addTypeDefPatch(this.updateUltimateDestination());
        this.archiveBuilder.addTypeDefPatch(this.updateLineageMapping());
    }

    private TypeDefPatch updateProcessCall() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.PROCESS_CALL_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LABEL));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateDataFlow() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.DATA_FLOW_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LABEL));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateControlFlow() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CONTROL_FLOW_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LABEL));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateUltimateSource() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ULTIMATE_SOURCE.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LABEL));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateUltimateDestination() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.ULTIMATE_DESTINATION.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LABEL));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateLineageMapping() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.LINEAGE_MAPPING_RELATIONSHIP.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        properties.add(this.archiveHelper.getTypeDefAttribute(OpenMetadataProperty.LABEL));
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

