/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveTypeStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;

public class OpenMetadataTypesArchiveAccessor {
    private final Map<String, TypeDef> typeDefsByName = new HashMap<String, TypeDef>();
    private final Map<String, TypeDef> typeDefsByGUID = new HashMap<String, TypeDef>();
    private final Map<String, EntityDef> entityDefsByName = new HashMap<String, EntityDef>();
    private final Map<String, EntityDef> entityDefsByGUID = new HashMap<String, EntityDef>();
    private final Map<String, ClassificationDef> classificationDefs = new HashMap<String, ClassificationDef>();
    private final Map<String, RelationshipDef> relationshipDefsByName = new HashMap<String, RelationshipDef>();
    private final Map<String, RelationshipDef> relationshipDefsByGUID = new HashMap<String, RelationshipDef>();
    private final Map<String, EnumDef> enumDefs = new HashMap<String, EnumDef>();
    private static OpenMetadataTypesArchiveAccessor instance = null;

    public static synchronized OpenMetadataTypesArchiveAccessor getInstance() {
        if (instance == null) {
            instance = new OpenMetadataTypesArchiveAccessor(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        }
        return instance;
    }

    public OpenMetadataTypesArchiveAccessor(OpenMetadataArchive openMetadataArchive) {
        OpenMetadataArchiveTypeStore typeStore = openMetadataArchive.getArchiveTypeStore();
        for (TypeDef typeDef : typeStore.getNewTypeDefs()) {
            this.typeDefsByName.put(typeDef.getName(), typeDef);
            this.typeDefsByGUID.put(typeDef.getGUID(), typeDef);
            switch (typeDef.getCategory()) {
                case ENTITY_DEF: {
                    this.entityDefsByName.put(typeDef.getName(), (EntityDef)typeDef);
                    this.entityDefsByGUID.put(typeDef.getGUID(), (EntityDef)typeDef);
                    break;
                }
                case CLASSIFICATION_DEF: {
                    this.classificationDefs.put(typeDef.getName(), (ClassificationDef)typeDef);
                    break;
                }
                case RELATIONSHIP_DEF: {
                    this.relationshipDefsByName.put(typeDef.getName(), (RelationshipDef)typeDef);
                    this.relationshipDefsByGUID.put(typeDef.getGUID(), (RelationshipDef)typeDef);
                }
            }
        }
        for (AttributeTypeDef attributeTypeDef : typeStore.getAttributeTypeDefs()) {
            switch (attributeTypeDef.getCategory()) {
                case ENUM_DEF: {
                    this.enumDefs.put(attributeTypeDef.getName(), (EnumDef)attributeTypeDef);
                    break;
                }
                case PRIMITIVE: {
                    break;
                }
            }
        }
    }

    public TypeDef getTypeDefByName(String typeName) {
        return this.typeDefsByName.get(typeName);
    }

    public TypeDef getTypeDefByGUID(String typeGUID) {
        return this.typeDefsByGUID.get(typeGUID);
    }

    public EntityDef getEntityDefByName(String typeName) {
        return this.entityDefsByName.get(typeName);
    }

    public EntityDef getEntityDefByGuid(String typeGuid) {
        return this.entityDefsByGUID.get(typeGuid);
    }

    public RelationshipDef getRelationshipDefByName(String typeName) {
        return this.relationshipDefsByName.get(typeName);
    }

    public RelationshipDef getRelationshipDefByGuid(String typeGuid) {
        return this.relationshipDefsByGUID.get(typeGuid);
    }

    public ClassificationDef getClassificationDefByName(String typeName) {
        return this.classificationDefs.get(typeName);
    }

    public EnumDef getEnumDefByName(String typeName) {
        return this.enumDefs.get(typeName);
    }

    public InstanceType createTemplateFromTypeDef(TypeDef typeDef) {
        InstanceType template = new InstanceType();
        template.setHeaderVersion(1L);
        template.setTypeDefName(typeDef.getName());
        template.setTypeDefCategory(typeDef.getCategory());
        template.setTypeDefGUID(typeDef.getGUID());
        template.setTypeDefVersion(typeDef.getVersion());
        return template;
    }
}

