/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.auditlog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogReport;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogDestinationsReport;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OMRSAuditLogReport
extends AuditLogReport {
    private static final long serialVersionUID = 1L;
    private Map<String, String> originatorProperties = null;
    private OMRSAuditLogDestinationsReport destinationsReport = null;

    public OMRSAuditLogReport() {
    }

    public OMRSAuditLogReport(AuditLogReport template) {
        super(template);
    }

    public OMRSAuditLogReport(OMRSAuditLogReport template) {
        super(template);
        if (template != null) {
            this.originatorProperties = template.getOriginatorProperties();
            this.destinationsReport = template.getDestinationsReport();
        }
    }

    public Map<String, String> getOriginatorProperties() {
        return this.originatorProperties;
    }

    public void setOriginatorProperties(Map<String, String> originatorProperties) {
        this.originatorProperties = originatorProperties;
    }

    public OMRSAuditLogDestinationsReport getDestinationsReport() {
        return this.destinationsReport;
    }

    public void setDestinationsReport(OMRSAuditLogDestinationsReport destinationsReport) {
        this.destinationsReport = destinationsReport;
    }

    @Override
    public String toString() {
        return "OMRSAuditLogReport{originatorProperties=" + String.valueOf(this.originatorProperties) + ", destinationsReport=" + String.valueOf(this.destinationsReport) + ", reportingComponent=" + String.valueOf(this.getReportingComponent()) + ", childAuditLogReports=" + String.valueOf(this.getChildAuditLogReports()) + ", severityIdentification=" + String.valueOf(this.getSeverityIdentification()) + ", severityCount=" + String.valueOf(this.getSeverityCount()) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OMRSAuditLogReport report = (OMRSAuditLogReport)objectToCompare;
        return Objects.equals(this.originatorProperties, report.originatorProperties) && Objects.equals(this.destinationsReport, report.destinationsReport);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.originatorProperties, this.destinationsReport);
    }
}

