/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.omrstopic;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicRepositoryEventListener;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;

public class OMRSTopicListenerWrapper
implements OMRSTopicListener {
    private final String THREAD_NAME_DESCRIPTION = " OMRSTopicListener";
    private OMRSTopicListener fullListener;
    private OMRSTopicRepositoryEventListener repositoryListener;
    private final AuditLog auditLog;
    private String serviceName = "<Unknown Service>";

    OMRSTopicListenerWrapper(OMRSTopicListener fullListener, String serviceName, AuditLog auditLog) {
        this.fullListener = fullListener;
        this.repositoryListener = fullListener;
        this.serviceName = serviceName;
        this.auditLog = auditLog;
    }

    OMRSTopicListenerWrapper(OMRSTopicRepositoryEventListener repositoryEventListener, String serviceName, AuditLog auditLog) {
        this.repositoryListener = repositoryEventListener;
        this.serviceName = serviceName;
        this.auditLog = auditLog;
    }

    @Deprecated
    OMRSTopicListenerWrapper(OMRSTopicListener fullListener, AuditLog auditLog) {
        this.fullListener = fullListener;
        this.auditLog = auditLog;
    }

    private void logUnhandledException(Exception error, String methodName) {
        this.auditLog.logException(methodName, OMRSAuditCode.UNHANDLED_EXCEPTION_FROM_SERVICE_LISTENER.getMessageDefinition(this.serviceName, error.getClass().getName(), error.getMessage()), error);
    }

    @Override
    public void processRegistryEvent(OMRSRegistryEvent event) {
        String methodName = "processRegistryEvent";
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.serviceName + " OMRSTopicListener");
        try {
            this.fullListener.processRegistryEvent(event);
        }
        catch (Exception error) {
            this.logUnhandledException(error, "processRegistryEvent");
        }
        Thread.currentThread().setName(currentThreadName);
    }

    @Override
    public void processTypeDefEvent(OMRSTypeDefEvent event) {
        String methodName = "processTypeDefEvent";
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.serviceName + " OMRSTopicListener");
        try {
            this.repositoryListener.processTypeDefEvent(event);
        }
        catch (Exception error) {
            this.logUnhandledException(error, "processTypeDefEvent");
        }
        Thread.currentThread().setName(currentThreadName);
    }

    @Override
    public void processInstanceEvent(OMRSInstanceEvent event) {
        String methodName = "processInstanceEvent";
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.serviceName + " OMRSTopicListener");
        try {
            this.repositoryListener.processInstanceEvent(event);
        }
        catch (Exception error) {
            this.logUnhandledException(error, "processInstanceEvent");
        }
        Thread.currentThread().setName(currentThreadName);
    }
}

