/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MapPropertyValue
extends InstancePropertyValue {
    private static final long serialVersionUID = 1L;
    private InstanceProperties mapValues = null;

    public MapPropertyValue() {
        super(InstancePropertyCategory.MAP);
    }

    public MapPropertyValue(MapPropertyValue template) {
        super(template);
        if (template != null) {
            this.mapValues = template.getMapValues();
        }
    }

    @Override
    public InstancePropertyValue cloneFromSubclass() {
        return new MapPropertyValue(this);
    }

    @Override
    public String valueAsString() {
        if (this.mapValues != null) {
            return this.mapValuesAsString(this.mapValues.getInstanceProperties()).toString();
        }
        return null;
    }

    @Override
    public Object valueAsObject() {
        if (this.mapValues != null) {
            return this.mapValuesAsObject(this.mapValues.getInstanceProperties());
        }
        return null;
    }

    public int getMapElementCount() {
        if (this.mapValues == null) {
            return 0;
        }
        return this.mapValues.getPropertyCount();
    }

    public InstanceProperties getMapValues() {
        if (this.mapValues == null) {
            return null;
        }
        return new InstanceProperties(this.mapValues);
    }

    public void setMapValue(String propertyName, InstancePropertyValue propertyValue) {
        if (this.mapValues == null) {
            this.mapValues = new InstanceProperties();
        }
        this.mapValues.setProperty(propertyName, propertyValue);
    }

    public void setMapValues(InstanceProperties mapValues) {
        this.mapValues = mapValues;
    }

    @Override
    public String toString() {
        return "MapPropertyValue{mapValues=" + String.valueOf(this.mapValues) + ", mapElementCount=" + this.getMapElementCount() + ", instancePropertyCategory=" + String.valueOf(this.getInstancePropertyCategory()) + ", typeGUID='" + this.getTypeGUID() + "', typeName='" + this.getTypeName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof MapPropertyValue)) {
            return false;
        }
        MapPropertyValue that = (MapPropertyValue)objectToCompare;
        if (!super.equals(objectToCompare)) {
            return false;
        }
        return this.mapValues != null ? this.mapValues.equals(that.mapValues) : that.mapValues == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.mapValues != null ? this.mapValues.hashCode() : 0);
        return result;
    }
}

