/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.events;

import java.util.Date;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.events.OMRSEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventCategory;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEventType;
import org.odpi.openmetadata.repositoryservices.events.beans.v1.OMRSEventV1;
import org.odpi.openmetadata.repositoryservices.events.beans.v1.OMRSEventV1RegistrySection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRegistryEvent
extends OMRSEvent {
    private OMRSRegistryEventType registryEventType = OMRSRegistryEventType.UNKNOWN_REGISTRY_EVENT;
    private String metadataCollectionName = null;
    private Date registrationTimestamp = null;
    private Connection remoteConnection = null;
    private OMRSRegistryEventErrorCode errorCode = OMRSRegistryEventErrorCode.NOT_IN_USE;
    private static final Logger log = LoggerFactory.getLogger(OMRSRegistryEvent.class);

    public OMRSRegistryEvent(OMRSEventV1 inboundEvent) {
        super(inboundEvent);
        OMRSEventV1RegistrySection registrySection = inboundEvent.getRegistryEventSection();
        if (registrySection != null) {
            this.registryEventType = registrySection.getRegistryEventType();
            this.registrationTimestamp = registrySection.getRegistrationTimestamp();
            this.remoteConnection = registrySection.getRemoteConnection();
            this.metadataCollectionName = registrySection.getMetadataCollectionName();
        }
        if (this.genericErrorCode != null) {
            switch (this.errorCode) {
                case BAD_REMOTE_CONNECTION: {
                    this.errorCode = OMRSRegistryEventErrorCode.BAD_REMOTE_CONNECTION;
                    break;
                }
                case CONFLICTING_COLLECTION_ID: {
                    this.errorCode = OMRSRegistryEventErrorCode.CONFLICTING_COLLECTION_ID;
                    break;
                }
                default: {
                    this.errorCode = OMRSRegistryEventErrorCode.UNKNOWN_ERROR_CODE;
                }
            }
        }
    }

    public OMRSRegistryEvent(OMRSRegistryEventType registryEventType, Date registrationTimestamp, String metadataCollectionName, Connection remoteConnection) {
        super(OMRSEventCategory.REGISTRY);
        this.registryEventType = registryEventType;
        this.registrationTimestamp = registrationTimestamp;
        this.metadataCollectionName = metadataCollectionName;
        this.remoteConnection = remoteConnection;
    }

    public OMRSRegistryEvent(OMRSRegistryEventType registryEventType) {
        super(OMRSEventCategory.REGISTRY);
        this.registryEventType = registryEventType;
    }

    public OMRSRegistryEvent(OMRSRegistryEventErrorCode errorCode, String errorMessage, String targetMetadataCollectionId, Connection remoteConnection) {
        super(OMRSEventCategory.REGISTRY, errorCode.getEncoding(), errorMessage, targetMetadataCollectionId, remoteConnection);
        this.registryEventType = OMRSRegistryEventType.REGISTRATION_ERROR_EVENT;
    }

    public OMRSRegistryEventType getRegistryEventType() {
        return this.registryEventType;
    }

    public Date getRegistrationTimestamp() {
        return this.registrationTimestamp;
    }

    public String getMetadataCollectionName() {
        return this.metadataCollectionName;
    }

    public Connection getRemoteConnection() {
        return this.remoteConnection;
    }

    public OMRSRegistryEventErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public OMRSEventV1 getOMRSEventV1() {
        OMRSEventV1 omrsEvent = super.getOMRSEventV1();
        OMRSEventV1RegistrySection registrySection = new OMRSEventV1RegistrySection();
        registrySection.setRegistryEventType(this.registryEventType);
        registrySection.setRegistrationTimestamp(this.registrationTimestamp);
        registrySection.setMetadataCollectionName(this.metadataCollectionName);
        registrySection.setRemoteConnection(this.remoteConnection);
        omrsEvent.setRegistryEventSection(registrySection);
        return omrsEvent;
    }

    @Override
    public String toString() {
        return "OMRSRegistryEvent{registryEventType=" + String.valueOf(this.registryEventType) + ", registrationTimestamp=" + String.valueOf(this.registrationTimestamp) + ", metadataCollectionName=" + this.metadataCollectionName + ", remoteConnection=" + String.valueOf(this.remoteConnection) + ", errorCode=" + String.valueOf(this.errorCode) + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", eventDirection=" + String.valueOf(this.eventDirection) + ", eventCategory=" + String.valueOf(this.eventCategory) + ", eventOriginator=" + String.valueOf(this.eventOriginator) + ", genericErrorCode=" + String.valueOf(this.genericErrorCode) + ", errorMessage='" + this.errorMessage + "', targetMetadataCollectionId='" + this.targetMetadataCollectionId + "', targetRemoteConnection=" + String.valueOf(this.targetRemoteConnection) + ", targetTypeDefSummary=" + String.valueOf(this.targetTypeDefSummary) + ", targetAttributeTypeDef=" + String.valueOf(this.targetAttributeTypeDef) + ", targetInstanceGUID='" + this.targetInstanceGUID + "', otherOrigin=" + String.valueOf(this.otherOrigin) + ", otherMetadataCollectionId='" + this.otherMetadataCollectionId + "', otherTypeDefSummary=" + String.valueOf(this.otherTypeDefSummary) + ", otherTypeDef=" + String.valueOf(this.otherTypeDef) + ", otherAttributeTypeDef=" + String.valueOf(this.otherAttributeTypeDef) + ", otherInstanceGUID='" + this.otherInstanceGUID + "'}";
    }
}

