/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIRequest;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class InstancePropertiesRequest
extends OMRSAPIRequest {
    private static final long serialVersionUID = 1L;
    private InstanceProperties instanceProperties = null;

    public InstancePropertiesRequest() {
    }

    public InstancePropertiesRequest(InstancePropertiesRequest template) {
        super(template);
        if (template != null) {
            this.instanceProperties = template.getInstanceProperties();
        }
    }

    public InstanceProperties getInstanceProperties() {
        if (this.instanceProperties == null) {
            return null;
        }
        return new InstanceProperties(this.instanceProperties);
    }

    public void setInstanceProperties(InstanceProperties instanceProperties) {
        this.instanceProperties = instanceProperties;
    }

    public String toString() {
        return "InstancePropertiesRequest{instanceProperties=" + String.valueOf(this.instanceProperties) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof InstancePropertiesRequest)) {
            return false;
        }
        InstancePropertiesRequest that = (InstancePropertiesRequest)objectToCompare;
        return Objects.equals(this.getInstanceProperties(), that.getInstanceProperties());
    }

    public int hashCode() {
        return Objects.hash(this.getInstanceProperties());
    }
}

