/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveWriter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.samples.archiveutilities.GovernanceArchiveHelper;

public abstract class EgeriaBaseArchiveWriter
extends OMRSArchiveWriter {
    protected static final String archiveLicense = "Apache 2.0";
    protected static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    protected static final String originatorName = "Egeria Project";
    protected static final String guidMapFileName = "EgeriaContentPacksGUIDMap.json";
    protected static final String openMetadataValidValueSetPrefix = "OpenMetadata.ValidValueSet.";
    protected static final String versionName = "5.3";
    private final Map<String, String> parentValidValueQNameToGUIDMap = new HashMap<String, String>();
    protected OMRSArchiveBuilder archiveBuilder;
    protected GovernanceArchiveHelper archiveHelper;
    protected final String archiveGUID;
    protected final String archiveName;
    protected final Date creationDate;
    protected final String archiveFileName;

    protected EgeriaBaseArchiveWriter(String archiveGUID, String archiveName, String archiveDescription, Date creationDate, String archiveFileName) {
        this(archiveGUID, archiveName, archiveDescription, creationDate, archiveFileName, null);
    }

    protected EgeriaBaseArchiveWriter(String archiveGUID, String archiveName, String archiveDescription, Date creationDate, String archiveFileName, OpenMetadataArchive[] additionalDependencies) {
        this.archiveGUID = archiveGUID;
        this.archiveName = archiveName;
        this.creationDate = creationDate;
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        if (additionalDependencies != null) {
            dependentOpenMetadataArchives.addAll(Arrays.asList(additionalDependencies));
        }
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, archiveLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new GovernanceArchiveHelper((OpenMetadataArchiveBuilder)this.archiveBuilder, archiveGUID, archiveName, originatorName, creationDate, new Date().getTime(), versionName, guidMapFileName);
        this.archiveFileName = archiveFileName;
    }

    public void setArchiveBuilder(OMRSArchiveBuilder archiveBuilder, GovernanceArchiveHelper archiveHelper) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = archiveHelper;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        this.getArchiveContent();
        return this.archiveBuilder.getOpenMetadataArchive();
    }

    public abstract void getArchiveContent();

    protected String getParentSet(String requestedGUID, String typeName, String propertyName, String mapName) {
        String parentDescription = "Organizing set for valid metadata values";
        String parentQualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName(typeName, propertyName, mapName, null);
        String parentSetGUID = this.parentValidValueQNameToGUIDMap.get(parentQualifiedName);
        if (parentSetGUID == null) {
            String grandParentSetGUID = null;
            String parentDisplayName = parentQualifiedName.substring(26);
            if (mapName != null) {
                grandParentSetGUID = this.getParentSet(null, typeName, propertyName, null);
            } else if (propertyName != null) {
                grandParentSetGUID = this.getParentSet(null, typeName, null, null);
            } else if (typeName != null) {
                grandParentSetGUID = this.getParentSet(null, null, null, null);
            }
            parentSetGUID = this.archiveHelper.addValidValue(requestedGUID, grandParentSetGUID, grandParentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, null, OpenMetadataType.VALID_VALUE_SET.typeName, parentQualifiedName, parentDisplayName, "Organizing set for valid metadata values", OpenMetadataValidValues.constructValidValueCategory(typeName, propertyName, mapName), "Used to control valid values in open metadata.", null, "Open Metadata Ecosystem", null, false, false, null);
            this.parentValidValueQNameToGUIDMap.put(parentQualifiedName, parentSetGUID);
            return parentSetGUID;
        }
        return parentSetGUID;
    }

    public void writeOpenMetadataArchive() {
        this.writeOpenMetadataArchive(null);
    }

    public void writeOpenMetadataArchive(String folderName) {
        try {
            Object pathName = this.archiveFileName;
            if (folderName != null) {
                pathName = folderName + "/" + this.archiveFileName;
            }
            System.out.println("Writing to file: " + (String)pathName);
            super.writeOpenMetadataArchive((String)pathName, this.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + String.valueOf(error));
        }
        this.archiveHelper.saveGUIDs();
        this.archiveHelper.saveUsedGUIDs();
    }
}

