/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.datastore.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import java.net.InetSocketAddress;
import org.odpi.openmetadata.adapters.connectors.datastore.cassandra.ffdc.CassandraDataStoreAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDataStoreConnector
extends ConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(CassandraDataStoreConnector.class);
    private CassandraDataStoreAuditCode auditLog;
    private OMRSAuditLog omrsAuditLog;
    private CqlSession cqlSession;
    private String username = null;
    private String password = null;
    private String serverAddresses = null;
    private String port = null;

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        String actionDescription = "initialize Cassandra Data Store Connection";
        this.connectorInstanceId = connectorInstanceId;
        this.connectionProperties = connectionProperties;
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        super.initialize(connectorInstanceId, connectionProperties);
        if (this.omrsAuditLog != null) {
            this.auditLog = CassandraDataStoreAuditCode.CONNECTOR_INITIALIZING;
            this.omrsAuditLog.logRecord("initialize Cassandra Data Store Connection", this.auditLog.getLogMessageId(), this.auditLog.getSeverity(), this.auditLog.getFormattedLogMessage(new String[0]), null, this.auditLog.getSystemAction(), this.auditLog.getUserAction());
        }
        if (endpoint != null) {
            this.serverAddresses = endpoint.getAddress();
            this.port = endpoint.getAdditionalProperties().getProperty("port");
            this.username = connectionProperties.getUserId();
            this.password = connectionProperties.getClearPassword();
        } else if (this.omrsAuditLog != null) {
            this.auditLog = CassandraDataStoreAuditCode.CONNECTOR_SERVER_CONFIGURATION_ERROR;
            this.omrsAuditLog.logRecord("initialize Cassandra Data Store Connection", this.auditLog.getLogMessageId(), this.auditLog.getSeverity(), this.auditLog.getFormattedLogMessage(new String[0]), null, this.auditLog.getSystemAction(), this.auditLog.getUserAction());
        }
    }

    public void startCassandraConnection(SchemaChangeListener schemaChangeListener) {
        String actionDescription = "start Cassandra Data Store Connection";
        try {
            CqlSessionBuilder builder = CqlSession.builder();
            builder.addContactPoint(new InetSocketAddress(this.serverAddresses, (int)Integer.valueOf(this.port)));
            builder.withSchemaChangeListener(schemaChangeListener);
            builder.withAuthCredentials(this.username, this.password);
            this.cqlSession = (CqlSession)builder.build();
        }
        catch (ExceptionInInitializerError e) {
            this.auditLog = CassandraDataStoreAuditCode.CONNECTOR_SERVER_CONNECTION_ERROR;
            this.omrsAuditLog.logRecord(actionDescription, this.auditLog.getLogMessageId(), this.auditLog.getSeverity(), this.auditLog.getFormattedLogMessage(new String[0]), null, this.auditLog.getSystemAction(), this.auditLog.getUserAction());
        }
        this.auditLog = CassandraDataStoreAuditCode.CONNECTOR_INITIALIZED;
        this.omrsAuditLog.logRecord(actionDescription, this.auditLog.getLogMessageId(), this.auditLog.getSeverity(), this.auditLog.getFormattedLogMessage(new String[0]), null, this.auditLog.getSystemAction(), this.auditLog.getUserAction());
    }

    public CqlSession getSession() {
        return this.cqlSession;
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        String actionDescription = "Shut down the Cassandra data store connection.";
        this.cqlSession.close();
        this.auditLog = CassandraDataStoreAuditCode.CONNECTOR_SHUTDOWN;
        this.omrsAuditLog.logRecord(actionDescription, this.auditLog.getLogMessageId(), this.auditLog.getSeverity(), this.auditLog.getFormattedLogMessage(new String[0]), null, this.auditLog.getSystemAction(), this.auditLog.getUserAction());
    }
}

