/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.datastore.cassandra.ffdc;

import java.text.MessageFormat;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum CassandraDataStoreAuditCode {
    CONNECTOR_INITIALIZING("CASSANDRA-DATA-STORE-CONNECTOR-0001", OMRSAuditLogRecordSeverity.INFO, "The Cassandra data store connector is being initialized", "The local server has started up a new instance of the cassandra connector.", "No action is required.  This is part of the normal operation of the service."),
    CONNECTOR_INITIALIZED("CASSANDRA-DATA-STORE-CONNECTOR-0002", OMRSAuditLogRecordSeverity.INFO, "The Cassandra data store connector has initialized a new instance for server {0}", "The local server has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    CONNECTOR_SHUTDOWN("CASSANDRA-DATA-STORE-CONNECTOR-0003", OMRSAuditLogRecordSeverity.INFO, "The Cassandra data store connector is shutting down its instance for server {0}", "The local server has requested shut down of a cassandra connector.", "No action is required.  This is part of the normal operation of the service."),
    CONNECTOR_SERVER_CONFIGURATION_ERROR("CASSANDRA-DATA-STORE-CONNECTOR-0004", OMRSAuditLogRecordSeverity.EXCEPTION, "The configuration of the Cassandra cluster is not valid.", "The local server is unable to create a connector.", "Check the connection configuration"),
    CONNECTOR_SERVER_ADDRESS_ERROR("CASSANDRA-DATA-STORE-CONNECTOR-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "The address of the Cassandra cluster is not valid.", "The local server is unable to create a connector.", "Check if the address of the cassandra cluster is valid"),
    CONNECTOR_SERVER_CONNECTION_ERROR("CASSANDRA-DATA-STORE-CONNECTOR-0007.", OMRSAuditLogRecordSeverity.EXCEPTION, "The address of the cassandra cluster cannot be connected.", "The local server is unable to create a connector.", "Check if the address of the cassandra cluster is accessible."),
    CONNECTOR_REGISTER_LISTENER_ERROR("CASSANDRA-DATA-STORE-CONNECTOR-0009", OMRSAuditLogRecordSeverity.EXCEPTION, "The Cassandra metadata change listener can not be registered", "No metadata change from cassandra will be listened.", "Check the configuration details.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private CassandraDataStoreAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.logMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

