/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.Session;
import org.odpi.openmetadata.adapters.connectors.cassandra.CassandraStoreListener;
import org.odpi.openmetadata.adapters.connectors.cassandra.auditlog.CassandraConnectorAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.auditable.AuditableConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStoreConnector
extends ConnectorBase
implements AuditableConnector {
    private static final Logger log = LoggerFactory.getLogger(CassandraStoreConnector.class);
    private OMRSAuditLog omrsAuditLog;
    private CassandraConnectorAuditCode auditLog;
    private String serverAddress = null;
    private String clusterName = null;
    private String username = null;
    private String password = null;
    private Cluster cluster;
    private Session session;

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        String actionDescription = "initialize";
        this.connectorInstanceId = connectorInstanceId;
        this.connectionProperties = connectionProperties;
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        super.initialize(connectorInstanceId, connectionProperties);
        if (this.omrsAuditLog != null) {
            this.auditLog = CassandraConnectorAuditCode.CONNECTOR_INITIALIZING;
            this.omrsAuditLog.logRecord("initialize", this.auditLog.getLogMessageId(), this.auditLog.getSeverity(), this.auditLog.getFormattedLogMessage(new String[0]), null, this.auditLog.getSystemAction(), this.auditLog.getUserAction());
        }
        if (endpoint != null) {
            this.serverAddress = endpoint.getAddress();
            if (this.serverAddress != null) {
                log.info("The connecting cassandra cluster server address is: {}.", (Object)this.serverAddress);
            } else {
                log.error("Errors in the Cassandra server configuration. The address of the server cannot be extracted.");
                if (this.omrsAuditLog != null) {
                    this.auditLog = CassandraConnectorAuditCode.CONNECTOR_SERVER_CONFIGURATION_ERROR;
                    this.omrsAuditLog.logRecord("initialize", this.auditLog.getLogMessageId(), this.auditLog.getSeverity(), this.auditLog.getFormattedLogMessage(new String[0]), null, this.auditLog.getSystemAction(), this.auditLog.getUserAction());
                }
            }
        } else {
            log.error("Errors in Cassandra server address. The endpoint containing the server address is invalid.");
            if (this.omrsAuditLog != null) {
                this.auditLog = CassandraConnectorAuditCode.CONNECTOR_SERVER_ADDRESS_ERROR;
                this.omrsAuditLog.logRecord("initialize", this.auditLog.getLogMessageId(), this.auditLog.getSeverity(), this.auditLog.getFormattedLogMessage(new String[0]), null, this.auditLog.getSystemAction(), this.auditLog.getUserAction());
            }
        }
        this.startCassandraConnection();
        if (this.cluster.getClusterName().equals(this.clusterName) && this.omrsAuditLog != null) {
            this.auditLog = CassandraConnectorAuditCode.CONNECTOR_INITIALIZED;
            this.omrsAuditLog.logRecord("initialize", this.auditLog.getLogMessageId(), this.auditLog.getSeverity(), this.auditLog.getFormattedLogMessage(new String[0]), null, this.auditLog.getSystemAction(), this.auditLog.getUserAction());
        }
    }

    public void startCassandraConnection() {
        this.cluster = Cluster.builder().addContactPoint(this.serverAddress).withClusterName(this.clusterName).withCredentials(this.username, this.password).build();
        this.session = this.cluster.connect();
    }

    public Session getSession() {
        return this.session;
    }

    public void shutdown() {
        String actionDescription = "Shut down the Cassandra connection.";
        this.session.close();
        this.cluster.close();
        this.auditLog = CassandraConnectorAuditCode.CONNECTOR_SHUTDOWN;
        this.omrsAuditLog.logRecord(actionDescription, this.auditLog.getLogMessageId(), this.auditLog.getSeverity(), this.auditLog.getFormattedLogMessage(new String[0]), null, this.auditLog.getSystemAction(), this.auditLog.getUserAction());
    }

    public void setAuditLog(OMRSAuditLog auditLog) {
        this.omrsAuditLog = auditLog;
    }

    public void registerListener(CassandraStoreListener cassandraStoreListener) {
        if (cassandraStoreListener != null) {
            this.cluster.register((SchemaChangeListener)cassandraStoreListener);
            log.info("Registering cassandra cluster listener: {}", (Object)cassandraStoreListener.toString());
        } else {
            String actionDescription = "Error in registering cassandra store listener.";
            this.auditLog = CassandraConnectorAuditCode.CONNECTOR_REGISTER_LISTENER_ERROR;
            this.omrsAuditLog.logRecord(actionDescription, this.auditLog.getLogMessageId(), this.auditLog.getSeverity(), this.auditLog.getFormattedLogMessage(new String[0]), null, this.auditLog.getSystemAction(), this.auditLog.getUserAction());
        }
    }
}

