/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.cassandra.auditlog;

import java.text.MessageFormat;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum CassandraConnectorAuditCode {
    CONNECTOR_INITIALIZING("CASSANDRA-CONNECTOR-0001", OMRSAuditLogRecordSeverity.INFO, "The connector is being initialized", "The local server has started up a new instance of the cassandra connector.", "No action is required.  This is part of the normal operation of the service."),
    CONNECTOR_INITIALIZED("CASSANDRA-CONNECTOR-0002", OMRSAuditLogRecordSeverity.INFO, "The cassandra connector has initialized a new instance for server {0}", "The local server has completed initialization of a new instance.", "No action is required.  This is part of the normal operation of the service."),
    CONNECTOR_SHUTDOWN("CASSANDRA-CONNECTOR-0003", OMRSAuditLogRecordSeverity.INFO, "The cassandra connector is shutting down its instance for server {0}", "The local server has requested shut down of a cassandra connector.", "No action is required.  This is part of the normal operation of the service."),
    CONNECTOR_SERVER_CONFIGURATION_ERROR("CASSANDRA-CONNECTOR-0004", OMRSAuditLogRecordSeverity.EXCEPTION, "The configuration of the cassandra cluster is not valid.", "The local server is unable to create a connector.", "Check the connection configuration"),
    CONNECTOR_SERVER_ADDRESS_ERROR("CASSANDRA-CONNECTOR-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "The address of the cassandra cluster is not valid.", "The local server is unable to create a connector.", "Check if the address of the cassandra cluster is valid"),
    CONNECTOR_KEYSPACE_ERROR("CASSANDRA-CONNECTOR-0006.", OMRSAuditLogRecordSeverity.EXCEPTION, "The name of the keyspace is not valid ", "The local server is unable to create a connector.", "Check if the name of the logical is valid"),
    CONNECTOR_SERVER_CONNECTION_ERROR("CASSANDRA-CONNECTOR-0007.", OMRSAuditLogRecordSeverity.EXCEPTION, "The address of the cassandra cluster cannot be connected.", "The local server is unable to create a connector.", "Check if the address of the cassandra cluster is accessible."),
    CONNECTOR_TABLE_ERROR("CASSANDRA-CONNECTOR-0008", OMRSAuditLogRecordSeverity.EXCEPTION, "The Cassandra table cannot be created or updated.", "No query result will be provided.", "Check if the query is valid."),
    CONNECTOR_REGISTER_LISTENER_ERROR("CASSANDRA-CONNECTOR-0009", OMRSAuditLogRecordSeverity.EXCEPTION, "The Cassandra metadata change listener can not be registered", "No metadata change from cassandra will be listened.", "Check the configuration details.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private CassandraConnectorAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.logMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

