/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.catalogbuilder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.archiveutilities.catalogbuilder.properties.ConceptModelDecoration;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveGUIDMap;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;

public class CatalogTypesArchiveBuilder {
    private static final String GLOSSARY_TYPE_NAME = "Glossary";
    private static final String EXTERNAL_GLOSSARY_LINK_TYPE_NAME = "ExternalGlossaryLink";
    private static final String EXTERNALLY_SOURCED_GLOSSARY_TYPE_NAME = "ExternallySourcedGlossary";
    private static final String CANONICAL_VOCABULARY_TYPE_NAME = "CanonicalVocabulary";
    private static final String GLOSSARY_CATEGORY_TYPE_NAME = "GlossaryCategory";
    private static final String SUBJECT_AREA_TYPE_NAME = "SubjectArea";
    private static final String CATEGORY_ANCHOR_TYPE_NAME = "CategoryAnchor";
    private static final String CATEGORY_HIERARCHY_LINK_TYPE_NAME = "CategoryHierarchyLink";
    private static final String GLOSSARY_TERM_TYPE_NAME = "GlossaryTerm";
    private static final String TERM_ANCHOR_TYPE_NAME = "TermAnchor";
    private static final String TERM_CATEGORIZATION_TYPE_NAME = "TermCategorization";
    private static final String SEMANTIC_ASSIGNMENT_TYPE_NAME = "TermAnchor";
    private static final String MORE_INFORMATION_TYPE_NAME = "MoreInformation";
    private static final String DESIGN_MODEL_TYPE_NAME = "DesignModel";
    private static final String DESIGN_MODEL_GROUP_TYPE_NAME = "DesignModelGroup";
    private static final String DESIGN_MODEL_ELEMENT_OWNERSHIP_TYPE_NAME = "DesignModelElementOwnership";
    private static final String DESIGN_MODEL_GROUP_OWNERSHIP_TYPE_NAME = "DesignModelGroupOwnership";
    private static final String DESIGN_MODEL_GROUP_HIERARCHY_TYPE_NAME = "DesignModelGroupHierarchy";
    private static final String DESIGN_MODEL_GROUP_MEMBERSHIP_TYPE_NAME = "DesignModelGroupMembership";
    private static final String CONCEPT_BEAD_TYPE_NAME = "ConceptBead";
    private static final String CONCEPT_BEAD_LINK_TYPE_NAME = "ConceptBeadLink";
    private static final String CONCEPT_BEAD_ATTRIBUTE_TYPE_NAME = "ConceptBeadAttribute";
    private static final String CONCEPT_BEAD_ATTRIBUTE_LINK_TYPE_NAME = "ConceptBeadAttributeLink";
    private static final String CONCEPT_BEAD_RELATIONSHIP_TYPE_NAME = "ConceptBeadRelationshipEnd";
    private static final String SPINE_OBJECT_NAME = "SpineObject";
    private static final String SPINE_ATTRIBUTE_NAME = "SpineAttribute";
    private static final String IS_A_TYPE_OF_RELATIONSHIP_NAME = "IsATypeOfRelationship";
    private static final String HAS_A_RELATIONSHIP_NAME = "TermHASARelationship";
    private static final String RELATED_TERM_RELATIONSHIP_NAME = "RelatedTerm";
    private static final String ASSET_TYPE_NAME = "Asset";
    private static final String DATA_CONTENT_FOR_DATA_SET_TYPE_NAME = "DataContentForDataSet";
    private static final String SCHEMA_TYPE_TYPE_NAME = "SchemaType";
    private static final String PRIMITIVE_SCHEMA_TYPE_TYPE_NAME = "PrimitiveSchemaType";
    private static final String SCHEMA_TYPE_OPTION_TYPE_NAME = "SchemaTypeOption";
    private static final String SCHEMA_ATTRIBUTE_TYPE_NAME = "SchemaAttribute";
    private static final String ASSET_SCHEMA_TYPE_TYPE_NAME = "AssetSchemaType";
    private static final String ATTRIBUTE_FOR_SCHEMA_TYPE_NAME = "AttributeForSchema";
    private static final String NESTED_SCHEMA_ATTRIBUTE_TYPE_NAME = "NestedSchemaAttribute";
    private static final String TYPE_EMBEDDED_ATTRIBUTE_TYPE_NAME = "TypeEmbeddedAttribute";
    private static final String CALCULATED_VALUE_TYPE_NAME = "CalculatedValue";
    private static final String DERIVED_QUERY_TARGET_TYPE_NAME = "DerivedSchemaTypeQueryTarget";
    private static final String PRIMARY_KEY_TYPE_NAME = "PrimaryKey";
    private static final String FOREIGN_KEY_TYPE_NAME = "ForeignKey";
    private static final String API_OPERATION_TYPE_NAME = "APIOperation";
    private static final String API_OPERATIONS_TYPE_NAME = "APIOperations";
    protected static final String API_HEADER_TYPE_NAME = "APIHeader";
    protected static final String API_REQUEST_TYPE_NAME = "APIRequest";
    protected static final String API_RESPONSE_TYPE_NAME = "APIResponse";
    private static final String API_PARAMETER_TYPE_NAME = "APIParameter";
    private static final String API_PARAMETER_LIST_TYPE_NAME = "APIParameterList";
    private static final String CONNECTION_TYPE_NAME = "Connection";
    private static final String CONNECTOR_TYPE_TYPE_NAME = "ConnectorType";
    private static final String ENDPOINT_TYPE_NAME = "Endpoint";
    private static final String CONNECTOR_CATEGORY_TYPE_NAME = "ConnectorCategory";
    private static final String CONNECTOR_TYPE_DIRECTORY_TYPE_NAME = "ConnectorTypeDirectory";
    private static final String COLLECTION_TYPE_NAME = "Collection";
    private static final String COLLECTION_MEMBER_TYPE_NAME = "CollectionMembership";
    private static final String CONNECTION_CONNECTOR_TYPE_TYPE_NAME = "ConnectionConnectorType";
    private static final String CONNECTION_ENDPOINT_TYPE_NAME = "ConnectionEndpoint";
    private static final String CONNECTOR_IMPL_CHOICE_TYPE_NAME = "ConnectorImplementationChoice";
    private static final String NAME_PROPERTY = "name";
    private static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    private static final String ADDITIONAL_PROPERTIES_PROPERTY = "additionalProperties";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String SUPPORTED_ASSET_TYPE_PROPERTY = "supportedAssetTypeName";
    private static final String EXPECTED_DATA_FORMAT_PROPERTY = "expectedDataFormat";
    private static final String CONNECTOR_PROVIDER_PROPERTY = "connectorProviderClassName";
    private static final String CONNECTOR_FRAMEWORK_PROPERTY = "connectorFrameworkNameName";
    private static final String CONNECTOR_FRAMEWORK_DEFAULT = "Open Connector Framework (OCF)";
    private static final String CONNECTOR_INTERFACE_LANGUAGE_PROPERTY = "connectorInterfaceLanguage";
    private static final String CONNECTOR_INTERFACE_LANGUAGE_DEFAULT = "Java";
    private static final String CONNECTOR_INTERFACES_PROPERTY = "connectorInterfaces";
    private static final String TARGET_TECHNOLOGY_SOURCE_PROPERTY = "targetTechnologySource";
    private static final String TARGET_TECHNOLOGY_NAME_PROPERTY = "targetTechnologyName";
    private static final String TARGET_TECHNOLOGY_INTERFACES_PROPERTY = "targetTechnologyInterfaces";
    private static final String TARGET_TECHNOLOGY_VERSIONS_PROPERTY = "targetTechnologyVersions";
    private static final String SECURED_PROPERTIES_PROPERTY = "securedProperties";
    private static final String CONFIGURATION_PROPERTIES_PROPERTY = "configurationProperties";
    private static final String USER_ID_PROPERTY = "userId";
    private static final String CLEAR_PASSWORD_PROPERTY = "clearPassword";
    private static final String ENCRYPTED_PASSWORD_PROPERTY = "encryptedPassword";
    private static final String RECOGNIZED_ADDITIONAL_PROPERTIES_PROPERTY = "recognizedAdditionalProperties";
    private static final String RECOGNIZED_SECURED_PROPERTIES_PROPERTY = "recognizedSecuredProperties";
    private static final String RECOGNIZED_CONFIGURATION_PROPERTIES_PROPERTY = "recognizedConfigurationProperties";
    private static final String NETWORK_ADDRESS_PROPERTY = "networkAddress";
    private static final String PROTOCOL_PROPERTY = "protocol";
    private static final String REQUIRED_PROPERTY = "required";
    private static final String PARAMETER_TYPE_PROPERTY = "parameterType";
    private static final String PATH_TYPE_PROPERTY = "path";
    private static final String COMMAND_TYPE_PROPERTY = "command";
    private static final String CONFIDENCE_TYPE_PROPERTY = "confidence";
    private static final String STEWARD_PROPERTY = "steward";
    private static final String STEWARD_TYPE_NAME_PROPERTY = "stewardTypeName";
    private static final String STEWARD_PROPERTY_NAME_PROPERTY = "stewardPropertyName";
    private static final String SOURCE_PROPERTY = "source";
    private static final String NOTES_PROPERTY = "notes";
    private static final String FORMULA_PROPERTY = "formula";
    private static final String QUERY_ID_PROPERTY = "queryId";
    private static final String QUERY_PROPERTY = "query";
    private static final String POSITION_PROPERTY = "position";
    private static final String MIN_CARDINALITY_PROPERTY = "minCardinality";
    private static final String MAX_CARDINALITY_PROPERTY = "maxCardinality";
    private static final String ALLOWS_DUPLICATE_VALUES_PROPERTY = "allowsDuplicateValues";
    private static final String ORDERED_VALUES_PROPERTY = "orderedValues";
    private static final String DEFAULT_VALUE_OVERRIDE_PROPERTY = "defaultValueOverride";
    private static final String MINIMUM_LENGTH_PROPERTY = "minimumLength";
    private static final String LENGTH_PROPERTY = "length";
    private static final String PRECISION_PROPERTY = "precision";
    private static final String SIGNIFICANT_DIGITS_PROPERTY = "significantDigits";
    private static final String IS_NULLABLE_PROPERTY = "isNullable";
    private static final String NATIVE_CLASS_PROPERTY = "nativeClass";
    private static final String ALIASES_PROPERTY = "aliases";
    private static final String SORT_ORDER_PROPERTY = "sortOrder";
    private static final String SCHEMA_TYPE_NAME_PROPERTY = "schemaTypeName";
    private static final String VERSION_NUMBER_PROPERTY = "versionNumber";
    private static final String IS_DEPRECATED_PROPERTY = "isDeprecated";
    private static final String AUTHOR_PROPERTY = "author";
    private static final String USAGE_PROPERTY = "usage";
    private static final String ENCODING_STANDARD_PROPERTY = "encodingStandard";
    private static final String NAMESPACE_PROPERTY = "namespace";
    private static final String DATA_TYPE_PROPERTY = "dataType";
    private static final String DEFAULT_VALUE_PROPERTY = "defaultValue";
    private static final String FIXED_VALUE_PROPERTY = "fixedValue";
    private static final String EXAMPLES_PROPERTY = "examples";
    private static final String TECHNICAL_NAME_PROPERTY = "technicalName";
    private static final String LANGUAGE_PROPERTY = "language";
    private static final String SCOPE_PROPERTY = "scope";
    private static final String URL_PROPERTY = "url";
    private static final String ORGANIZATION_PROPERTY = "organization";
    private static final String VERSION_PROPERTY = "version";
    private static final String STATUS_IDENTIFIER_PROPERTY = "statusIdentifier";
    private static final String CONFIDENCE_PROPERTY = "confidence";
    private static final String ATTRIBUTE_NAME_PROPERTY = "attribute";
    private static final String DECORATION_PROPERTY = "decoration";
    private static final String UNIQUE_VALUES_PROPERTY = "uniqueValues";
    private static final String NAVIGABLE_PROPERTY = "navigable";
    private static final String guidMapFileName = "archiveGUIDMap.json";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;
    protected OMRSArchiveGUIDMap idToGUIDMap;
    private String archiveRootName;
    private String originatorName;
    private String versionName;

    public CatalogTypesArchiveBuilder(String archiveGUID, String archiveName, String archiveDescription, OpenMetadataArchiveType archiveType, String archiveRootName, String originatorName, String originatorLicense, Date creationDate, long versionNumber, String versionName, List<OpenMetadataArchive> dependentArchives) {
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        if (dependentArchives != null) {
            dependentOpenMetadataArchives.addAll(dependentArchives);
        }
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, originatorLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new OMRSArchiveHelper((OpenMetadataArchiveBuilder)this.archiveBuilder, archiveGUID, originatorName, creationDate, versionNumber, versionName);
        this.idToGUIDMap = new OMRSArchiveGUIDMap(guidMapFileName);
        this.archiveRootName = archiveRootName;
        this.originatorName = originatorName;
        this.versionName = versionName;
    }

    protected OpenMetadataArchive getOpenMetadataArchive() {
        System.out.println("GUIDs map size: " + this.idToGUIDMap.getSize());
        this.idToGUIDMap.saveGUIDs();
        return this.archiveBuilder.getOpenMetadataArchive();
    }

    protected void logBadArchiveContent(String methodName) {
        this.archiveBuilder.logBadArchiveContent(methodName);
    }

    protected String addAsset(String typeName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addAsset";
        String assetTypeName = ASSET_TYPE_NAME;
        if (typeName != null) {
            assetTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, NAME_PROPERTY, qualifiedName, "addAsset");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addAsset");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addAsset");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addAsset");
        EntityDetail assetEntity = this.archiveHelper.getEntityDetail(assetTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(assetEntity);
        return assetEntity.getGUID();
    }

    protected void addDataContentForDataSet(String dataContentGUID, String dataSetGUID) {
        EntityDetail dataContentEntity = this.archiveBuilder.getEntity(dataContentGUID);
        EntityDetail dataSetEntity = this.archiveBuilder.getEntity(dataSetGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(dataContentEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(dataSetEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DATA_CONTENT_FOR_DATA_SET_TYPE_NAME, this.idToGUIDMap.getGUID(dataContentGUID + "_to_" + dataSetGUID + "_data_consumer_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected String addTopLevelSchemaType(String assetGUID, String typeName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addTopLevelSchemaType";
        String schemaTypeTypeName = SCHEMA_TYPE_TYPE_NAME;
        if (typeName != null) {
            schemaTypeTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addTopLevelSchemaType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addTopLevelSchemaType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addTopLevelSchemaType");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addTopLevelSchemaType");
        EntityDetail schemaTypeEntity = this.archiveHelper.getEntityDetail(schemaTypeTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(schemaTypeEntity);
        if (assetGUID != null) {
            EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(assetEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(ASSET_SCHEMA_TYPE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_asset_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return schemaTypeEntity.getGUID();
    }

    protected String addAPIOperation(String apiSchemaTypeGUID, String qualifiedName, String displayName, String description, String path, String command, Map<String, String> additionalProperties) {
        String methodName = "addAPIOperation";
        String schemaTypeTypeName = API_OPERATION_TYPE_NAME;
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PATH_TYPE_PROPERTY, path, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, COMMAND_TYPE_PROPERTY, command, "addAPIOperation");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addAPIOperation");
        EntityDetail schemaTypeEntity = this.archiveHelper.getEntityDetail(schemaTypeTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(schemaTypeEntity);
        if (apiSchemaTypeGUID != null) {
            EntityDetail parentEntity = this.archiveBuilder.getEntity(apiSchemaTypeGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(parentEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(API_OPERATIONS_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_parent_api_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return schemaTypeEntity.getGUID();
    }

    protected String addAPIParameterList(String apiOperationGUID, String relationshipTypeName, String qualifiedName, String displayName, String description, boolean required, Map<String, String> additionalProperties) {
        String methodName = "addAPIParameterList";
        String typeName = API_REQUEST_TYPE_NAME;
        if (relationshipTypeName != null) {
            typeName = relationshipTypeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addAPIParameterList");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addAPIParameterList");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addAPIParameterList");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, REQUIRED_PROPERTY, required, "addAPIParameterList");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addAPIParameterList");
        EntityDetail parameterListEntity = this.archiveHelper.getEntityDetail(API_PARAMETER_LIST_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(parameterListEntity);
        if (apiOperationGUID != null) {
            EntityDetail operationEntity = this.archiveBuilder.getEntity(apiOperationGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(operationEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(parameterListEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(typeName, this.idToGUIDMap.getGUID(qualifiedName + "_operation_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return parameterListEntity.getGUID();
    }

    protected void addSchemaTypeOption(String schemaTypeChoiceGUID, String schemaTypeOptionGUID) {
        EntityDetail schemaTypeChoiceEntity = this.archiveBuilder.getEntity(schemaTypeChoiceGUID);
        EntityDetail schemaTypeOptionEntity = this.archiveBuilder.getEntity(schemaTypeOptionGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(schemaTypeChoiceEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeOptionEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(SCHEMA_TYPE_OPTION_TYPE_NAME, this.idToGUIDMap.getGUID(schemaTypeChoiceGUID + "_to_" + schemaTypeOptionGUID + "_schema_type_option_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addAttributeForSchemaType(String schemaTypeGUID, String schemaAttributeGUID) {
        EntityDetail schemaTypeChoiceEntity = this.archiveBuilder.getEntity(schemaTypeGUID);
        EntityDetail schemaTypeOptionEntity = this.archiveBuilder.getEntity(schemaAttributeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(schemaTypeChoiceEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeOptionEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(ATTRIBUTE_FOR_SCHEMA_TYPE_NAME, this.idToGUIDMap.getGUID(schemaTypeGUID + "_to_" + schemaAttributeGUID + "_attribute_for_schema_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addNestedSchemaAttribute(String parentSchemaAttributeGUID, String childSchemaAttributeGUID) {
        EntityDetail parentSchemaAttributeEntity = this.archiveBuilder.getEntity(parentSchemaAttributeGUID);
        EntityDetail childSchemaAtrributeEntity = this.archiveBuilder.getEntity(childSchemaAttributeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(parentSchemaAttributeEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(childSchemaAtrributeEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(NESTED_SCHEMA_ATTRIBUTE_TYPE_NAME, this.idToGUIDMap.getGUID(parentSchemaAttributeGUID + "_to_" + childSchemaAttributeGUID + "_nested_schema_attribute_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected String addSchemaAttribute(String typeName, String schemaTypeName, String qualifiedName, String displayName, String description, String dataType, int length, int position, Map<String, String> additionalProperties) {
        String methodName = "addSchemaAttribute";
        String schemaAttributeTypeName = SCHEMA_ATTRIBUTE_TYPE_NAME;
        if (typeName != null) {
            schemaAttributeTypeName = typeName;
        }
        String schemaTypeTypeName = PRIMITIVE_SCHEMA_TYPE_TYPE_NAME;
        if (schemaTypeName != null) {
            schemaTypeTypeName = schemaTypeName;
        }
        InstanceProperties entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, DISPLAY_NAME_PROPERTY, displayName, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, DESCRIPTION_PROPERTY, description, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, entityProperties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addSchemaAttribute");
        InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, SCHEMA_TYPE_NAME_PROPERTY, schemaTypeTypeName, "addSchemaAttribute");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, DATA_TYPE_PROPERTY, dataType, "addSchemaAttribute");
        classificationProperties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, classificationProperties, LENGTH_PROPERTY, length, "addSchemaAttribute");
        Classification classification = this.archiveHelper.getClassification(TYPE_EMBEDDED_ATTRIBUTE_TYPE_NAME, classificationProperties, InstanceStatus.ACTIVE);
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(classification);
        EntityDetail schemaAttributeEntity = this.archiveHelper.getEntityDetail(schemaAttributeTypeName, this.idToGUIDMap.getGUID(qualifiedName), entityProperties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(schemaAttributeEntity);
        return schemaAttributeEntity.getGUID();
    }

    protected String addConnection(String qualifiedName, String displayName, String description, String userId, String clearPassword, String encryptedPassword, Map<String, String> securedProperties, Map<String, Object> configurationProperties, Map<String, String> additionalProperties, String connectorTypeGUID, String endpointGUID) {
        EntityProxy end2;
        EntityProxy end1;
        String methodName = "addConnection";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, USER_ID_PROPERTY, userId, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CLEAR_PASSWORD_PROPERTY, clearPassword, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ENCRYPTED_PASSWORD_PROPERTY, encryptedPassword, "addConnection");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, SECURED_PROPERTIES_PROPERTY, securedProperties, "addConnection");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnection");
        properties = this.archiveHelper.addMapPropertyToInstance(this.archiveRootName, properties, CONFIGURATION_PROPERTIES_PROPERTY, configurationProperties, "addConnection");
        EntityDetail connectionEntity = this.archiveHelper.getEntityDetail(CONNECTION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(connectionEntity);
        if (connectorTypeGUID != null) {
            EntityDetail connectorTypeEntity = this.archiveBuilder.getEntity(connectorTypeGUID);
            end1 = this.archiveHelper.getEntityProxy(connectionEntity);
            end2 = this.archiveHelper.getEntityProxy(connectorTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONNECTION_CONNECTOR_TYPE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_connectorType_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        if (endpointGUID != null) {
            EntityDetail endpointEntity = this.archiveBuilder.getEntity(endpointGUID);
            end1 = this.archiveHelper.getEntityProxy(endpointEntity);
            end2 = this.archiveHelper.getEntityProxy(connectionEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONNECTION_ENDPOINT_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_endpoint_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return connectionEntity.getGUID();
    }

    protected String addConnectorType(String connectorCategoryGUID, String connectorTypeGUID, String qualifiedName, String displayName, String description, String supportedAssetTypeName, String expectedDataFormat, String connectorProviderClassName, String connectorFrameworkName, String connectorInterfaceLanguage, List<String> connectorInterfaces, String targetTechnologySource, String targetTechnologyName, List<String> targetTechnologyInterfaces, List<String> targetTechnologyVersions, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, List<String> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        String newGUID = this.idToGUIDMap.getGUID(qualifiedName);
        this.idToGUIDMap.setGUID(qualifiedName, newGUID);
        return this.addConnectorType(connectorCategoryGUID, qualifiedName, displayName, description, supportedAssetTypeName, expectedDataFormat, connectorProviderClassName, connectorFrameworkName, connectorInterfaceLanguage, connectorInterfaces, targetTechnologySource, targetTechnologyName, targetTechnologyInterfaces, targetTechnologyVersions, recognizedSecuredProperties, recognizedConfigurationProperties, recognizedAdditionalProperties, additionalProperties);
    }

    protected String addConnectorType(String connectorCategoryGUID, String qualifiedName, String displayName, String description, String supportedAssetTypeName, String expectedDataFormat, String connectorProviderClassName, String connectorFrameworkName, String connectorInterfaceLanguage, List<String> connectorInterfaces, String targetTechnologySource, String targetTechnologyName, List<String> targetTechnologyInterfaces, List<String> targetTechnologyVersions, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, List<String> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        String methodName = "addConnectorType";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SUPPORTED_ASSET_TYPE_PROPERTY, supportedAssetTypeName, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, EXPECTED_DATA_FORMAT_PROPERTY, expectedDataFormat, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_PROVIDER_PROPERTY, connectorProviderClassName, "addConnectorType");
        properties = connectorFrameworkName != null ? this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_FRAMEWORK_PROPERTY, connectorFrameworkName, "addConnectorType") : this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_FRAMEWORK_PROPERTY, CONNECTOR_FRAMEWORK_DEFAULT, "addConnectorType");
        properties = connectorInterfaceLanguage != null ? this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_INTERFACE_LANGUAGE_PROPERTY, connectorInterfaceLanguage, "addConnectorType") : this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_INTERFACE_LANGUAGE_PROPERTY, CONNECTOR_INTERFACE_LANGUAGE_DEFAULT, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, CONNECTOR_INTERFACES_PROPERTY, connectorInterfaces, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_SOURCE_PROPERTY, targetTechnologySource, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_NAME_PROPERTY, targetTechnologyName, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_INTERFACES_PROPERTY, targetTechnologyInterfaces, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_VERSIONS_PROPERTY, targetTechnologyVersions, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_SECURED_PROPERTIES_PROPERTY, recognizedSecuredProperties, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_ADDITIONAL_PROPERTIES_PROPERTY, recognizedAdditionalProperties, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_CONFIGURATION_PROPERTIES_PROPERTY, recognizedConfigurationProperties, "addConnectorType");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnectorType");
        EntityDetail connectorTypeEntity = this.archiveHelper.getEntityDetail(CONNECTOR_TYPE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(connectorTypeEntity);
        if (connectorCategoryGUID != null) {
            EntityDetail connectorCategoryEntity = this.archiveBuilder.getEntity(connectorCategoryGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(connectorCategoryEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(connectorTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONNECTOR_IMPL_CHOICE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_connector_category_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return connectorTypeEntity.getGUID();
    }

    protected String addConnectorCategory(String connectorTypeDirectoryGUID, String qualifiedName, String displayName, String description, String targetTechnologySource, String targetTechnologyName, Map<String, Boolean> recognizedSecuredProperties, Map<String, Boolean> recognizedConfigurationProperties, Map<String, Boolean> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        String methodName = "addConnectorCategory";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_SOURCE_PROPERTY, targetTechnologySource, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_NAME_PROPERTY, targetTechnologyName, "addConnectorCategory");
        properties = this.archiveHelper.addBooleanMapPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_SECURED_PROPERTIES_PROPERTY, recognizedSecuredProperties, "addConnectorCategory");
        properties = this.archiveHelper.addBooleanMapPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_ADDITIONAL_PROPERTIES_PROPERTY, recognizedAdditionalProperties, "addConnectorCategory");
        properties = this.archiveHelper.addBooleanMapPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_CONFIGURATION_PROPERTIES_PROPERTY, recognizedConfigurationProperties, "addConnectorCategory");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnectorCategory");
        EntityDetail connectorCategoryEntity = this.archiveHelper.getEntityDetail(CONNECTOR_CATEGORY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(connectorCategoryEntity);
        if (connectorTypeDirectoryGUID != null) {
            EntityDetail connectorTypeDirectoryEntity = this.archiveBuilder.getEntity(connectorTypeDirectoryGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(connectorTypeDirectoryEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(connectorCategoryEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(COLLECTION_MEMBER_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_connector_type_directory_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return connectorCategoryEntity.getGUID();
    }

    protected String addConnectorTypeDirectory(String qualifiedName, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addConnectorTypeDirectory";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnectorTypeDirectory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnectorTypeDirectory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnectorTypeDirectory");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnectorTypeDirectory");
        Classification classification = this.archiveHelper.getClassification(CONNECTOR_TYPE_DIRECTORY_TYPE_NAME, null, InstanceStatus.ACTIVE);
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(classification);
        EntityDetail connectorTypeDirectoryEntity = this.archiveHelper.getEntityDetail(COLLECTION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(connectorTypeDirectoryEntity);
        return connectorTypeDirectoryEntity.getGUID();
    }

    protected String addEndpoint(String qualifiedName, String displayName, String description, String networkAddress, String protocol, Map<String, String> additionalProperties) {
        String methodName = "addEndpoint";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NETWORK_ADDRESS_PROPERTY, networkAddress, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PROTOCOL_PROPERTY, protocol, "addEndpoint");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addEndpoint");
        EntityDetail endpointEntity = this.archiveHelper.getEntityDetail(ENDPOINT_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(endpointEntity);
        return endpointEntity.getGUID();
    }

    protected String addGlossary(String qualifiedName, String displayName, String description, String language, String usage, String externalLink, String scope) {
        String methodName = "addGlossary";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, LANGUAGE_PROPERTY, language, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, USAGE_PROPERTY, usage, "addGlossary");
        ArrayList<Classification> classifications = null;
        if (scope != null) {
            Classification canonicalVocabClassification = this.archiveHelper.getClassification(CANONICAL_VOCABULARY_TYPE_NAME, this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, SCOPE_PROPERTY, scope, "addGlossary"), InstanceStatus.ACTIVE);
            classifications = new ArrayList<Classification>();
            classifications.add(canonicalVocabClassification);
        }
        EntityDetail glossaryEntity = this.archiveHelper.getEntityDetail(GLOSSARY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(glossaryEntity);
        if (externalLink != null) {
            String externalLinkQualifiedName = qualifiedName + "_external_link";
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, externalLinkQualifiedName, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, URL_PROPERTY, externalLink, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ORGANIZATION_PROPERTY, this.originatorName, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_PROPERTY, this.versionName, "addGlossary");
            EntityDetail externalLinkEntity = this.archiveHelper.getEntityDetail(EXTERNAL_GLOSSARY_LINK_TYPE_NAME, this.idToGUIDMap.getGUID(externalLinkQualifiedName), properties, InstanceStatus.ACTIVE, classifications);
            this.archiveBuilder.addEntity(externalLinkEntity);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(glossaryEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(externalLinkEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(EXTERNALLY_SOURCED_GLOSSARY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_link_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return glossaryEntity.getGUID();
    }

    protected String addCategory(String glossaryId, String qualifiedName, String displayName, String description, String subjectArea) {
        String methodName = "addCategory";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addCategory");
        ArrayList<Classification> classifications = null;
        if (subjectArea != null) {
            Classification subjectAreaClassification = this.archiveHelper.getClassification(SUBJECT_AREA_TYPE_NAME, this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, NAME_PROPERTY, subjectArea, "addCategory"), InstanceStatus.ACTIVE);
            classifications = new ArrayList<Classification>();
            classifications.add(subjectAreaClassification);
        }
        EntityDetail categoryEntity = this.archiveHelper.getEntityDetail(GLOSSARY_CATEGORY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(categoryEntity);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(glossaryId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(categoryEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CATEGORY_ANCHOR_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_anchor_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        return categoryEntity.getGUID();
    }

    protected String addTerm(String glossaryId, List<String> categoryIds, String qualifiedName, String displayName, String description) {
        return this.addTerm(glossaryId, categoryIds, qualifiedName, displayName, description, null, false, false, false);
    }

    protected String addTerm(String glossaryId, List<String> categoryIds, String qualifiedName, String displayName, String description, String examples, boolean isSpineObject, boolean isSpineAttribute, boolean categoriesAsNames) {
        Classification subjectAreaClassification;
        String methodName = "addTerm";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addTerm");
        if (examples != null) {
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, EXAMPLES_PROPERTY, examples, "addTerm");
        }
        ArrayList<Classification> classifications = null;
        if (isSpineObject) {
            subjectAreaClassification = this.archiveHelper.getClassification(SPINE_OBJECT_NAME, null, InstanceStatus.ACTIVE);
            classifications = new ArrayList<Classification>();
            classifications.add(subjectAreaClassification);
        }
        if (isSpineAttribute) {
            subjectAreaClassification = this.archiveHelper.getClassification(SPINE_ATTRIBUTE_NAME, null, InstanceStatus.ACTIVE);
            classifications = new ArrayList();
            classifications.add(subjectAreaClassification);
        }
        EntityDetail termEntity = this.archiveHelper.getEntityDetail(GLOSSARY_TERM_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(termEntity);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(glossaryId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(termEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("TermAnchor", this.idToGUIDMap.getGUID(qualifiedName + "_anchor_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        if (categoryIds != null) {
            for (String categoryId : categoryIds) {
                if (categoryId == null) continue;
                if (categoriesAsNames) {
                    categoryId = this.idToGUIDMap.getGUID(categoryId);
                }
                end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(categoryId));
                this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(TERM_CATEGORIZATION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_category_" + categoryId + "_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
            }
        }
        return termEntity.getGUID();
    }

    protected void addCategoryToCategory(String parentCategoryId, String childCategoryId) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(parentCategoryId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(childCategoryId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CATEGORY_HIERARCHY_LINK_TYPE_NAME, this.idToGUIDMap.getGUID(parentCategoryId + "_to_" + childCategoryId), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addMoreInformationLink(String describedElementId, String describerElementId) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(describedElementId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(describerElementId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(MORE_INFORMATION_TYPE_NAME, this.idToGUIDMap.getGUID(describedElementId + "_to_" + describerElementId), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void linkTermToReferenceable(String termId, String referenceableId) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(referenceableId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("TermAnchor", this.idToGUIDMap.getGUID(referenceableId + "_to_" + termId), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected String addDesignModel(String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author) {
        String methodName = "addDesignModel";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TECHNICAL_NAME_PROPERTY, technicalName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_NUMBER_PROPERTY, versionNumber, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, AUTHOR_PROPERTY, author, "addDesignModel");
        EntityDetail modelEntity = this.archiveHelper.getEntityDetail(DESIGN_MODEL_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(modelEntity);
        return modelEntity.getGUID();
    }

    protected String addDesignModelGroup(String modelId, String parentGroupId, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author) {
        EntityProxy end2;
        EntityProxy end1;
        String methodName = "addDesignModelGroup";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addDesignModelGroup");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addDesignModelGroup");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TECHNICAL_NAME_PROPERTY, technicalName, "addDesignModelGroup");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addDesignModelGroup");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_NUMBER_PROPERTY, versionNumber, "addDesignModelGroup");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, AUTHOR_PROPERTY, author, "addDesignModelGroup");
        EntityDetail modelGroupEntity = this.archiveHelper.getEntityDetail(DESIGN_MODEL_GROUP_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(modelGroupEntity);
        if (modelId != null) {
            end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(modelId));
            end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(modelGroupEntity.getGUID()));
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_ELEMENT_OWNERSHIP_TYPE_NAME, this.idToGUIDMap.getGUID(modelId + "_to_" + modelGroupEntity.getGUID()), null, InstanceStatus.ACTIVE, end1, end2));
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_OWNERSHIP_TYPE_NAME, this.idToGUIDMap.getGUID(modelId + "_to_" + modelGroupEntity.getGUID()), null, InstanceStatus.ACTIVE, end1, end2));
        }
        if (parentGroupId != null) {
            end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(parentGroupId));
            end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(modelGroupEntity.getGUID()));
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_HIERARCHY_TYPE_NAME, this.idToGUIDMap.getGUID(parentGroupId + "_to_" + modelGroupEntity.getGUID()), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return modelGroupEntity.getGUID();
    }

    protected String addConceptModelElement(String typeName, String modelId, List<String> groupIds, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author) {
        String methodName = "addConceptModelElement";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConceptModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConceptModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TECHNICAL_NAME_PROPERTY, technicalName, "addConceptModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConceptModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_NUMBER_PROPERTY, versionNumber, "addConceptModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, AUTHOR_PROPERTY, author, "addConceptModelElement");
        EntityDetail modelElementEntity = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(modelElementEntity);
        if (modelId != null) {
            EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(modelId));
            EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(modelElementEntity.getGUID()));
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_ELEMENT_OWNERSHIP_TYPE_NAME, this.idToGUIDMap.getGUID(modelId + "_to_" + modelElementEntity.getGUID()), null, InstanceStatus.ACTIVE, end1, end2));
        }
        if (groupIds != null) {
            for (String groupId : groupIds) {
                EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(groupId));
                EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(modelElementEntity.getGUID()));
                this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_MEMBERSHIP_TYPE_NAME, this.idToGUIDMap.getGUID(groupId + "_to_" + modelElementEntity.getGUID()), null, InstanceStatus.ACTIVE, end1, end2));
            }
        }
        return modelElementEntity.getGUID();
    }

    protected String addConceptBead(String modelId, List<String> groupIds, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author) {
        return this.addConceptModelElement(CONCEPT_BEAD_TYPE_NAME, modelId, groupIds, qualifiedName, displayName, technicalName, description, versionNumber, author);
    }

    protected String addConceptBeadLink(String modelId, List<String> groupIds, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author) {
        return this.addConceptModelElement(CONCEPT_BEAD_LINK_TYPE_NAME, modelId, groupIds, qualifiedName, displayName, technicalName, description, versionNumber, author);
    }

    protected String addConceptBeadAttribute(String modelId, List<String> groupIds, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author) {
        return this.addConceptModelElement(CONCEPT_BEAD_ATTRIBUTE_TYPE_NAME, modelId, groupIds, qualifiedName, displayName, technicalName, description, versionNumber, author);
    }

    protected void addAttributeToBead(String beadId, String attributeId, int position, int minCardinality, int maxCardinality, boolean uniqueValues, boolean orderedValues) {
        String methodName = "addAttributeToBead";
        InstanceProperties properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, null, POSITION_PROPERTY, position, "addAttributeToBead");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MIN_CARDINALITY_PROPERTY, minCardinality, "addAttributeToBead");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MAX_CARDINALITY_PROPERTY, maxCardinality, "addAttributeToBead");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, UNIQUE_VALUES_PROPERTY, uniqueValues, "addAttributeToBead");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, ORDERED_VALUES_PROPERTY, orderedValues, "addAttributeToBead");
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(beadId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(attributeId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONCEPT_BEAD_ATTRIBUTE_LINK_TYPE_NAME, this.idToGUIDMap.getGUID(beadId + "_to_" + attributeId), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addLinkToBead(String beadId, String linkId, String attributeName, ConceptModelDecoration decoration, int position, int minCardinality, int maxCardinality, boolean uniqueValues, boolean orderedValues) {
        String methodName = "addLinkToBead";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, ATTRIBUTE_NAME_PROPERTY, attributeName, "addLinkToBead");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, POSITION_PROPERTY, position, "addLinkToBead");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MIN_CARDINALITY_PROPERTY, minCardinality, "addLinkToBead");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MAX_CARDINALITY_PROPERTY, maxCardinality, "addLinkToBead");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, UNIQUE_VALUES_PROPERTY, uniqueValues, "addLinkToBead");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, ORDERED_VALUES_PROPERTY, orderedValues, "addLinkToBead");
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(beadId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(linkId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONCEPT_BEAD_RELATIONSHIP_TYPE_NAME, this.idToGUIDMap.getGUID(beadId + "_to_" + linkId), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addIsATypeOfRelationship(String specialTermQName, String generalizedTermQName) {
        String specializedTermId = this.idToGUIDMap.getGUID(specialTermQName);
        String generalizedTermId = this.idToGUIDMap.getGUID(generalizedTermQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(specializedTermId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(generalizedTermId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(IS_A_TYPE_OF_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(specializedTermId + "_to_" + generalizedTermId), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addHasARelationship(String conceptQName, String propertyQName) {
        String conceptId = this.idToGUIDMap.getGUID(conceptQName);
        String propertyId = this.idToGUIDMap.getGUID(propertyQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(propertyId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(conceptId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(HAS_A_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(conceptId + "_to_" + propertyId + "_hasa"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addRelatedTermRelationship(String conceptQName, String propertyQName) {
        String conceptId = this.idToGUIDMap.getGUID(conceptQName);
        String propertyId = this.idToGUIDMap.getGUID(propertyQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(conceptId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(propertyId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(RELATED_TERM_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(conceptId + "_to_" + propertyId + "_related"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    protected void addCategoryHierarchy(String childCategoryName, Set<String> parentNames) {
        String childId = this.idToGUIDMap.getGUID(childCategoryName);
        for (String parentName : parentNames) {
            String parentId = this.idToGUIDMap.getGUID(parentName);
            this.addCategoryToCategory(parentId, childId);
        }
    }
}

