/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.SchemaExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.LineageExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ControlFlowElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataFlowElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.LineageMappingElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.PortElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessCallElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.PortProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessContainmentType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ProcessStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.catalog.connector.SchemaExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class LineageExchangeService
extends SchemaExchangeService {
    private LineageExchangeClient lineageExchangeClient;

    LineageExchangeService(LineageExchangeClient lineageExchangeClient, SynchronizationDirection synchronizationDirection, String userId, String assetManagerGUID, String assetManagerName, String connectorName, AuditLog auditLog) {
        super((SchemaExchangeInterface)lineageExchangeClient, synchronizationDirection, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.lineageExchangeClient = lineageExchangeClient;
    }

    public String createProcess(boolean assetManagerIsHome, String processExternalIdentifier, String processExternalIdentifierName, String processExternalIdentifierUsage, KeyPattern processExternalIdentifierKeyPattern, Map<String, String> mappingProperties, ProcessProperties processProperties, ProcessStatus initialStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.lineageExchangeClient.createProcess(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, processExternalIdentifier, processExternalIdentifierName, processExternalIdentifierUsage, this.connectorName, processExternalIdentifierKeyPattern, mappingProperties, processProperties, initialStatus);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createProcess"), this.getClass().getName(), "createProcess", this.userId);
    }

    public String createProcessFromTemplate(boolean assetManagerIsHome, String templateGUID, String processExternalIdentifier, String processExternalIdentifierName, String processExternalIdentifierUsage, KeyPattern processExternalIdentifierKeyPattern, Map<String, String> mappingProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcessFromTemplate";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.lineageExchangeClient.createProcessFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, templateGUID, processExternalIdentifier, processExternalIdentifierName, processExternalIdentifierUsage, this.connectorName, processExternalIdentifierKeyPattern, mappingProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createProcessFromTemplate"), this.getClass().getName(), "createProcessFromTemplate", this.userId);
    }

    public void updateProcess(String processGUID, String processExternalIdentifier, boolean isMergeUpdate, ProcessProperties processProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcess";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateProcess"), this.getClass().getName(), "updateProcess", this.userId);
        }
        this.lineageExchangeClient.updateProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, processExternalIdentifier, isMergeUpdate, processProperties);
    }

    public void updateProcessStatus(String processGUID, String processExternalIdentifier, ProcessStatus processStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessStatus";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateProcessStatus"), this.getClass().getName(), "updateProcessStatus", this.userId);
        }
        this.lineageExchangeClient.updateProcessStatus(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, processExternalIdentifier, processStatus);
    }

    public void setupProcessParent(boolean assetManagerIsHome, String parentProcessGUID, String childProcessGUID, ProcessContainmentType containmentType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessParent";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupProcessParent"), this.getClass().getName(), "setupProcessParent", this.userId);
        }
        this.lineageExchangeClient.setupProcessParent(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, parentProcessGUID, childProcessGUID, containmentType);
    }

    public void clearProcessParent(String parentProcessGUID, String childProcessGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessParent";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearProcessParent"), this.getClass().getName(), "clearProcessParent", this.userId);
        }
        this.lineageExchangeClient.clearProcessParent(this.userId, this.assetManagerGUID, this.assetManagerName, parentProcessGUID, childProcessGUID);
    }

    public void publishProcess(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishProcess";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "publishProcess"), this.getClass().getName(), "publishProcess", this.userId);
        }
        this.lineageExchangeClient.publishProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID);
    }

    public void withdrawProcess(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawProcess";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "withdrawProcess"), this.getClass().getName(), "withdrawProcess", this.userId);
        }
        this.lineageExchangeClient.withdrawProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID);
    }

    public void removeProcess(String processGUID, String processExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeProcess";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeProcess"), this.getClass().getName(), "removeProcess", this.userId);
        }
        this.lineageExchangeClient.removeProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, processExternalIdentifier);
    }

    public List<ProcessElement> findProcesses(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.findProcesses(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize);
    }

    public List<ProcessElement> getProcessesForAssetManager(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessesForAssetManager(this.userId, this.assetManagerGUID, this.assetManagerName, startFrom, pageSize);
    }

    public List<ProcessElement> getProcessesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessesByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize);
    }

    public ProcessElement getProcessByGUID(String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID);
    }

    public ProcessElement getProcessParent(String assetManagerGUID, String assetManagerName, String processGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessParent(this.userId, assetManagerGUID, assetManagerName, processGUID);
    }

    public List<ProcessElement> getSubProcesses(String processGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getSubProcesses(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, startFrom, pageSize);
    }

    public String createPort(boolean assetManagerIsHome, String processGUID, String portExternalIdentifier, String portExternalIdentifierName, String portExternalIdentifierUsage, KeyPattern portExternalIdentifierKeyPattern, Map<String, String> mappingProperties, PortProperties portProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createPort";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.lineageExchangeClient.createPort(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, processGUID, portExternalIdentifier, portExternalIdentifierName, portExternalIdentifierUsage, this.connectorName, portExternalIdentifierKeyPattern, mappingProperties, portProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createPort"), this.getClass().getName(), "createPort", this.userId);
    }

    public void updatePort(String portGUID, String portExternalIdentifier, PortProperties portProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updatePort";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updatePort"), this.getClass().getName(), "updatePort", this.userId);
        }
        this.lineageExchangeClient.updatePort(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, portExternalIdentifier, portProperties);
    }

    public void setupProcessPort(boolean assetManagerIsHome, String processGUID, String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessPort";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupProcessPort"), this.getClass().getName(), "setupProcessPort", this.userId);
        }
        this.lineageExchangeClient.setupProcessPort(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, processGUID, portGUID);
    }

    public void clearProcessPort(String processGUID, String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessPort";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearProcessPort"), this.getClass().getName(), "clearProcessPort", this.userId);
        }
        this.lineageExchangeClient.clearProcessPort(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, portGUID);
    }

    public void setupPortDelegation(boolean assetManagerIsHome, String portOneGUID, String portTwoGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupPortDelegation";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupPortDelegation"), this.getClass().getName(), "setupPortDelegation", this.userId);
        }
        this.lineageExchangeClient.setupPortDelegation(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, portOneGUID, portTwoGUID);
    }

    public void clearPortDelegation(String portOneGUID, String portTwoGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearPortDelegation";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearPortDelegation"), this.getClass().getName(), "clearPortDelegation", this.userId);
        }
        this.lineageExchangeClient.clearPortDelegation(this.userId, this.assetManagerGUID, this.assetManagerName, portOneGUID, portTwoGUID);
    }

    public void setupPortSchemaType(boolean assetManagerIsHome, String portGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupPortSchemaType";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupPortSchemaType"), this.getClass().getName(), "setupPortSchemaType", this.userId);
        }
        this.lineageExchangeClient.setupPortSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, portGUID, schemaTypeGUID);
    }

    public void clearPortSchemaType(String portGUID, String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearPortSchemaType";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearPortSchemaType"), this.getClass().getName(), "clearPortSchemaType", this.userId);
        }
        this.lineageExchangeClient.clearPortSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, schemaTypeGUID);
    }

    public void removePort(String portGUID, String portExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removePort";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removePort"), this.getClass().getName(), "removePort", this.userId);
        }
        this.lineageExchangeClient.removePort(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, portExternalIdentifier);
    }

    public List<PortElement> findPorts(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.findPorts(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize);
    }

    public List<PortElement> getPortsForProcess(String processGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortsForProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, startFrom, pageSize);
    }

    public List<PortElement> getPortUse(String portGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortUse(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, startFrom, pageSize);
    }

    public PortElement getPortDelegation(String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortDelegation(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID);
    }

    public List<PortElement> getPortsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortsByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize);
    }

    public PortElement getPortByGUID(String portGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID);
    }

    public void setBusinessSignificant(String elementGUID, String elementExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setBusinessSignificant";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setBusinessSignificant"), this.getClass().getName(), "setBusinessSignificant", this.userId);
        }
        this.lineageExchangeClient.setBusinessSignificant(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, elementExternalIdentifier);
    }

    public void clearBusinessSignificant(String elementGUID, String elementExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearBusinessSignificant";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearBusinessSignificant"), this.getClass().getName(), "clearBusinessSignificant", this.userId);
        }
        this.lineageExchangeClient.clearBusinessSignificant(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, elementExternalIdentifier);
    }

    public String setupDataFlow(boolean assetManagerIsHome, String dataSupplierGUID, String dataConsumerGUID, String qualifiedName, String description, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupDataFlow";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.lineageExchangeClient.setupDataFlow(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, dataSupplierGUID, dataConsumerGUID, qualifiedName, description, formula);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupDataFlow"), this.getClass().getName(), "setupDataFlow", this.userId);
    }

    public DataFlowElement getDataFlow(String dataSupplierGUID, String dataConsumerGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDataFlow(this.userId, this.assetManagerGUID, this.assetManagerName, dataSupplierGUID, dataConsumerGUID, qualifiedName);
    }

    public void updateDataFlow(String dataFlowGUID, String qualifiedName, String description, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataFlow";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateDataFlow"), this.getClass().getName(), "updateDataFlow", this.userId);
        }
        this.lineageExchangeClient.updateDataFlow(this.userId, this.assetManagerGUID, this.assetManagerName, dataFlowGUID, qualifiedName, description, formula);
    }

    public void clearDataFlow(String dataFlowGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearDataFlow";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearDataFlow"), this.getClass().getName(), "clearDataFlow", this.userId);
        }
        this.lineageExchangeClient.clearDataFlow(this.userId, this.assetManagerGUID, this.assetManagerName, dataFlowGUID);
    }

    public List<DataFlowElement> getDataFlowConsumers(String dataSupplierGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDataFlowConsumers(this.userId, this.assetManagerGUID, this.assetManagerName, dataSupplierGUID);
    }

    public List<DataFlowElement> getDataFlowSuppliers(String dataConsumerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDataFlowSuppliers(this.userId, this.assetManagerGUID, this.assetManagerName, dataConsumerGUID);
    }

    public String setupControlFlow(boolean assetManagerIsHome, String currentStepGUID, String nextStepGUID, String qualifiedName, String description, String guard) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupControlFlow";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.lineageExchangeClient.setupControlFlow(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, currentStepGUID, nextStepGUID, qualifiedName, description, guard);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupControlFlow"), this.getClass().getName(), "setupControlFlow", this.userId);
    }

    public ControlFlowElement getControlFlow(String currentStepGUID, String nextStepGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getControlFlow(this.userId, this.assetManagerGUID, this.assetManagerName, currentStepGUID, nextStepGUID, qualifiedName);
    }

    public void updateControlFlow(String controlFlowGUID, String qualifiedName, String description, String guard) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateControlFlow";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateControlFlow"), this.getClass().getName(), "updateControlFlow", this.userId);
        }
        this.lineageExchangeClient.updateControlFlow(this.userId, this.assetManagerGUID, this.assetManagerName, controlFlowGUID, qualifiedName, description, guard);
    }

    public void clearControlFlow(String assetManagerGUID, String assetManagerName, String controlFlowGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearControlFlow";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearControlFlow"), this.getClass().getName(), "clearControlFlow", this.userId);
        }
        this.lineageExchangeClient.clearControlFlow(this.userId, assetManagerGUID, assetManagerName, controlFlowGUID);
    }

    public List<ControlFlowElement> getControlFlowNextSteps(String currentStepGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getControlFlowNextSteps(this.userId, this.assetManagerGUID, this.assetManagerName, currentStepGUID);
    }

    public List<ControlFlowElement> getControlFlowPreviousSteps(String currentStepGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getControlFlowPreviousSteps(this.userId, this.assetManagerGUID, this.assetManagerName, currentStepGUID);
    }

    public String setupProcessCall(boolean assetManagerIsHome, String callerGUID, String calledGUID, String qualifiedName, String description, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessCall";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.lineageExchangeClient.setupProcessCall(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, callerGUID, calledGUID, qualifiedName, description, formula);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupProcessCall"), this.getClass().getName(), "setupProcessCall", this.userId);
    }

    public ProcessCallElement getProcessCall(String callerGUID, String calledGUID, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessCall(this.userId, this.assetManagerGUID, this.assetManagerName, callerGUID, calledGUID, qualifiedName);
    }

    public void updateProcessCall(String processCallGUID, String qualifiedName, String description, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessCall";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateProcessCall"), this.getClass().getName(), "updateProcessCall", this.userId);
        }
        this.lineageExchangeClient.updateProcessCall(this.userId, this.assetManagerGUID, this.assetManagerName, processCallGUID, qualifiedName, description, formula);
    }

    public void clearProcessCall(String processCallGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessCall";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearProcessCall"), this.getClass().getName(), "clearProcessCall", this.userId);
        }
        this.lineageExchangeClient.clearProcessCall(this.userId, this.assetManagerGUID, this.assetManagerName, processCallGUID);
    }

    public List<ProcessCallElement> getProcessCalled(String callerGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessCalled(this.userId, this.assetManagerGUID, this.assetManagerName, callerGUID);
    }

    public List<ProcessCallElement> getProcessCallers(String calledGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessCallers(this.userId, this.assetManagerGUID, this.assetManagerName, calledGUID);
    }

    public void setupLineageMapping(String sourceElementGUID, String destinationElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupLineageMapping";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupLineageMapping"), this.getClass().getName(), "setupLineageMapping", this.userId);
        }
        this.lineageExchangeClient.setupLineageMapping(this.userId, this.assetManagerGUID, this.assetManagerName, sourceElementGUID, destinationElementGUID);
    }

    public void clearLineageMapping(String sourceElementGUID, String destinationElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLineageMapping";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearLineageMapping"), this.getClass().getName(), "clearLineageMapping", this.userId);
        }
        this.lineageExchangeClient.clearLineageMapping(this.userId, this.assetManagerGUID, this.assetManagerName, sourceElementGUID, destinationElementGUID);
    }

    public List<LineageMappingElement> getDestinationLineageMappings(String sourceElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDestinationLineageMappings(this.userId, this.assetManagerGUID, this.assetManagerName, sourceElementGUID);
    }

    public List<LineageMappingElement> getSourceLineageMappings(String destinationElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getSourceLineageMappings(this.userId, this.assetManagerGUID, this.assetManagerName, destinationElementGUID);
    }
}

