/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExternalReferenceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalReferenceElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalReferenceLinkElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalReferenceLinkProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalReferenceProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class ExternalReferenceExchangeService {
    private ExternalReferenceExchangeClient externalReferenceClient;
    private String userId;
    private String assetManagerGUID;
    private String assetManagerName;
    private String connectorName;
    private SynchronizationDirection synchronizationDirection;
    private AuditLog auditLog;
    private boolean assetManagerIsHome = true;

    ExternalReferenceExchangeService(ExternalReferenceExchangeClient externalReferenceClient, SynchronizationDirection synchronizationDirection, String userId, String assetManagerGUID, String assetManagerName, String connectorName, AuditLog auditLog) {
        this.externalReferenceClient = externalReferenceClient;
        this.synchronizationDirection = synchronizationDirection;
        this.userId = userId;
        this.assetManagerGUID = assetManagerGUID;
        this.assetManagerName = assetManagerName;
        this.connectorName = connectorName;
        this.auditLog = auditLog;
    }

    public void setAssetManagerIsHome(boolean assetManagerIsHome) {
        this.assetManagerIsHome = assetManagerIsHome;
    }

    public String createExternalReference(String referenceExternalIdentifier, String referenceExternalIdentifierName, String referenceExternalIdentifierUsage, KeyPattern referenceExternalIdentifierKeyPattern, Map<String, String> mappingProperties, String anchorGUID, ExternalReferenceProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalReference";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.externalReferenceClient.createExternalReference(this.userId, this.assetManagerGUID, this.assetManagerName, this.assetManagerIsHome, referenceExternalIdentifier, referenceExternalIdentifierName, referenceExternalIdentifierUsage, this.connectorName, referenceExternalIdentifierKeyPattern, mappingProperties, anchorGUID, properties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createExternalReference"), this.getClass().getName(), "createExternalReference", this.userId);
    }

    public void updateExternalReference(String externalReferenceGUID, String referenceExternalIdentifier, boolean isMergeUpdate, ExternalReferenceProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateExternalReference";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateExternalReference"), this.getClass().getName(), "updateExternalReference", this.userId);
        }
        this.externalReferenceClient.updateExternalReference(this.userId, this.assetManagerGUID, this.assetManagerName, externalReferenceGUID, referenceExternalIdentifier, isMergeUpdate, properties);
    }

    public void deleteExternalReference(String externalReferenceGUID, String referenceExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteExternalReference";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "deleteExternalReference"), this.getClass().getName(), "deleteExternalReference", this.userId);
        }
        this.externalReferenceClient.deleteExternalReference(this.userId, this.assetManagerGUID, this.assetManagerName, externalReferenceGUID, referenceExternalIdentifier);
    }

    public String linkExternalReferenceToElement(String attachedToGUID, String externalReferenceGUID, ExternalReferenceLinkProperties linkProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkExternalReferenceToElement";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.externalReferenceClient.linkExternalReferenceToElement(this.userId, this.assetManagerGUID, this.assetManagerName, this.assetManagerIsHome, attachedToGUID, externalReferenceGUID, linkProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "linkExternalReferenceToElement"), this.getClass().getName(), "linkExternalReferenceToElement", this.userId);
    }

    public void updateExternalReferenceToElementLink(String externalReferenceLinkGUID, ExternalReferenceLinkProperties linkProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkExternalReferenceToElement";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "linkExternalReferenceToElement"), this.getClass().getName(), "linkExternalReferenceToElement", this.userId);
        }
        this.externalReferenceClient.updateExternalReferenceToElementLink(this.userId, this.assetManagerGUID, this.assetManagerName, externalReferenceLinkGUID, linkProperties);
    }

    public void unlinkExternalReferenceFromElement(String externalReferenceLinkGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "unlinkExternalReferenceFromElement";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "unlinkExternalReferenceFromElement"), this.getClass().getName(), "unlinkExternalReferenceFromElement", this.userId);
        }
        this.externalReferenceClient.unlinkExternalReferenceFromElement(this.userId, this.assetManagerGUID, this.assetManagerName, externalReferenceLinkGUID);
    }

    public List<ExternalReferenceElement> getExternalReferences(Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalReferenceClient.getExternalReferences(this.userId, this.assetManagerGUID, this.assetManagerName, effectiveTime, startFrom, pageSize);
    }

    public List<ExternalReferenceElement> getExternalReferencesById(String resourceId, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalReferenceClient.getExternalReferencesById(this.userId, this.assetManagerGUID, this.assetManagerName, resourceId, effectiveTime, startFrom, pageSize);
    }

    public List<ExternalReferenceElement> getExternalReferencesByURL(String url, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalReferenceClient.getExternalReferencesByURL(this.userId, this.assetManagerGUID, this.assetManagerName, url, effectiveTime, startFrom, pageSize);
    }

    public List<ExternalReferenceElement> getExternalReferencesByName(String name, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalReferenceClient.getExternalReferencesByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, effectiveTime, startFrom, pageSize);
    }

    public List<ExternalReferenceElement> getExternalReferencesForAssetManager(Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.externalReferenceClient.getExternalReferencesForAssetManager(this.userId, this.assetManagerGUID, this.assetManagerName, effectiveTime, startFrom, pageSize);
    }

    public List<ExternalReferenceElement> findExternalReferences(String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalReferenceClient.findExternalReferences(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, effectiveTime, startFrom, pageSize);
    }

    public List<ExternalReferenceLinkElement> retrieveAttachedExternalReferences(String attachedToGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalReferenceClient.retrieveAttachedExternalReferences(this.userId, this.assetManagerGUID, this.assetManagerName, attachedToGUID, effectiveTime, startFrom, pageSize);
    }

    public ExternalReferenceElement getExternalReferenceByGUID(Date effectiveTime, String externalReferenceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.externalReferenceClient.getExternalReferenceByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, externalReferenceGUID, effectiveTime);
    }
}

