/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.client.ConnectionExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetConnectionProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.EmbeddedConnectionProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class ConnectionExchangeService {
    private final ConnectionExchangeClient connectionExchangeClient;
    private final String userId;
    private final String externalSourceGUID;
    private final String externalSourceName;
    private final String connectorName;
    private final SynchronizationDirection synchronizationDirection;
    private final AuditLog auditLog;
    private boolean forLineage = false;
    private final boolean forDuplicateProcessing = false;

    ConnectionExchangeService(ConnectionExchangeClient connectionExchangeClient, SynchronizationDirection synchronizationDirection, String userId, String externalSourceGUID, String externalSourceName, String connectorName, AuditLog auditLog) {
        this.connectionExchangeClient = connectionExchangeClient;
        this.synchronizationDirection = synchronizationDirection;
        this.userId = userId;
        this.externalSourceGUID = externalSourceGUID;
        this.externalSourceName = externalSourceName;
        this.connectorName = connectorName;
        this.auditLog = auditLog;
    }

    public boolean isForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    public String createConnection(boolean externalSourceIsHome, ExternalIdentifierProperties externalIdentifierProperties, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnection";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.connectionExchangeClient.createConnection(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, externalIdentifierProperties, connectionProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createConnection"), this.getClass().getName(), "createConnection", this.userId);
    }

    public String createConnectionFromTemplate(boolean externalSourceIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectionFromTemplate";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.connectionExchangeClient.createConnectionFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, templateGUID, externalIdentifierProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createConnectionFromTemplate"), this.getClass().getName(), "createConnectionFromTemplate", this.userId);
    }

    public void updateConnection(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionExternalIdentifier, boolean isMergeUpdate, ConnectionProperties connectionProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnection";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateConnection"), this.getClass().getName(), "updateConnection", userId);
        }
        this.connectionExchangeClient.updateConnection(userId, externalSourceGUID, externalSourceName, connectionGUID, connectionExternalIdentifier, isMergeUpdate, connectionProperties, effectiveTime, this.forLineage, false);
    }

    public void setupConnectorType(String userId, boolean externalSourceIsHome, String connectionGUID, String connectorTypeGUID, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupConnectorType";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupConnectorType"), this.getClass().getName(), "setupConnectorType", userId);
        }
        this.connectionExchangeClient.setupConnectorType(userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, connectionGUID, connectorTypeGUID, effectiveFrom, effectiveTo, effectiveTime, this.forLineage, false);
    }

    public void clearConnectorType(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectorTypeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConnectorType";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearConnectorType"), this.getClass().getName(), "clearConnectorType", userId);
        }
        this.connectionExchangeClient.clearConnectorType(userId, externalSourceGUID, externalSourceName, connectionGUID, connectorTypeGUID, effectiveTime, this.forLineage, false);
    }

    public void setupEndpoint(String userId, String externalSourceGUID, String externalSourceName, boolean externalSourceIsHome, String connectionGUID, String endpointGUID, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEndpoint";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupEndpoint"), this.getClass().getName(), "setupEndpoint", userId);
        }
        this.connectionExchangeClient.setupEndpoint(userId, externalSourceGUID, externalSourceName, externalSourceIsHome, connectionGUID, endpointGUID, effectiveFrom, effectiveTo, effectiveTime, this.forLineage, false);
    }

    public void clearEndpoint(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String endpointGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEndpoint";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearEndpoint"), this.getClass().getName(), "clearEndpoint", userId);
        }
        this.connectionExchangeClient.clearEndpoint(userId, externalSourceGUID, externalSourceName, connectionGUID, endpointGUID, effectiveTime, this.forLineage, false);
    }

    public void setupEmbeddedConnection(String userId, String externalSourceGUID, String externalSourceName, boolean externalSourceIsHome, String connectionGUID, String embeddedConnectionGUID, EmbeddedConnectionProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEmbeddedConnection";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupEmbeddedConnection"), this.getClass().getName(), "setupEmbeddedConnection", userId);
        }
        this.connectionExchangeClient.setupEmbeddedConnection(userId, externalSourceGUID, externalSourceName, externalSourceIsHome, connectionGUID, embeddedConnectionGUID, properties, effectiveTime, this.forLineage, false);
    }

    public void clearEmbeddedConnection(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String embeddedConnectionGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEmbeddedConnection";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearEmbeddedConnection"), this.getClass().getName(), "clearEmbeddedConnection", userId);
        }
        this.connectionExchangeClient.clearEmbeddedConnection(userId, externalSourceGUID, externalSourceName, connectionGUID, embeddedConnectionGUID, effectiveTime, this.forLineage, false);
    }

    public void setupAssetConnection(String userId, String externalSourceGUID, String externalSourceName, boolean externalSourceIsHome, String assetGUID, String connectionGUID, AssetConnectionProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAssetConnection";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupAssetConnection"), this.getClass().getName(), "setupAssetConnection", userId);
        }
        this.connectionExchangeClient.setupAssetConnection(userId, externalSourceGUID, externalSourceName, externalSourceIsHome, assetGUID, connectionGUID, properties, effectiveTime, this.forLineage, false);
    }

    public void clearAssetConnection(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String connectionGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetConnection";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearAssetConnection"), this.getClass().getName(), "clearAssetConnection", userId);
        }
        this.connectionExchangeClient.clearAssetConnection(userId, externalSourceGUID, externalSourceName, assetGUID, connectionGUID, effectiveTime, this.forLineage, false);
    }

    public void removeConnection(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, String connectionExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnection";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeConnection"), this.getClass().getName(), "removeConnection", userId);
        }
        this.connectionExchangeClient.removeConnection(userId, externalSourceGUID, externalSourceName, connectionGUID, connectionExternalIdentifier, effectiveTime, this.forLineage, false);
    }

    public List<ConnectionElement> findConnections(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.findConnections(this.userId, this.externalSourceGUID, this.externalSourceName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<ConnectionElement> getConnectionsByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getConnectionsByName(this.userId, this.externalSourceGUID, this.externalSourceName, name, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<ConnectionElement> getConnectionsForAssetManager(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getConnectionsForAssetManager(this.userId, this.externalSourceGUID, this.externalSourceName, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public ConnectionElement getConnectionByGUID(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getConnectionByGUID(userId, externalSourceGUID, externalSourceName, connectionGUID, effectiveTime, this.forLineage, false);
    }

    public String createEndpoint(boolean externalSourceIsHome, ExternalIdentifierProperties externalIdentifierProperties, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpoint";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.connectionExchangeClient.createEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, externalIdentifierProperties, endpointProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createEndpoint"), this.getClass().getName(), "createEndpoint", this.userId);
    }

    public String createEndpointFromTemplate(boolean externalSourceIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpointFromTemplate";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.connectionExchangeClient.createEndpointFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, templateGUID, externalIdentifierProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createEndpointFromTemplate"), this.getClass().getName(), "createEndpointFromTemplate", this.userId);
    }

    public void updateEndpoint(String userId, String externalSourceGUID, String externalSourceName, String connectorTypeGUID, String endpointExternalIdentifier, boolean isMergeUpdate, EndpointProperties endpointProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEndpoint";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateEndpoint"), this.getClass().getName(), "updateEndpoint", userId);
        }
        this.connectionExchangeClient.updateEndpoint(userId, externalSourceGUID, externalSourceName, connectorTypeGUID, endpointExternalIdentifier, isMergeUpdate, endpointProperties, effectiveTime, this.forLineage, false);
    }

    public void removeEndpoint(String userId, String externalSourceGUID, String externalSourceName, String connectorTypeGUID, String endpointExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeEndpoint";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeEndpoint"), this.getClass().getName(), "removeEndpoint", userId);
        }
        this.connectionExchangeClient.removeEndpoint(userId, externalSourceGUID, externalSourceName, connectorTypeGUID, endpointExternalIdentifier, effectiveTime, this.forLineage, false);
    }

    public List<EndpointElement> findEndpoints(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.findEndpoints(this.userId, this.externalSourceGUID, this.externalSourceName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<EndpointElement> getEndpointsByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getEndpointsByName(this.userId, this.externalSourceGUID, this.externalSourceName, name, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<EndpointElement> getEndpointsForAssetManager(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getEndpointsForAssetManager(this.userId, this.externalSourceGUID, this.externalSourceName, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public EndpointElement getEndpointByGUID(String userId, String externalSourceGUID, String externalSourceName, String endpointGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getEndpointByGUID(userId, externalSourceGUID, externalSourceName, endpointGUID, effectiveTime, this.forLineage, false);
    }

    public String createConnectorType(boolean externalSourceIsHome, ExternalIdentifierProperties externalIdentifierProperties, ConnectorTypeProperties connectorTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectorType";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.connectionExchangeClient.createConnectorType(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, externalIdentifierProperties, connectorTypeProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createConnectorType"), this.getClass().getName(), "createConnectorType", this.userId);
    }

    public String createConnectorTypeFromTemplate(boolean externalSourceIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectorTypeFromTemplate";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.connectionExchangeClient.createConnectorTypeFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, templateGUID, externalIdentifierProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createConnectorTypeFromTemplate"), this.getClass().getName(), "createConnectorTypeFromTemplate", this.userId);
    }

    public void updateConnectorType(String userId, String externalSourceGUID, String externalSourceName, String connectorTypeGUID, String connectorTypeExternalIdentifier, boolean isMergeUpdate, ConnectorTypeProperties connectorTypeProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnectorType";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateConnectorType"), this.getClass().getName(), "updateConnectorType", userId);
        }
        this.connectionExchangeClient.updateConnectorType(userId, externalSourceGUID, externalSourceName, connectorTypeGUID, connectorTypeExternalIdentifier, isMergeUpdate, connectorTypeProperties, effectiveTime, this.forLineage, false);
    }

    public void removeConnectorType(String userId, String externalSourceGUID, String externalSourceName, String connectorTypeGUID, String connectorTypeExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnectorType";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeConnectorType"), this.getClass().getName(), "removeConnectorType", userId);
        }
        this.connectionExchangeClient.removeConnectorType(userId, externalSourceGUID, externalSourceName, connectorTypeGUID, connectorTypeExternalIdentifier, effectiveTime, this.forLineage, false);
    }

    public List<ConnectorTypeElement> findConnectorTypes(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.findConnectorTypes(this.userId, this.externalSourceGUID, this.externalSourceName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<ConnectorTypeElement> getConnectorTypesByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getConnectorTypesByName(this.userId, this.externalSourceGUID, this.externalSourceName, name, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<ConnectorTypeElement> getConnectorTypesForAssetManager(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getConnectorTypesForAssetManager(this.userId, this.externalSourceGUID, this.externalSourceName, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public ConnectorTypeElement getConnectorTypeByGUID(String userId, String externalSourceGUID, String externalSourceName, String dataAssetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getConnectorTypeByGUID(userId, externalSourceGUID, externalSourceName, dataAssetGUID, effectiveTime, this.forLineage, false);
    }
}

